/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.netty.codec.mappers;

import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.mockserver.mappers.ContentTypeMapper;
import org.mockserver.model.Body;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameter;

public class MockServerHttpRequestToFullHttpRequest {
    public FullHttpRequest mapMockServerResponseToHttpServletResponse(HttpRequest httpRequest) {
        HttpMethod httpMethod = HttpMethod.valueOf((String)httpRequest.getMethod("GET"));
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, httpMethod, this.getURI(httpRequest), this.getBody(httpRequest));
        this.setHeader(httpRequest, (FullHttpRequest)request);
        this.setCookies(httpRequest, (FullHttpRequest)request);
        return request;
    }

    public String getURI(HttpRequest httpRequest) {
        QueryStringEncoder queryStringEncoder = new QueryStringEncoder(httpRequest.getPath().getValue());
        for (Parameter parameter : httpRequest.getQueryStringParameters()) {
            for (NottableString value : parameter.getValues()) {
                queryStringEncoder.addParam(parameter.getName().getValue(), value.getValue());
            }
        }
        return queryStringEncoder.toString();
    }

    private ByteBuf getBody(HttpRequest httpRequest) {
        ByteBuf content = Unpooled.buffer((int)0, (int)0);
        Body body = httpRequest.getBody();
        if (body != null) {
            Object bodyContents = body.getValue();
            Charset bodyCharset = body.getCharset(ContentTypeMapper.determineCharsetForMessage(httpRequest));
            if (bodyContents instanceof byte[]) {
                content = Unpooled.copiedBuffer((byte[])((byte[])bodyContents));
            } else if (bodyContents instanceof String) {
                content = Unpooled.copiedBuffer((byte[])((String)bodyContents).getBytes(bodyCharset));
            } else if (body.toString() != null) {
                content = Unpooled.copiedBuffer((byte[])body.toString().getBytes(bodyCharset));
            }
        }
        return content;
    }

    private void setCookies(HttpRequest httpRequest, FullHttpRequest request) {
        ArrayList<DefaultCookie> cookies = new ArrayList<DefaultCookie>();
        for (Cookie cookie : httpRequest.getCookies()) {
            cookies.add(new DefaultCookie(cookie.getName().getValue(), cookie.getValue().getValue()));
        }
        if (cookies.size() > 0) {
            request.headers().set(HttpHeaderNames.COOKIE.toString(), (Object)ClientCookieEncoder.LAX.encode(cookies));
        }
    }

    private void setHeader(HttpRequest httpRequest, FullHttpRequest request) {
        for (Header header : httpRequest.getHeaders()) {
            String headerName = header.getName().getValue();
            if (headerName.equalsIgnoreCase(HttpHeaderNames.CONTENT_LENGTH.toString()) || headerName.equalsIgnoreCase(HttpHeaderNames.TRANSFER_ENCODING.toString()) || headerName.equalsIgnoreCase(HttpHeaderNames.HOST.toString()) || headerName.equalsIgnoreCase(HttpHeaderNames.ACCEPT_ENCODING.toString())) continue;
            if (!header.getValues().isEmpty()) {
                for (NottableString headerValue : header.getValues()) {
                    request.headers().add(headerName, (Object)headerValue.getValue());
                }
                continue;
            }
            request.headers().add(headerName, (Object)"");
        }
        if (!Strings.isNullOrEmpty((String)httpRequest.getFirstHeader(HttpHeaderNames.HOST.toString()))) {
            request.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)httpRequest.getFirstHeader(HttpHeaderNames.HOST.toString()));
        }
        request.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)(HttpHeaderValues.GZIP + "," + HttpHeaderValues.DEFLATE));
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)request.content().readableBytes());
        if (HttpUtil.isKeepAlive((HttpMessage)request)) {
            request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        } else {
            request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        }
        if (!request.headers().contains((CharSequence)HttpHeaderNames.CONTENT_TYPE) && httpRequest.getBody() != null && httpRequest.getBody().getContentType() != null) {
            request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)httpRequest.getBody().getContentType());
        }
    }
}

