/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.xcap.client.impl;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.restcomm.xcap.client.impl.XcapEntityImpl;
import org.restcomm.xcap.client.impl.XcapResponseImpl;
import org.restcomm.xcap.client.impl.header.HeaderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XcapResponseHandler
implements ResponseHandler<XcapResponseImpl> {
    public XcapResponseImpl handleResponse(HttpResponse httpResponse) throws ClientProtocolException, IOException {
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        String eTag = null;
        String mimetype = null;
        if (statusCode == 200 || statusCode == 201) {
            Header mimetypeHeader;
            Header eTagHeader = httpResponse.getFirstHeader("ETag");
            if (eTagHeader != null) {
                eTag = eTagHeader.getValue();
            }
            if ((mimetypeHeader = httpResponse.getFirstHeader("Content-Type")) != null) {
                mimetype = mimetypeHeader.getValue();
            }
        }
        Header[] apacheHeaders = httpResponse.getAllHeaders();
        org.restcomm.xcap.client.header.Header[] headers = new org.restcomm.xcap.client.header.Header[apacheHeaders.length];
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = new HeaderImpl(apacheHeaders[i]);
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        XcapEntityImpl xcapEntity = httpEntity != null ? new XcapEntityImpl(httpEntity) : null;
        return new XcapResponseImpl(statusCode, eTag, mimetype, headers, xcapEntity);
    }
}

