/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.xcap.client.uri;

import java.net.URI;
import java.net.URISyntaxException;

public class UriBuilder {
    private String schemeAndAuthority;
    private String xcapRoot;
    private String documentSelector;
    private String elementSelector;
    private String terminalSelector;
    private String namespaceBindings;
    private static final String RESOURCE_SELECTOR_SEPARATOR = "/~~/";

    public String getSchemeAndAuthority() {
        return this.schemeAndAuthority;
    }

    public UriBuilder setSchemeAndAuthority(String schemeAndAuthority) {
        this.schemeAndAuthority = schemeAndAuthority;
        return this;
    }

    public String getXcapRoot() {
        return this.xcapRoot;
    }

    public UriBuilder setXcapRoot(String xcapRoot) throws IllegalArgumentException {
        if (xcapRoot.charAt(xcapRoot.length() - 1) != '/') {
            throw new IllegalArgumentException("xcap root must end with /");
        }
        this.xcapRoot = xcapRoot;
        return this;
    }

    public String getDocumentSelector() {
        return this.documentSelector;
    }

    public UriBuilder setDocumentSelector(String documentSelector) throws IllegalArgumentException {
        if (documentSelector.charAt(0) == '/') {
            throw new IllegalArgumentException("document selector must not start with /");
        }
        this.documentSelector = documentSelector;
        return this;
    }

    public String getElementSelector() {
        return this.elementSelector;
    }

    public UriBuilder setElementSelector(String elementSelector) throws IllegalArgumentException {
        if (elementSelector.charAt(0) == '/') {
            throw new IllegalArgumentException("element selector must not start with /");
        }
        this.elementSelector = elementSelector;
        return this;
    }

    public String getTerminalSelector() {
        return this.terminalSelector;
    }

    public UriBuilder setTerminalSelector(String terminalSelector) throws IllegalArgumentException {
        if (terminalSelector.charAt(0) == '/') {
            throw new IllegalArgumentException("terminal selector must not start with /");
        }
        this.terminalSelector = terminalSelector;
        return this;
    }

    public String getNamespaceBindings() {
        return this.namespaceBindings;
    }

    public UriBuilder setNamespaceBindings(String namespaceBindings) throws IllegalArgumentException {
        if (namespaceBindings.charAt(0) == '?') {
            throw new IllegalArgumentException("namespace bindings must not start with ?");
        }
        this.namespaceBindings = namespaceBindings;
        return this;
    }

    public URI toURI() throws URISyntaxException {
        StringBuilder sb = new StringBuilder(this.schemeAndAuthority);
        if (this.xcapRoot != null) {
            sb.append(this.xcapRoot);
        }
        sb.append(this.documentSelector);
        if (this.elementSelector != null) {
            sb.append(RESOURCE_SELECTOR_SEPARATOR).append(this.elementSelector);
            if (this.terminalSelector != null) {
                sb.append('/').append(this.terminalSelector);
            }
            if (this.namespaceBindings != null) {
                sb.append('?').append(this.namespaceBindings);
            }
        }
        return new URI(sb.toString());
    }
}

