/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.stack;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpListener;
import jain.protocol.ip.mgcp.JainMgcpProvider;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.JainMgcpStack;
import jain.protocol.ip.mgcp.message.AuditConnectionResponse;
import jain.protocol.ip.mgcp.message.AuditEndpointResponse;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.DeleteConnectionResponse;
import jain.protocol.ip.mgcp.message.ModifyConnectionResponse;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.NotifyResponse;
import jain.protocol.ip.mgcp.message.RestartInProgressResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.stack.AuditConnectionHandler;
import org.mobicents.mgcp.stack.AuditEndpointHandler;
import org.mobicents.mgcp.stack.CreateConnectionHandler;
import org.mobicents.mgcp.stack.DeleteConnectionHandler;
import org.mobicents.mgcp.stack.EndpointConfigurationHandler;
import org.mobicents.mgcp.stack.EndpointHandler;
import org.mobicents.mgcp.stack.JainMgcpExtendedListener;
import org.mobicents.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.mgcp.stack.ModifyConnectionHandler;
import org.mobicents.mgcp.stack.NotificationRequestHandler;
import org.mobicents.mgcp.stack.NotifyHandler;
import org.mobicents.mgcp.stack.RespUnknownHandler;
import org.mobicents.mgcp.stack.RestartInProgressHandler;
import org.mobicents.mgcp.stack.TransactionHandler;

public class JainMgcpStackProviderImpl
implements JainMgcpProvider {
    private static Logger logger = Logger.getLogger(JainMgcpStackProviderImpl.class);
    private final JainMgcpStackImpl runningStack;
    private static int MIN_TRANSACTION_HANDLE_ID = 1;
    private static int MAX_TRANSACTION_HANDLE_ID = 999999999;
    private static AtomicInteger transactionHandleCounter = new AtomicInteger(MIN_TRANSACTION_HANDLE_ID);
    private static AtomicLong callIdentifierCounter = new AtomicLong(1L);
    private static AtomicLong requestIdentifierCounter = new AtomicLong(1L);
    protected Set<JainMgcpListener> jainListeners = new HashSet<JainMgcpListener>();
    protected Set<JainMgcpExtendedListener> jainMobicentsListeners = new HashSet<JainMgcpExtendedListener>();
    protected NotifiedEntity notifiedEntity = null;

    public JainMgcpStackProviderImpl(JainMgcpStackImpl runningStack) {
        this.runningStack = runningStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJainMgcpListener(JainMgcpListener listener) throws TooManyListenersException {
        if (listener instanceof JainMgcpExtendedListener) {
            Set<JainMgcpExtendedListener> set = this.jainMobicentsListeners;
            synchronized (set) {
                this.jainMobicentsListeners.add((JainMgcpExtendedListener)listener);
            }
        }
        Set<JainMgcpListener> set = this.jainListeners;
        synchronized (set) {
            this.jainListeners.add(listener);
        }
    }

    public JainMgcpStack getJainMgcpStack() {
        return this.runningStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJainMgcpListener(JainMgcpListener listener) {
        if (listener instanceof JainMgcpExtendedListener) {
            Set<JainMgcpExtendedListener> set = this.jainMobicentsListeners;
            synchronized (set) {
                this.jainMobicentsListeners.remove((JainMgcpExtendedListener)listener);
            }
        }
        Set<JainMgcpListener> set = this.jainListeners;
        synchronized (set) {
            this.jainListeners.remove(listener);
        }
    }

    public synchronized void sendMgcpEvents(JainMgcpEvent[] events) throws IllegalArgumentException {
        for (JainMgcpEvent event : events) {
            EndpointHandler eh;
            boolean isWildcarded = false;
            if (event instanceof JainMgcpCommandEvent) {
                JainMgcpCommandEvent commandEvent = (JainMgcpCommandEvent)event;
                TransactionHandler handle = null;
                switch (commandEvent.getObjectIdentifier()) {
                    case 101: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending EndpointConfiguration object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new AuditConnectionHandler(this.runningStack);
                        break;
                    }
                    case 102: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending EndpointConfiguration object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new AuditEndpointHandler(this.runningStack);
                        break;
                    }
                    case 103: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending CreateConnection object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new CreateConnectionHandler(this.runningStack);
                        CreateConnection crcx = (CreateConnection)event;
                        isWildcarded = EndpointHandler.isAnyOfWildcard(crcx.getEndpointIdentifier().toString());
                        break;
                    }
                    case 104: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending DeleteConnection object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new DeleteConnectionHandler(this.runningStack);
                        break;
                    }
                    case 105: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending EndpointConfiguration object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new EndpointConfigurationHandler(this.runningStack);
                        break;
                    }
                    case 106: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending ModifyConnection object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new ModifyConnectionHandler(this.runningStack);
                        break;
                    }
                    case 107: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending NotificationRequest object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new NotificationRequestHandler(this.runningStack);
                        break;
                    }
                    case 108: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending Notify object to NotifiedEntity" + ((Notify)commandEvent).getNotifiedEntity()));
                        }
                        handle = new NotifyHandler(this.runningStack);
                        break;
                    }
                    case 300: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending ResponseUnknown object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new RespUnknownHandler(this.runningStack);
                        break;
                    }
                    case 109: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Sending RestartInProgress object to " + commandEvent.getEndpointIdentifier()));
                        }
                        handle = new RestartInProgressHandler(this.runningStack);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Could not send type of the message yet");
                    }
                }
                handle.setCommand(true);
                handle.setCommandEvent(commandEvent);
                eh = this.runningStack.getEndpointHandler(handle.getEndpointId(), isWildcarded);
                eh.addTransactionHandler(handle);
                eh.scheduleTransactionHandler(handle);
                continue;
            }
            int tid = event.getTransactionHandle();
            TransactionHandler handler = this.runningStack.getLocalTransactions().get(tid);
            if (handler != null) {
                handler.setCommand(false);
                handler.setResponseEvent((JainMgcpResponseEvent)event);
                eh = handler.getEndpointHandler();
                eh.scheduleTransactionHandler(handler);
                continue;
            }
            logger.error((Object)("The TransactionHandler not found for TransactionHandle " + tid + " May be the Tx timed out. Event = " + (JainMgcpResponseEvent)event));
        }
    }

    public int getUniqueTransactionHandler() {
        int next;
        int current;
        while (!transactionHandleCounter.compareAndSet(current, next = (current = transactionHandleCounter.get()) == MAX_TRANSACTION_HANDLE_ID ? MIN_TRANSACTION_HANDLE_ID : current + 1)) {
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMgcpResponseEvent(JainMgcpResponseEvent response, JainMgcpEvent command) {
        Set<JainMgcpListener> set = this.jainListeners;
        synchronized (set) {
            for (JainMgcpListener jainMgcpListener : this.jainListeners) {
                jainMgcpListener.processMgcpResponseEvent(response);
            }
        }
        set = this.jainMobicentsListeners;
        synchronized (set) {
            for (JainMgcpExtendedListener jainMgcpExtendedListener : this.jainMobicentsListeners) {
                jainMgcpExtendedListener.processMgcpResponseEvent(response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMgcpCommandEvent(JainMgcpCommandEvent command) {
        Set<JainMgcpListener> set = this.jainListeners;
        synchronized (set) {
            for (JainMgcpListener jainMgcpListener : this.jainListeners) {
                jainMgcpListener.processMgcpCommandEvent(command);
            }
        }
        set = this.jainMobicentsListeners;
        synchronized (set) {
            for (JainMgcpExtendedListener jainMgcpExtendedListener : this.jainMobicentsListeners) {
                jainMgcpExtendedListener.processMgcpCommandEvent(command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTxTimeout(JainMgcpCommandEvent command) {
        Set<JainMgcpExtendedListener> set = this.jainMobicentsListeners;
        synchronized (set) {
            for (JainMgcpExtendedListener listener : this.jainMobicentsListeners) {
                listener.transactionTxTimedOut(command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRxTimeout(JainMgcpCommandEvent command) {
        Set<JainMgcpExtendedListener> set = this.jainMobicentsListeners;
        synchronized (set) {
            for (JainMgcpExtendedListener listener : this.jainMobicentsListeners) {
                listener.transactionRxTimedOut(command);
            }
        }
        AuditConnectionResponse response = null;
        switch (command.getObjectIdentifier()) {
            case 101: {
                response = new AuditConnectionResponse((Object)this, ReturnCode.Transient_Error);
                break;
            }
            case 102: {
                response = new AuditEndpointResponse((Object)this, ReturnCode.Transient_Error);
                break;
            }
            case 103: {
                response = new CreateConnectionResponse((Object)this, ReturnCode.Transient_Error, new ConnectionIdentifier(Long.toHexString(new Random(System.currentTimeMillis()).nextLong())));
                break;
            }
            case 104: {
                response = new DeleteConnectionResponse((Object)this, ReturnCode.Transient_Error);
                break;
            }
            case 105: {
                response = new DeleteConnectionResponse((Object)this, ReturnCode.Transient_Error);
                break;
            }
            case 106: {
                response = new ModifyConnectionResponse((Object)this, ReturnCode.Transient_Error);
                break;
            }
            case 107: {
                response = new NotificationRequestResponse((Object)this, ReturnCode.Transient_Error);
                break;
            }
            case 108: {
                response = new NotifyResponse((Object)this, ReturnCode.Transient_Error);
                break;
            }
            case 300: {
                response = new NotifyResponse((Object)this, ReturnCode.Transient_Error);
                break;
            }
            case 109: {
                response = new RestartInProgressResponse((Object)this, ReturnCode.Transient_Error);
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not send type of the message yet");
            }
        }
        response.setTransactionHandle(command.getTransactionHandle());
        JainMgcpEvent[] events = new JainMgcpEvent[]{response};
        this.sendMgcpEvents(events);
    }

    public CallIdentifier getUniqueCallIdentifier() {
        long current = -1L;
        boolean b = true;
        while (b) {
            current = callIdentifierCounter.get();
            if (current == Long.MAX_VALUE) {
                b = !callIdentifierCounter.compareAndSet(current, 1L);
                continue;
            }
            b = !callIdentifierCounter.compareAndSet(current, current + 1L);
        }
        return new CallIdentifier(Long.toHexString(current));
    }

    public RequestIdentifier getUniqueRequestIdentifier() {
        long current = -1L;
        boolean b = true;
        while (b) {
            current = requestIdentifierCounter.get();
            if (current == Long.MAX_VALUE) {
                b = !requestIdentifierCounter.compareAndSet(current, 1L);
                continue;
            }
            b = !requestIdentifierCounter.compareAndSet(current, current + 1L);
        }
        return new RequestIdentifier(Long.toHexString(current));
    }

    public void setNotifiedEntity(NotifiedEntity notifiedEntity) {
        this.notifiedEntity = notifiedEntity;
    }

    public NotifiedEntity getNotifiedEntity() {
        return this.notifiedEntity;
    }
}

