/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.stack;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.stack.EndpointHandler;
import org.mobicents.mgcp.stack.handlers.EndpointHandlerManager;

public class EndpointHandlerFactory {
    private static Logger logger = Logger.getLogger(EndpointHandlerFactory.class);
    private int size = 0;
    private int count = 0;
    private EndpointHandlerManager jainMgcpStackImpl = null;
    private List<EndpointHandler> list = new ArrayList<EndpointHandler>();

    public EndpointHandlerFactory(int size, EndpointHandlerManager jainMgcpStackImpl) {
        this.size = size;
        this.jainMgcpStackImpl = jainMgcpStackImpl;
    }

    public EndpointHandler allocate(String endpoint) {
        EndpointHandler handler = null;
        if (!this.list.isEmpty()) {
            handler = this.list.remove(0);
            handler.init(endpoint);
            return handler;
        }
        handler = new EndpointHandler(this.jainMgcpStackImpl, this);
        handler.init(endpoint);
        ++this.count;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("EndpointHandlerFactory underflow. Count = " + this.count));
        }
        return handler;
    }

    public void deallocate(EndpointHandler handler) {
        if (this.list.size() < this.size && handler != null) {
            this.list.add(handler);
        }
    }

    public int getSize() {
        return this.size;
    }

    public int getCount() {
        return this.count;
    }
}

