/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.stack;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.stack.EndpointHandler;
import org.mobicents.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.mgcp.stack.ReceivedTransactionID;
import org.mobicents.mgcp.stack.handlers.TransactionHandlerManagement;
import org.mobicents.mgcp.stack.parser.UtilsFactory;

public abstract class TransactionHandler
implements Runnable,
TransactionHandlerManagement {
    private static final Logger logger = Logger.getLogger(TransactionHandler.class);
    private static int GENERATOR = 1;
    public static final String NEW_LINE = "\n";
    public static final String SINGLE_CHAR_SPACE = " ";
    public static final String MGCP_VERSION = " MGCP 1.0";
    public static final int LONGTRAN_TIMER_TIMEOUT = 5000;
    public static final int THIST_TIMER_TIMEOUT = 30000;
    protected boolean sent;
    protected int remoteTID;
    private int localTID;
    protected JainMgcpStackImpl stack;
    private InetAddress remoteAddress;
    private int remotePort;
    protected JainMgcpCommandEvent commandEvent;
    protected JainMgcpResponseEvent responseEvent;
    protected static Timer transactionHandlerTimer = new Timer("TransactionHandlerTimer");
    private LongtranTimerTask longtranTimerTask;
    private boolean isCommand = false;
    private ReTransmissionTimerTask reTransmissionTimer;
    private THISTTimerTask tHISTTimerTask;
    private int A = 0;
    private int D = 2;
    private int N = 2;
    private DatagramPacket sendComandDatagram = null;
    private int countOfCommandRetransmitted = 0;
    protected UtilsFactory utilsFactory = null;
    protected EndpointHandler endpointHandler = null;
    protected boolean retransmision;
    protected Object source = null;
    private String msgTemp = null;
    protected LinkedList<ActionPerform> actionToPerform = new LinkedList();

    public TransactionHandler(JainMgcpStackImpl stack) {
        this.stack = stack;
        this.localTID = GENERATOR++;
        this.utilsFactory = stack.getUtilsFactory();
        stack.getLocalTransactions().put(this.localTID, this);
    }

    public void setEndpointHandler(EndpointHandler handler) {
        this.endpointHandler = handler;
    }

    public EndpointHandler getEndpointHandler() {
        return this.endpointHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTxTimeout() {
        block9: {
            try {
                this.release(false);
                if (this.sent) {
                    try {
                        this.stack.provider.processTxTimeout(this.commandEvent);
                        break block9;
                    }
                    finally {
                        this.getEndpointHandler().processTxTimeout(this.commandEvent, this);
                    }
                }
                try {
                    this.stack.provider.processRxTimeout(this.commandEvent);
                }
                finally {
                    this.getEndpointHandler().processRxTimeout(this.commandEvent, this);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failed to release mgcp transaction localID=" + this.localTID), (Throwable)e);
            }
        }
    }

    private boolean isProvisional(ReturnCode rc) {
        int rval = rc.getValue();
        return 99 < rval && rval < 200;
    }

    public TransactionHandler(JainMgcpStackImpl stack, InetAddress remoteAddress, int port) {
        this(stack);
        this.remoteAddress = remoteAddress;
        this.remotePort = port;
        if (this.stack.provider.getNotifiedEntity() == null) {
            NotifiedEntity notifiedEntity = new NotifiedEntity(this.remoteAddress.getHostName(), this.remoteAddress.getHostAddress(), this.remotePort);
            this.stack.provider.setNotifiedEntity(notifiedEntity);
        }
    }

    protected void release(boolean removeEndpointHandler) {
        this.stack.getLocalTransactions().remove(this.localTID);
        this.stack.getRemoteTxToLocalTxMap().remove(this.remoteTID);
        this.cancelTHISTTimerTask();
        this.cancelLongtranTimer();
        this.cancelReTransmissionTimer();
        if (removeEndpointHandler) {
            this.clearEndpointHandler();
        }
    }

    public void clearEndpointHandler() {
        this.endpointHandler.transactionHandlerDeleted(this);
        this.endpointHandler = null;
    }

    public int getRemoteTID() {
        return this.remoteTID;
    }

    public int getLocalTID() {
        return this.localTID;
    }

    public abstract String encode(JainMgcpCommandEvent var1);

    public abstract String encode(JainMgcpResponseEvent var1);

    public abstract JainMgcpCommandEvent decodeCommand(String var1) throws ParseException;

    public abstract JainMgcpResponseEvent decodeResponse(String var1) throws ParseException;

    public abstract JainMgcpResponseEvent getProvisionalResponse();

    public void run() {
        try {
            ActionPerform ap = this.actionToPerform.remove();
            ap.perform();
        }
        catch (NoSuchElementException nsee) {
            System.out.println("Received NoSuchElementException for remoteeTx = " + this.remoteTID);
        }
    }

    protected void sendProvisionalResponse() {
        this.send(this.getProvisionalResponse());
    }

    private void send(JainMgcpCommandEvent event) {
        String msg;
        this.sent = true;
        String host = "";
        int port = 0;
        switch (event.getObjectIdentifier()) {
            case 108: {
                Notify notifyCommand = (Notify)event;
                NotifiedEntity notifiedEntity = notifyCommand.getNotifiedEntity();
                if (notifiedEntity == null) {
                    notifiedEntity = this.stack.provider.getNotifiedEntity();
                }
                port = notifiedEntity.getPortNumber();
                host = host + notifiedEntity.getDomainName();
                break;
            }
            default: {
                String domainName = event.getEndpointIdentifier().getDomainName();
                int pos = domainName.indexOf(58);
                if (pos > 0) {
                    port = Integer.parseInt(domainName.substring(pos + 1));
                    host = domainName.substring(0, pos);
                    break;
                }
                port = 2427;
                host = domainName;
            }
        }
        InetAddress address = null;
        try {
            address = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unknown endpoint " + host);
        }
        this.remoteTID = event.getTransactionHandle();
        this.source = event.getSource();
        event.setTransactionHandle(this.localTID);
        this.msgTemp = msg = this.encode(event);
        byte[] data = msg.getBytes();
        this.sendComandDatagram = new DatagramPacket(data, data.length, address, port);
        this.resetReTransmissionTimer();
        this.resetTHISTTimerTask(false);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Send command event to " + address + ", message\n" + msg));
        }
        ++this.countOfCommandRetransmitted;
        this.stack.send(this.sendComandDatagram);
        try {
            this.getEndpointHandler().commandDelivered(event, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void send(JainMgcpResponseEvent event) {
        this.cancelLongtranTimer();
        if (this.remoteAddress == null) {
            throw new IllegalArgumentException("Unknown orinator address");
        }
        event.setTransactionHandle(this.remoteTID);
        String msg = this.encode(event);
        byte[] data = msg.getBytes();
        DatagramPacket packet = new DatagramPacket(data, data.length, this.remoteAddress, this.remotePort);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("--- TransactionHandler:" + this + " :LocalID=" + this.localTID + ", Send response event to " + this.remoteAddress + ":" + this.remotePort + ", message\n" + msg));
        }
        this.stack.send(packet);
        if (this.isProvisional(event.getReturnCode())) {
            this.resetLongtranTimer();
        } else {
            try {
                this.getEndpointHandler().commandDelivered(this.commandEvent, event, this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.release(false);
            this.stack.getCompletedTransactions().put(event.getTransactionHandle(), this);
            this.resetTHISTTimerTask(true);
        }
    }

    private void cancelLongtranTimer() {
        if (this.longtranTimerTask != null) {
            this.longtranTimerTask.cancel();
            this.longtranTimerTask = null;
        }
    }

    private void resetLongtranTimer() {
        this.longtranTimerTask = new LongtranTimerTask();
        transactionHandlerTimer.schedule((TimerTask)this.longtranTimerTask, 5000L);
    }

    private void cancelReTransmissionTimer() {
        if (this.reTransmissionTimer != null) {
            this.reTransmissionTimer.cancel();
            this.reTransmissionTimer = null;
        }
    }

    private void resetReTransmissionTimer() {
        this.cancelReTransmissionTimer();
        this.reTransmissionTimer = new ReTransmissionTimerTask();
        transactionHandlerTimer.schedule((TimerTask)this.reTransmissionTimer, this.calculateReTransmissionTimeout());
    }

    private int calculateReTransmissionTimeout() {
        int reTransmissionTimeoutSec = this.A + this.N * this.D;
        this.N *= 2;
        return reTransmissionTimeoutSec * 1000;
    }

    private void cancelTHISTTimerTask() {
        if (this.tHISTTimerTask != null) {
            this.tHISTTimerTask.cancel();
            this.tHISTTimerTask = null;
        }
    }

    private void resetTHISTTimerTask(boolean responseSent) {
        this.cancelTHISTTimerTask();
        this.tHISTTimerTask = new THISTTimerTask(responseSent);
        transactionHandlerTimer.schedule((TimerTask)this.tHISTTimerTask, 30000L);
    }

    protected Object getObjectSource(int tid) {
        if (this.sent) {
            return this.stack;
        }
        return new ReceivedTransactionID(tid, this.remoteAddress.toString(), this.remotePort);
    }

    public boolean isCommand() {
        return this.isCommand;
    }

    public void setCommand(boolean isCommand) {
        this.isCommand = isCommand;
    }

    private JainMgcpCommandEvent getCommandEvent() {
        return this.commandEvent;
    }

    public void setCommandEvent(JainMgcpCommandEvent commandEvent) {
        this.commandEvent = commandEvent;
        this.actionToPerform.add(new ScheduleCommandSend());
    }

    private JainMgcpResponseEvent getResponseEvent() {
        return this.responseEvent;
    }

    public void setResponseEvent(JainMgcpResponseEvent responseEvent) {
        this.responseEvent = responseEvent;
        this.actionToPerform.add(new ScheduleCommandSend());
    }

    public void markRetransmision() {
        this.retransmision = true;
    }

    public void receiveRequest(String msg) {
        JainMgcpCommandEvent event = null;
        try {
            event = this.decodeCommand(msg);
        }
        catch (ParseException e) {
            logger.error((Object)"Coud not parse message: ", (Throwable)e);
            return;
        }
        this.sent = false;
        this.commandEvent = event;
        this.remoteTID = event.getTransactionHandle();
        this.stack.getRemoteTxToLocalTxMap().put(new Integer(this.remoteTID), new Integer(this.localTID));
        event.setTransactionHandle(this.localTID);
        this.resetLongtranTimer();
        this.actionToPerform.add(new ScheduleRequestReceival(this));
    }

    public void receiveResponse(String message) {
        this.cancelReTransmissionTimer();
        this.cancelLongtranTimer();
        JainMgcpResponseEvent event = null;
        try {
            event = this.decodeResponse(message);
        }
        catch (Exception e) {
            logger.error((Object)"Could not decode message: ", (Throwable)e);
        }
        event.setTransactionHandle(this.remoteTID);
        if (this.isProvisional(event.getReturnCode())) {
            this.resetLongtranTimer();
            this.actionToPerform.add(new ActionPerform(){

                public void perform() {
                }
            });
        } else {
            this.actionToPerform.add(new ScheduleResponseReceival(event, this));
        }
    }

    public String getEndpointId() {
        return this.commandEvent.getEndpointIdentifier().toString();
    }

    protected class ScheduleCommandSend
    extends ActionPerform {
        protected ScheduleCommandSend() {
        }

        public void perform() {
            try {
                if (TransactionHandler.this.isCommand) {
                    TransactionHandler.this.send(TransactionHandler.this.getCommandEvent());
                } else {
                    TransactionHandler.this.send(TransactionHandler.this.getResponseEvent());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected class ScheduleResponseReceival
    extends ActionPerform {
        protected JainMgcpResponseEvent event;
        protected TransactionHandler th;

        public ScheduleResponseReceival(JainMgcpResponseEvent event, TransactionHandler th) {
            this.event = null;
            this.th = null;
            this.th = th;
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform() {
            try {
                TransactionHandler.this.stack.provider.processMgcpResponseEvent(this.event, (JainMgcpEvent)TransactionHandler.this.commandEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    TransactionHandler.this.getEndpointHandler().commandDelivered(TransactionHandler.this.commandEvent, this.event, this.th);
                }
                finally {
                    TransactionHandler.this.release(true);
                }
            }
        }
    }

    protected class ScheduleRequestReceival
    extends ActionPerform {
        protected TransactionHandler th;

        public ScheduleRequestReceival(TransactionHandler th) {
            this.th = null;
            this.th = th;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform() {
            try {
                TransactionHandler.this.stack.provider.processMgcpCommandEvent(TransactionHandler.this.commandEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                TransactionHandler.this.getEndpointHandler().commandDelivered(TransactionHandler.this.commandEvent, this.th);
            }
        }
    }

    protected abstract class ActionPerform {
        protected ActionPerform() {
        }

        public abstract void perform();
    }

    private class THISTTimerTask
    extends TimerTask {
        boolean responseSent = false;

        THISTTimerTask(boolean responseSent) {
            this.responseSent = responseSent;
        }

        public void run() {
            if (!this.responseSent) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"T-HIST timeout processTxTimeout ");
                }
                try {
                    TransactionHandler.this.processTxTimeout();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to delete the jainMgcpResponseEvent for txId", (Throwable)e);
                }
            } else {
                Integer key = new Integer(TransactionHandler.this.remoteTID);
                TransactionHandler obj = TransactionHandler.this.stack.getCompletedTransactions().remove(key);
                obj.clearEndpointHandler();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("T-HIST timeout deleting Response for Tx = " + TransactionHandler.this.remoteTID + " Response = " + obj));
                }
                Object var2_3 = null;
            }
        }
    }

    private class ReTransmissionTimerTask
    extends TimerTask {
        private ReTransmissionTimerTask() {
        }

        public void run() {
            try {
                TransactionHandler.this.countOfCommandRetransmitted++;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Tx ID = " + TransactionHandler.this.localTID + " Sending the Command " + TransactionHandler.this.countOfCommandRetransmitted));
                }
                System.out.println("message = \n" + TransactionHandler.this.msgTemp + "\n local Tx ID = " + TransactionHandler.this.localTID + " Remote Tx ID = " + TransactionHandler.this.remoteTID + " Sending the Command " + TransactionHandler.this.countOfCommandRetransmitted);
                TransactionHandler.this.stack.send(TransactionHandler.this.sendComandDatagram);
                TransactionHandler.this.resetReTransmissionTimer();
            }
            catch (Exception e) {
                logger.error((Object)("Failed to release mgcp transaction localID=" + TransactionHandler.this.localTID), (Throwable)e);
            }
        }
    }

    private class LongtranTimerTask
    extends TimerTask {
        private LongtranTimerTask() {
        }

        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Transaction localID=" + TransactionHandler.this.localTID + " timeout"));
                TransactionHandler.this.processTxTimeout();
            }
        }
    }
}

