/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.stack;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.parms.DigitMap;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.mgcp.stack.TransactionHandler;
import org.mobicents.mgcp.stack.parser.MgcpContentHandler;
import org.mobicents.mgcp.stack.parser.MgcpMessageParser;
import org.mobicents.mgcp.stack.parser.Utils;

public class NotificationRequestHandler
extends TransactionHandler {
    private static final Logger logger = Logger.getLogger(NotificationRequestHandler.class);
    private NotificationRequest command;
    private NotificationRequestResponse response;

    public NotificationRequestHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public NotificationRequestHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    public JainMgcpCommandEvent decodeCommand(String message) throws ParseException {
        Utils utils = this.utilsFactory.allocate();
        MgcpMessageParser parser = new MgcpMessageParser(new CommandContentHandle(utils));
        try {
            parser.parse(message);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), -1);
        }
        finally {
            this.utilsFactory.deallocate(utils);
        }
        NotifiedEntity notifiedEntity = this.command.getNotifiedEntity();
        if (this.command.getNotifiedEntity() != null) {
            this.stack.provider.setNotifiedEntity(notifiedEntity);
        }
        return this.command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JainMgcpResponseEvent decodeResponse(String message) throws ParseException {
        Utils utils = this.utilsFactory.allocate();
        MgcpMessageParser parser = new MgcpMessageParser(new ResponseContentHandle(utils));
        try {
            parser.parse(message);
        }
        catch (IOException e) {
            logger.error((Object)"Decode RQNT Response failed", (Throwable)e);
        }
        finally {
            this.utilsFactory.deallocate(utils);
        }
        return this.response;
    }

    public String encode(JainMgcpCommandEvent event) {
        Utils utils = this.utilsFactory.allocate();
        NotificationRequest req = (NotificationRequest)event;
        StringBuffer buffer = new StringBuffer();
        buffer.append("RQNT ").append(event.getTransactionHandle()).append(" ").append(req.getEndpointIdentifier()).append(" ").append(" MGCP 1.0").append("\n");
        if (req.getNotifiedEntity() != null) {
            buffer.append("N:").append(req.getNotifiedEntity()).append("\n");
        }
        buffer.append("X:").append(req.getRequestIdentifier()).append("\n");
        if (req.getDigitMap() != null) {
            buffer.append("D:").append(req.getDigitMap()).append("\n");
        }
        if (req.getSignalRequests() != null) {
            buffer.append("S:").append(utils.encodeEventNames(req.getSignalRequests())).append("\n");
        }
        if (req.getRequestedEvents() != null) {
            buffer.append("R:").append(utils.encodeRequestedEvents(req.getRequestedEvents())).append("\n");
        }
        if (req.getDetectEvents() != null) {
            buffer.append("T:").append(utils.encodeEventNames(req.getDetectEvents())).append("\n");
        }
        this.utilsFactory.deallocate(utils);
        return buffer.toString();
    }

    public String encode(JainMgcpResponseEvent event) {
        NotificationRequestResponse response = (NotificationRequestResponse)event;
        ReturnCode returnCode = response.getReturnCode();
        String encodedEvent = new StringBuffer().append(returnCode.getValue()).append(" ").append(response.getTransactionHandle()).append(" ").append(returnCode.getComment()).append("\n").toString();
        return encodedEvent;
    }

    public JainMgcpResponseEvent getProvisionalResponse() {
        NotificationRequestResponse provisionalresponse = null;
        if (!this.sent) {
            provisionalresponse = new NotificationRequestResponse(this.source != null ? this.source : this.stack, ReturnCode.Transaction_Being_Executed);
        }
        return provisionalresponse;
    }

    private class ResponseContentHandle
    implements MgcpContentHandler {
        private Utils utils;

        public ResponseContentHandle(Utils utils) {
            this.utils = utils;
        }

        public void header(String header) throws ParseException {
            String[] tokens = this.utils.splitStringBySpace(header);
            int tid = Integer.parseInt(tokens[1]);
            NotificationRequestHandler.this.response = new NotificationRequestResponse(NotificationRequestHandler.this.source != null ? NotificationRequestHandler.this.source : NotificationRequestHandler.this.stack, this.utils.decodeReturnCode(Integer.parseInt(tokens[0])));
            NotificationRequestHandler.this.response.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void sessionDescription(String sd) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class CommandContentHandle
    implements MgcpContentHandler {
        private Utils utils = null;

        public CommandContentHandle(Utils utils) {
            this.utils = utils;
        }

        public void header(String header) throws ParseException {
            String[] tokens = this.utils.splitStringBySpace(header);
            String transactionID = tokens[1].trim();
            int tid = Integer.parseInt(transactionID);
            EndpointIdentifier endpoint = this.utils.decodeEndpointIdentifier(tokens[2].trim());
            NotificationRequestHandler.this.command = new NotificationRequest(NotificationRequestHandler.this.getObjectSource(tid), endpoint, new RequestIdentifier("0"));
            NotificationRequestHandler.this.command.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
            if (name.equalsIgnoreCase("N")) {
                NotificationRequestHandler.this.command.setNotifiedEntity(this.utils.decodeNotifiedEntity(value, true));
            } else if (name.equalsIgnoreCase("X")) {
                NotificationRequestHandler.this.command.setRequestIdentifier(new RequestIdentifier(value));
            } else if (name.equalsIgnoreCase("R")) {
                NotificationRequestHandler.this.command.setRequestedEvents(this.utils.decodeRequestedEventList(value));
            } else if (name.equalsIgnoreCase("S")) {
                NotificationRequestHandler.this.command.setSignalRequests(this.utils.decodeEventNames(value));
            } else if (name.equalsIgnoreCase("T")) {
                NotificationRequestHandler.this.command.setDetectEvents(this.utils.decodeEventNames(value));
            } else if (name.equalsIgnoreCase("D")) {
                NotificationRequestHandler.this.command.setDigitMap(new DigitMap(value));
            }
        }

        public void sessionDescription(String sd) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

