/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.stack;

import jain.protocol.ip.mgcp.CreateProviderException;
import jain.protocol.ip.mgcp.DeleteProviderException;
import jain.protocol.ip.mgcp.JainMgcpProvider;
import jain.protocol.ip.mgcp.JainMgcpStack;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.stack.EndpointHandler;
import org.mobicents.mgcp.stack.EndpointHandlerFactory;
import org.mobicents.mgcp.stack.JainMgcpStackProviderImpl;
import org.mobicents.mgcp.stack.MessageHandler;
import org.mobicents.mgcp.stack.PacketRepresentation;
import org.mobicents.mgcp.stack.ThreadPoolQueueExecutor;
import org.mobicents.mgcp.stack.TransactionHandler;
import org.mobicents.mgcp.stack.handlers.EndpointHandlerManager;
import org.mobicents.mgcp.stack.parser.UtilsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JainMgcpStackImpl
extends Thread
implements JainMgcpStack,
EndpointHandlerManager {
    public static final String _EXECUTOR_TABLE_SIZE = "executorTableSize";
    public static final String _EXECUTOR_QUEUE_SIZE = "executorQueueSize";
    public static final String _MESSAGE_READER_THREAD_PRIORITY = "messageReaderThreadPriority";
    public static final String _MESSAGE_DISPATCHER_THREAD_PRIORITY = "messageDispatcherThreadPriority";
    public static final String _MESSAGE_EXECUTOR_THREAD_PRIORITY = "messageExecutorThreadPriority";
    private static final Logger logger = Logger.getLogger(JainMgcpStackImpl.class);
    private static final String propertiesFileName = "mgcp-stack.properties";
    private String protocolVersion = "1.0";
    protected int port = 2727;
    private DatagramSocket socket;
    private InetAddress localAddress = null;
    private boolean stopped = true;
    private int executorTableSize = 50;
    private int executorQueueSize = -1;
    private int messageReaderThreadPriority = 10;
    private int messageDispatcherThreadPriority = 7;
    private int messageExecutorThreadPriority = 1;
    private ThreadPoolQueueExecutor[] executors = null;
    private int executorPosition = 0;
    private UtilsFactory utilsFactory = null;
    private EndpointHandlerFactory ehFactory = null;
    public JainMgcpStackProviderImpl provider;
    private ConcurrentHashMap<Integer, TransactionHandler> localTransactions = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, Integer> remoteTxToLocalTxMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, TransactionHandler> completedTransactions = new ConcurrentHashMap();
    private SortedMap<String, EndpointHandler> endpointHandlers = Collections.synchronizedSortedMap(new TreeMap(new StringComparator()));
    protected LinkedList<PacketRepresentation> rawQueue = new LinkedList();
    protected ThreadPoolQueueExecutor eventSchedulerExecutor = null;
    protected MessageHandler messageHandler = null;

    public JainMgcpStackImpl(InetAddress localAddress, int port) {
        this.port = port;
        this.readProperties();
        this.initExecutors();
        if (this.socket == null) {
            while (true) {
                try {
                    InetSocketAddress bindAddress = new InetSocketAddress(localAddress, port);
                    this.socket = new DatagramSocket(bindAddress);
                    this.localAddress = this.socket.getLocalAddress();
                    logger.info((Object)("Jain Mgcp stack bound to IP " + this.localAddress + " and UDP port " + this.port));
                }
                catch (SocketException e) {
                    logger.error((Object)("Failed to bound to local port " + this.port + ". Caused by"), (Throwable)e);
                    if (this.port != port + 10) {
                        ++this.port;
                        continue;
                    }
                    throw new RuntimeException("Failed to find a local port to bound stack");
                }
                break;
            }
        }
        this.stopped = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting main thread " + this));
        }
        this.provider = new JainMgcpStackProviderImpl(this);
        this.utilsFactory = new UtilsFactory(25);
        this.ehFactory = new EndpointHandlerFactory(50, this);
        this.messageHandler = new MessageHandler(this);
        this.eventSchedulerExecutor.execute(new EventSchedulerTask());
        this.setPriority(this.messageReaderThreadPriority);
        this.setDaemon(false);
        this.start();
    }

    private void readProperties() {
        try {
            Properties props = new Properties();
            InputStream is = this.getClass().getResourceAsStream(propertiesFileName);
            if (is == null) {
                logger.error((Object)"Failed to locate properties file, using default values");
                return;
            }
            props.load(is);
            String val = null;
            val = props.getProperty(_EXECUTOR_TABLE_SIZE, "" + this.executorTableSize);
            this.executorTableSize = Integer.parseInt(val);
            val = null;
            val = props.getProperty(_EXECUTOR_QUEUE_SIZE, "" + this.executorQueueSize);
            this.executorQueueSize = Integer.parseInt(val);
            val = null;
            val = props.getProperty(_MESSAGE_READER_THREAD_PRIORITY, "" + this.messageReaderThreadPriority);
            this.messageReaderThreadPriority = Integer.parseInt(val);
            val = null;
            val = props.getProperty(_MESSAGE_DISPATCHER_THREAD_PRIORITY, "" + this.messageDispatcherThreadPriority);
            this.messageDispatcherThreadPriority = Integer.parseInt(val);
            val = null;
            val = props.getProperty(_MESSAGE_EXECUTOR_THREAD_PRIORITY, "" + this.messageExecutorThreadPriority);
            this.messageExecutorThreadPriority = Integer.parseInt(val);
            val = null;
            logger.info((Object)(propertiesFileName + " read successfully! \nexecutorTableSize = " + this.executorTableSize + "\nexecutorQueueSize = " + this.executorQueueSize + "\nmessageReaderThreadPriority = " + this.messageReaderThreadPriority + "\nmessageDispatcherThreadPriority = " + this.messageDispatcherThreadPriority + "\nmessageExecutorThreadPriority = " + this.messageExecutorThreadPriority));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to read properties file due to some error, using defualt values!!!!");
        }
    }

    private void initExecutors() {
        this.executors = new ThreadPoolQueueExecutor[this.executorTableSize];
        ThreadFactoryImpl th = new ThreadFactoryImpl();
        th.setPriority(this.messageExecutorThreadPriority);
        th.setDaemonFactory(true);
        for (int i = 0; i < this.executors.length; ++i) {
            this.executors[i] = this.executorQueueSize > 0 ? new ThreadPoolQueueExecutor(1, 1, new LinkedBlockingQueue<Runnable>(this.executorQueueSize)) : new ThreadPoolQueueExecutor(1, 1, new LinkedBlockingQueue<Runnable>());
            this.executors[i].setThreadFactory(th);
        }
        this.eventSchedulerExecutor = new ThreadPoolQueueExecutor(1, 1, new LinkedBlockingQueue<Runnable>());
        th = new ThreadFactoryImpl();
        th.setPriority(this.messageDispatcherThreadPriority);
        th.setDaemonFactory(true);
        this.eventSchedulerExecutor.setThreadFactory(th);
    }

    private void terminateExecutors() {
        this.eventSchedulerExecutor.shutdown();
        for (ThreadPoolQueueExecutor tpqe : this.executors) {
            if (tpqe == null) continue;
            tpqe.shutdown();
        }
    }

    public void close() {
        this.stopped = true;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Closing socket");
            }
            this.socket.close();
            this.terminateExecutors();
        }
        catch (Exception e) {
            logger.warn((Object)"Could not gracefully close socket", (Throwable)e);
        }
    }

    public JainMgcpProvider createProvider() throws CreateProviderException {
        return this.provider;
    }

    public void deleteProvider(JainMgcpProvider provider) throws DeleteProviderException {
    }

    public void setPort(int port) {
        throw new UnsupportedOperationException("this stack impl doesn't support port reconfiguring");
    }

    public int getPort() {
        return this.port;
    }

    public UtilsFactory getUtilsFactory() {
        return this.utilsFactory;
    }

    public void setUtilsFactory(UtilsFactory utilsFactory) {
        this.utilsFactory = utilsFactory;
    }

    public InetAddress getAddress() {
        if (this.localAddress != null) {
            return this.localAddress;
        }
        return null;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    protected synchronized void send(DatagramPacket packet) {
        try {
            this.socket.send(packet);
        }
        catch (IOException e) {
            logger.error((Object)"I/O Exception uccured, caused by", (Throwable)e);
        }
    }

    public boolean isRequest(String header) {
        return header.matches("[\\w]{4}(\\s|\\S)*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MGCP stack started successfully on " + this.localAddress + ":" + this.port));
        }
        byte[] buffer = new byte[86400];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        while (!this.stopped) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Waiting for packet delivery");
                }
                this.socket.receive(packet);
            }
            catch (IOException e) {
                if (this.stopped) break;
                logger.error((Object)"I/O exception occured:", (Throwable)e);
                continue;
            }
            byte[] data = new byte[packet.getLength()];
            System.arraycopy(packet.getData(), 0, data, 0, data.length);
            LinkedList<PacketRepresentation> linkedList = this.rawQueue;
            synchronized (linkedList) {
                this.rawQueue.add(new PacketRepresentation(data, packet.getAddress(), packet.getPort()));
                this.rawQueue.notify();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"MGCP stack stopped gracefully");
        }
    }

    @Override
    public synchronized EndpointHandler getEndpointHandler(String endpointId, boolean useFakeOnWildcard) {
        EndpointHandler eh = null;
        String _endpointId = endpointId.intern();
        if (useFakeOnWildcard) {
            eh = this.ehFactory.allocate(_endpointId);
            eh.setUseFake(true);
            this.endpointHandlers.put(eh.getFakeId(), eh);
        } else if (!this.endpointHandlers.containsKey(_endpointId)) {
            eh = this.ehFactory.allocate(_endpointId);
            this.endpointHandlers.put(_endpointId, eh);
        } else {
            eh = (EndpointHandler)this.endpointHandlers.get(_endpointId);
        }
        return eh;
    }

    @Override
    public synchronized void removeEndpointHandler(String endpointId) {
        EndpointHandler eh = (EndpointHandler)this.endpointHandlers.remove(endpointId.intern());
    }

    @Override
    public synchronized EndpointHandler switchMapping(String fakeId, String specificEndpointId) {
        EndpointHandler eh = (EndpointHandler)this.endpointHandlers.get(specificEndpointId);
        if (eh == null) {
            eh = (EndpointHandler)this.endpointHandlers.remove(fakeId);
            this.endpointHandlers.put(specificEndpointId, eh);
            eh.setUseFake(false);
            eh = null;
        }
        return eh;
    }

    @Override
    public ThreadPoolQueueExecutor getNextExecutor() {
        return this.executors[this.executorPosition++ % this.executorTableSize];
    }

    public Map<Integer, TransactionHandler> getLocalTransactions() {
        return this.localTransactions;
    }

    public Map<Integer, Integer> getRemoteTxToLocalTxMap() {
        return this.remoteTxToLocalTxMap;
    }

    public Map<Integer, TransactionHandler> getCompletedTransactions() {
        return this.completedTransactions;
    }

    static class ThreadFactoryImpl
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;
        protected int priority = 5;
        protected boolean isDaemonFactory = false;

        ThreadFactoryImpl() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "JainMgcpStackImpl-FixedThreadPool-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 5L);
            t.setDaemon(this.isDaemonFactory);
            t.setPriority(this.priority);
            return t;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public boolean isDaemonFactory() {
            return this.isDaemonFactory;
        }

        public void setDaemonFactory(boolean isDaemonFactory) {
            this.isDaemonFactory = isDaemonFactory;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class StringComparator
    implements Comparator<String> {
        protected StringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }

    protected class EventSchedulerTask
    implements Runnable {
        boolean runSwitch = true;

        protected EventSchedulerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LinkedList<PacketRepresentation> linkedList = JainMgcpStackImpl.this.rawQueue;
            synchronized (linkedList) {
                while (this.runSwitch) {
                    if (JainMgcpStackImpl.this.rawQueue.size() == 0) {
                        try {
                            JainMgcpStackImpl.this.rawQueue.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            return;
                        }
                    }
                    PacketRepresentation pr = JainMgcpStackImpl.this.rawQueue.remove();
                    JainMgcpStackImpl.this.messageHandler.scheduleMessages(pr);
                }
            }
        }

        public boolean isRunSwitch() {
            return this.runSwitch;
        }

        public void setRunSwitch(boolean runSwitch) {
            this.runSwitch = runSwitch;
        }
    }
}

