/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.stack;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.DeleteConnectionResponse;
import jain.protocol.ip.mgcp.message.ModifyConnection;
import jain.protocol.ip.mgcp.message.ModifyConnectionResponse;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.RequestedEvent;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.stack.EndpointHandlerFactory;
import org.mobicents.mgcp.stack.MgcpResponseType;
import org.mobicents.mgcp.stack.ThreadPoolQueueExecutor;
import org.mobicents.mgcp.stack.handlers.EndpointHandlerManager;
import org.mobicents.mgcp.stack.handlers.TransactionHandlerManagement;

public class EndpointHandler {
    protected static final Logger logger = Logger.getLogger(EndpointHandler.class);
    protected TreeSet<ConnectionIdentifier> connectionIds = new TreeSet<ConnectionIdentifier>(new Comparator<ConnectionIdentifier>(){

        @Override
        public int compare(ConnectionIdentifier o1, ConnectionIdentifier o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.toString().compareTo(o2.toString());
        }
    });
    protected ThreadPoolQueueExecutor executor = null;
    protected List<TransactionHandlerManagement> ongoingTransactions = new ArrayList<TransactionHandlerManagement>();
    protected EndpointHandlerManager stack = null;
    protected String endpointId = null;
    protected String fakeId = null;
    protected boolean useFakeId = false;
    private EndpointHandlerFactory factory = null;
    protected Set<RequestedEvent> requestedEvents = new TreeSet<RequestedEvent>(new Comparator<RequestedEvent>(){

        @Override
        public int compare(RequestedEvent o1, RequestedEvent o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.toString().compareTo(o2.toString());
        }
    });

    public EndpointHandler(EndpointHandlerManager jainMgcpStackImpl, EndpointHandlerFactory factory) {
        this.stack = jainMgcpStackImpl;
        this.factory = factory;
    }

    public void init(String endpointId) {
        this.endpointId = endpointId;
        this.fakeId = new UID().toString();
        this.executor = this.stack.getNextExecutor();
    }

    public String getFakeId() {
        return this.fakeId;
    }

    public void addTransactionHandler(TransactionHandlerManagement handler) {
        this.ongoingTransactions.add(handler);
        handler.setEndpointHandler(this);
    }

    public void scheduleTransactionHandler(TransactionHandlerManagement th) {
        this.executor.execute(th);
    }

    public void commandDelivered(JainMgcpCommandEvent commandEvent, TransactionHandlerManagement handler) {
    }

    public void commandDelivered(JainMgcpCommandEvent commandEvent, JainMgcpResponseEvent event, TransactionHandlerManagement handler) {
        if (commandEvent instanceof CreateConnection) {
            CreateConnection ccRequest = (CreateConnection)commandEvent;
            CreateConnectionResponse ccResponse = (CreateConnectionResponse)event;
            int responseCode = ccResponse.getReturnCode().getValue();
            MgcpResponseType type = MgcpResponseType.getResponseTypeFromCode(responseCode);
            switch (type) {
                case SuccessResponse: {
                    EndpointIdentifier specificEndpointId = ccResponse.getSpecificEndpointIdentifier();
                    if (specificEndpointId != null && this.endpointId.compareTo(specificEndpointId.toString()) == 0) {
                        this.connectionIds.add(ccResponse.getConnectionIdentifier());
                        if (ccRequest.getNotificationRequestParms() == null) break;
                        this.processRequestedEvents(ccRequest.getNotifiedEntity(), ccRequest.getNotificationRequestParms().getRequestedEvents());
                        break;
                    }
                    if (EndpointHandler.isAnyOfWildcard(this.endpointId)) {
                        this.endpointId = specificEndpointId.toString();
                        EndpointHandler concurrent = this.stack.switchMapping(this.fakeId, specificEndpointId.toString());
                        if (concurrent != null) {
                            this.endpointId = this.fakeId;
                            this.ongoingTransactions.remove(handler);
                            concurrent.addTransactionHandler(handler);
                            concurrent.commandDelivered(commandEvent, event, handler);
                            break;
                        }
                        this.commandDelivered(commandEvent, event, handler);
                        break;
                    }
                    logger.error((Object)("Wrong endpoitn id, local: " + this.endpointId + ", fakeId: " + this.fakeId + ", id in response: " + specificEndpointId));
                    break;
                }
            }
        } else if (commandEvent instanceof NotificationRequest) {
            NotificationRequest nRequest = (NotificationRequest)commandEvent;
            NotificationRequestResponse nrResponse = (NotificationRequestResponse)event;
            int responseCode = nrResponse.getReturnCode().getValue();
            MgcpResponseType type = MgcpResponseType.getResponseTypeFromCode(responseCode);
            switch (type) {
                case ProvisionalResponse: {
                    return;
                }
                case SuccessResponse: {
                    if (this.endpointId.equals(nRequest.getEndpointIdentifier().toString())) {
                        this.processRequestedEvents(nRequest.getNotifiedEntity(), nRequest.getRequestedEvents());
                        break;
                    }
                    if (!EndpointHandler.isWildCardEndpointName(nRequest.getEndpointIdentifier().toString())) break;
                    break;
                }
            }
        } else if (commandEvent instanceof ModifyConnection) {
            ModifyConnection mcRequest = (ModifyConnection)commandEvent;
            ModifyConnectionResponse mcResponse = (ModifyConnectionResponse)event;
            int responseCode = mcResponse.getReturnCode().getValue();
            MgcpResponseType type = MgcpResponseType.getResponseTypeFromCode(responseCode);
            switch (type) {
                case ProvisionalResponse: {
                    return;
                }
                case SuccessResponse: {
                    if (this.endpointId.equals(mcRequest.getEndpointIdentifier().toString())) {
                        if (mcRequest.getNotificationRequestParms() == null) break;
                        this.processRequestedEvents(mcRequest.getNotifiedEntity(), mcRequest.getNotificationRequestParms().getRequestedEvents());
                        break;
                    }
                    logger.error((Object)("Wrong EndpoiontId on " + event.getClass().getSimpleName() + " event. This should be set to valid EId, this EId: " + this.endpointId));
                    break;
                }
            }
        } else if (commandEvent instanceof DeleteConnection) {
            DeleteConnection dcRequest = (DeleteConnection)commandEvent;
            DeleteConnectionResponse dcResponse = (DeleteConnectionResponse)event;
            int responseCode = dcResponse.getReturnCode().getValue();
            MgcpResponseType type = MgcpResponseType.getResponseTypeFromCode(responseCode);
            switch (type) {
                case ProvisionalResponse: {
                    return;
                }
                case SuccessResponse: {
                    if (this.endpointId.equals(dcRequest.getEndpointIdentifier().toString())) {
                        if (dcRequest.getNotificationRequestParms() != null) {
                            this.processRequestedEvents(null, dcRequest.getNotificationRequestParms().getRequestedEvents());
                        }
                        if (dcRequest.getConnectionIdentifier() != null) {
                            this.connectionIds.remove(dcRequest.getConnectionIdentifier());
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("Removing connection:" + dcRequest.getConnectionIdentifier() + " From:" + Arrays.toString(this.connectionIds.toArray()) + " ------ " + this));
                            break;
                        }
                        this.connectionIds.clear();
                        break;
                    }
                    logger.error((Object)("Wrong EndpoiontId on " + event.getClass().getSimpleName() + " event. This should be set to valid EId, this EId: " + this.endpointId));
                    break;
                }
            }
        }
        this.doEndChecks();
    }

    protected void processRequestedEvents(NotifiedEntity entity, RequestedEvent[] rEvents) {
        this.requestedEvents.clear();
        if (rEvents != null) {
            for (RequestedEvent re : rEvents) {
                this.requestedEvents.add(re);
            }
        }
    }

    public void processTxTimeout(JainMgcpCommandEvent commandEvent, TransactionHandlerManagement transactionHandler) {
        transactionHandler.clearEndpointHandler();
        this.doEndChecks();
    }

    public void processRxTimeout(JainMgcpCommandEvent commandEvent, TransactionHandlerManagement transactionHandler) {
        transactionHandler.clearEndpointHandler();
        this.doEndChecks();
    }

    public void transactionHandlerDeleted(TransactionHandlerManagement th) {
        this.ongoingTransactions.remove(th);
        th.setEndpointHandler(null);
        this.doEndChecks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEndChecks() {
        if (this.connectionIds.size() == 0 && this.ongoingTransactions.size() == 0) {
            try {
                if (EndpointHandler.isWildCardEndpointName(this.endpointId)) {
                    this.stack.removeEndpointHandler(this.fakeId);
                } else {
                    this.stack.removeEndpointHandler(this.endpointId);
                }
            }
            finally {
                this.factory.deallocate(this);
            }
        }
    }

    public static boolean isWildCardEndpointName(String endpointId) {
        return EndpointHandler.isAnyOfWildcard(endpointId) || EndpointHandler.isAllOfWildcard(endpointId);
    }

    public static boolean isAnyOfWildcard(String endpointId) {
        boolean flag = endpointId.contains("$");
        return flag;
    }

    public static boolean isAllOfWildcard(String endpointId) {
        return endpointId.contains("*");
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.hashCode() + " - EId: " + this.endpointId + ", Subscribed events: " + Arrays.toString(this.requestedEvents.toArray()) + ", connectionIds: " + Arrays.toString(this.connectionIds.toArray()) + ", Handlers: " + Arrays.toString(this.ongoingTransactions.toArray());
    }

    public void setUseFake(boolean b) {
        this.useFakeId = b;
    }
}

