/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.stack;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.stack.AuditConnectionHandler;
import org.mobicents.mgcp.stack.AuditEndpointHandler;
import org.mobicents.mgcp.stack.CreateConnectionHandler;
import org.mobicents.mgcp.stack.DeleteConnectionHandler;
import org.mobicents.mgcp.stack.EndpointConfigurationHandler;
import org.mobicents.mgcp.stack.EndpointHandler;
import org.mobicents.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.mgcp.stack.ModifyConnectionHandler;
import org.mobicents.mgcp.stack.NotificationRequestHandler;
import org.mobicents.mgcp.stack.NotifyHandler;
import org.mobicents.mgcp.stack.PacketRepresentation;
import org.mobicents.mgcp.stack.RestartInProgressHandler;
import org.mobicents.mgcp.stack.TransactionHandler;
import org.mobicents.mgcp.stack.parser.Utils;

public class MessageHandler {
    private JainMgcpStackImpl stack;
    private static Logger logger = Logger.getLogger(MessageHandler.class);
    private static final Pattern p = Pattern.compile("[\\w]{4}(\\s|\\S)*");
    private static final String pb = "\r?\n\\.\r?\n";
    private static final Pattern piggyDismountPattern = Pattern.compile("\r?\n\\.\r?\n");
    private Utils utils = null;

    public MessageHandler(JainMgcpStackImpl jainMgcpStackImpl) {
        this.stack = jainMgcpStackImpl;
        this.utils = new Utils();
    }

    public static String[] piggyDismount(String packet) {
        int idx = 0;
        ArrayList<String> mList = new ArrayList<String>();
        Matcher m = piggyDismountPattern.matcher(packet);
        while (m.find()) {
            mList.add(packet.substring(idx, m.start()) + "\n");
            idx = m.end();
        }
        mList.add(packet.substring(idx));
        String[] result = new String[mList.size()];
        return mList.toArray(result);
    }

    public boolean isRequest(String header) {
        char ch = (header = header.trim()).charAt(0);
        return !Character.isDigit(ch);
    }

    public void scheduleMessages(PacketRepresentation pr) {
        InetAddress address = pr.getRemoteAddress();
        int port = pr.getRemotePort();
        for (String msg : MessageHandler.piggyDismount(new String(pr.getRawData()))) {
            int pos = msg.indexOf("\n");
            String header = msg.substring(0, pos).trim();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message header: " + header));
            }
            String[] tokens = this.utils.splitStringBySpace(header);
            if (this.isRequest(header)) {
                TransactionHandler handler;
                String verb = tokens[0];
                String remoteTxIdString = tokens[1];
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Processing command message = " + verb + " remote Tx = " + remoteTxIdString));
                }
                Integer remoteTxIdIntegere = new Integer(remoteTxIdString);
                TransactionHandler completedTxHandler = this.stack.getCompletedTransactions().get(remoteTxIdIntegere);
                if (completedTxHandler != null) {
                    EndpointHandler eh = completedTxHandler.getEndpointHandler();
                    completedTxHandler.markRetransmision();
                    eh.scheduleTransactionHandler(completedTxHandler);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Received Command for which stack has already sent response Tx = " + verb + " " + remoteTxIdIntegere));
                    }
                    return;
                }
                Integer tmpLoaclTID = this.stack.getRemoteTxToLocalTxMap().get(remoteTxIdIntegere);
                if (tmpLoaclTID != null) {
                    TransactionHandler ongoingTxHandler = this.stack.getLocalTransactions().get(tmpLoaclTID);
                    ongoingTxHandler.sendProvisionalResponse();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Received Command for ongoing Tx = " + remoteTxIdIntegere));
                    }
                    return;
                }
                if (verb.equalsIgnoreCase("crcx")) {
                    handler = new CreateConnectionHandler(this.stack, address, port);
                } else if (verb.equalsIgnoreCase("mdcx")) {
                    handler = new ModifyConnectionHandler(this.stack, address, port);
                } else if (verb.equalsIgnoreCase("dlcx")) {
                    handler = new DeleteConnectionHandler(this.stack, address, port);
                } else if (verb.equalsIgnoreCase("epcf")) {
                    handler = new EndpointConfigurationHandler(this.stack, address, port);
                } else if (verb.equalsIgnoreCase("rqnt")) {
                    handler = new NotificationRequestHandler(this.stack, address, port);
                } else if (verb.equalsIgnoreCase("ntfy")) {
                    handler = new NotifyHandler(this.stack, address, port);
                } else if (verb.equalsIgnoreCase("rsip")) {
                    handler = new RestartInProgressHandler(this.stack, address, port);
                } else if (verb.equalsIgnoreCase("auep")) {
                    handler = new AuditEndpointHandler(this.stack, address, port);
                } else if (verb.equalsIgnoreCase("aucx")) {
                    handler = new AuditConnectionHandler(this.stack, address, port);
                } else {
                    logger.warn((Object)("Unsupported message verbose " + verb));
                    return;
                }
                handler.receiveRequest(msg);
                boolean useFakeOnWildcard = false;
                if (handler instanceof CreateConnectionHandler) {
                    useFakeOnWildcard = EndpointHandler.isAnyOfWildcard(handler.getEndpointId());
                }
                EndpointHandler eh = this.stack.getEndpointHandler(handler.getEndpointId(), useFakeOnWildcard);
                eh.addTransactionHandler(handler);
                eh.scheduleTransactionHandler(handler);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Processing response message");
            }
            String tid = tokens[1];
            TransactionHandler handler = this.stack.getLocalTransactions().get(Integer.valueOf(tid));
            if (handler == null) {
                logger.warn((Object)("---  Address:" + address + "\nPort:" + port + "\nID:" + this.hashCode() + "\n Unknown transaction: " + tid));
                return;
            }
            handler.receiveResponse(msg);
            EndpointHandler eh = handler.getEndpointHandler();
            eh.scheduleTransactionHandler(handler);
        }
    }
}

