/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.stack;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.AuditConnection;
import jain.protocol.ip.mgcp.message.AuditConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.ConnectionParm;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.InfoCode;
import jain.protocol.ip.mgcp.message.parms.LocalOptionValue;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.mgcp.stack.TransactionHandler;
import org.mobicents.mgcp.stack.parser.MgcpContentHandler;
import org.mobicents.mgcp.stack.parser.MgcpMessageParser;

public class AuditConnectionHandler
extends TransactionHandler {
    private static final Logger logger = Logger.getLogger(AuditConnectionHandler.class);
    private AuditConnection command;
    private AuditConnectionResponse response;
    private ConnectionIdentifier connectionIdentifier = null;
    private EndpointIdentifier endpointId = null;
    private InfoCode[] requestedInfo = null;
    int tid = 0;
    boolean RCfirst = false;

    public AuditConnectionHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public AuditConnectionHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    public JainMgcpCommandEvent decodeCommand(String message) throws ParseException {
        MgcpMessageParser parser = new MgcpMessageParser(new CommandContentHandle());
        try {
            parser.parse(message);
            this.command = new AuditConnection(this.getObjectSource(this.tid), this.endpointId, this.connectionIdentifier, this.requestedInfo);
            this.command.setTransactionHandle(this.tid);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), -1);
        }
        return this.command;
    }

    public JainMgcpResponseEvent decodeResponse(String message) throws ParseException {
        MgcpMessageParser parser = new MgcpMessageParser(new ResponseContentHandle());
        try {
            parser.parse(message);
        }
        catch (IOException e) {
            logger.error((Object)"Parsing of AUCX Response failed ", (Throwable)e);
        }
        return this.response;
    }

    public String encode(JainMgcpCommandEvent event) {
        InfoCode[] requestedInfos;
        AuditConnection evt = (AuditConnection)event;
        StringBuffer s = new StringBuffer();
        s.append("AUCX ").append(evt.getTransactionHandle()).append(" ").append(evt.getEndpointIdentifier()).append(" MGCP 1.0").append("\n");
        if (evt.getConnectionIdentifier() != null) {
            s.append("I:").append(evt.getConnectionIdentifier()).append("\n");
        }
        if ((requestedInfos = evt.getRequestedInfo()) != null) {
            s.append("F: ").append(this.utils.encodeInfoCodeList(requestedInfos));
            int foundRC = 0;
            int foundLC = 0;
            block4: for (int count = 0; count < requestedInfos.length; ++count) {
                InfoCode info = requestedInfos[count];
                switch (info.getInfoCode()) {
                    case 17: {
                        foundRC = count;
                        if (foundLC != 0 && foundLC < count) {
                            this.RCfirst = false;
                            continue block4;
                        }
                        this.RCfirst = true;
                        continue block4;
                    }
                    case 18: {
                        foundLC = count;
                        this.RCfirst = foundRC != 0 && foundRC < count;
                    }
                }
            }
        }
        return s.toString();
    }

    public String encode(JainMgcpResponseEvent event) {
        AuditConnectionResponse response = (AuditConnectionResponse)event;
        ReturnCode returnCode = response.getReturnCode();
        StringBuffer s = new StringBuffer();
        s.append(returnCode.getValue()).append(" ").append(response.getTransactionHandle()).append(" ").append(returnCode.getComment()).append("\n");
        if (response.getCallIdentifier() != null) {
            s.append("C:").append(response.getCallIdentifier()).append("\n");
        }
        if (response.getNotifiedEntity() != null) {
            s.append("N:").append(this.utils.encodeNotifiedEntity(response.getNotifiedEntity())).append("\n");
        }
        if (response.getLocalConnectionOptions() != null) {
            s.append("L:").append(this.utils.encodeLocalOptionValueList(response.getLocalConnectionOptions())).append("\n");
        }
        if (response.getMode() != null) {
            s.append("M:").append(response.getMode()).append("\n");
        }
        if (response.getConnectionParms() != null) {
            s.append("P:").append(this.utils.encodeConnectionParms(response.getConnectionParms())).append("\n");
        }
        if (this.RCfirst && response.getRemoteConnectionDescriptor() != null) {
            s.append("\n").append(response.getRemoteConnectionDescriptor()).append("\n");
        }
        if (response.getLocalConnectionDescriptor() != null) {
            s.append("\n").append(response.getLocalConnectionDescriptor()).append("\n");
        }
        if (!this.RCfirst && response.getRemoteConnectionDescriptor() != null) {
            s.append("\n").append(response.getRemoteConnectionDescriptor()).append("\n");
        }
        return s.toString();
    }

    public JainMgcpResponseEvent getProvisionalResponse() {
        AuditConnectionResponse provisionalResponse = null;
        if (!this.sent) {
            provisionalResponse = new AuditConnectionResponse(this.source != null ? this.source : this.stack, ReturnCode.Transaction_Being_Executed);
            provisionalResponse.setTransactionHandle(this.remoteTID);
        }
        return provisionalResponse;
    }

    static /* synthetic */ InfoCode[] access$202(AuditConnectionHandler x0, InfoCode[] x1) {
        x0.requestedInfo = x1;
        return x1;
    }

    private class ResponseContentHandle
    implements MgcpContentHandler {
        public void header(String header) throws ParseException {
            String[] tokens = AuditConnectionHandler.this.utils.splitStringBySpace(header);
            int tid = Integer.parseInt(tokens[1]);
            AuditConnectionHandler.this.response = new AuditConnectionResponse(AuditConnectionHandler.this.source != null ? AuditConnectionHandler.this.source : AuditConnectionHandler.this.stack, AuditConnectionHandler.this.utils.decodeReturnCode(Integer.parseInt(tokens[0])));
            AuditConnectionHandler.this.response.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
            if (name.equalsIgnoreCase("C")) {
                AuditConnectionHandler.this.response.setCallIdentifier(new CallIdentifier(value));
            } else if (name.equalsIgnoreCase("N")) {
                NotifiedEntity n = AuditConnectionHandler.this.utils.decodeNotifiedEntity(value, true);
                AuditConnectionHandler.this.response.setNotifiedEntity(n);
            } else if (name.equalsIgnoreCase("L")) {
                LocalOptionValue[] LocalOptionValueList = AuditConnectionHandler.this.utils.decodeLocalOptionValueList(value);
                AuditConnectionHandler.this.response.setLocalConnectionOptions(LocalOptionValueList);
            } else if (name.equalsIgnoreCase("M")) {
                ConnectionMode connectionMode = AuditConnectionHandler.this.utils.decodeConnectionMode(value);
                AuditConnectionHandler.this.response.setMode(connectionMode);
            } else if (name.equalsIgnoreCase("P")) {
                ConnectionParm[] connectionParms = AuditConnectionHandler.this.utils.decodeConnectionParms(value);
                AuditConnectionHandler.this.response.setConnectionParms(connectionParms);
            } else {
                logger.warn((Object)("Unidentified AUCX Response parameter " + name + " with value = " + value));
            }
        }

        public void sessionDescription(String sd) throws ParseException {
            StringReader stringReader = new StringReader(sd);
            BufferedReader reader = new BufferedReader(stringReader);
            String line = null;
            boolean sdpPresent = false;
            String sdp1 = "";
            String sdp2 = "";
            try {
                while ((line = reader.readLine()) != null) {
                    boolean bl = sdpPresent = (line = line.trim()).length() == 0;
                    if (sdpPresent) break;
                    sdp1 = sdp1 + line.trim() + "\r\n";
                }
                while ((line = reader.readLine()) != null) {
                    line = line.trim();
                    sdp2 = sdp2 + line.trim() + "\r\n";
                }
            }
            catch (IOException e) {
                logger.error((Object)"Error while reading the SDP for AUCX Response and decoding to AUCX command ", (Throwable)e);
            }
            if (AuditConnectionHandler.this.RCfirst) {
                AuditConnectionHandler.this.response.setRemoteConnectionDescriptor(new ConnectionDescriptor(sdp1));
                if (!sdp2.equals("")) {
                    AuditConnectionHandler.this.response.setLocalConnectionDescriptor(new ConnectionDescriptor(sdp2));
                }
            } else {
                AuditConnectionHandler.this.response.setLocalConnectionDescriptor(new ConnectionDescriptor(sdp1));
                if (!sdp2.equals("")) {
                    AuditConnectionHandler.this.response.setRemoteConnectionDescriptor(new ConnectionDescriptor(sdp2));
                }
            }
        }
    }

    private class CommandContentHandle
    implements MgcpContentHandler {
        public void header(String header) throws ParseException {
            String[] tokens = AuditConnectionHandler.this.utils.splitStringBySpace(header);
            String transactionID = tokens[1].trim();
            AuditConnectionHandler.this.tid = Integer.parseInt(transactionID);
            AuditConnectionHandler.this.endpointId = AuditConnectionHandler.this.utils.decodeEndpointIdentifier(tokens[2].trim());
        }

        public void param(String name, String value) throws ParseException {
            if (name.equalsIgnoreCase("I")) {
                AuditConnectionHandler.this.connectionIdentifier = new ConnectionIdentifier(value);
            } else if (name.equalsIgnoreCase("F")) {
                int RCindex = value.indexOf("RC");
                int LCindex = value.indexOf("LC");
                if (RCindex != -1 && RCindex < LCindex) {
                    AuditConnectionHandler.this.RCfirst = true;
                }
                AuditConnectionHandler.access$202(AuditConnectionHandler.this, AuditConnectionHandler.this.utils.decodeInfoCodeList(value));
            } else {
                logger.error((Object)("Unknown code while encoding AUCX Command name = " + name + " value = " + value));
            }
        }

        public void sessionDescription(String sd) throws ParseException {
            throw new ParseException("SessionDescription shouldn't have been included in AUCX command", 0);
        }
    }
}

