/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.stack;

import jain.protocol.ip.mgcp.CreateProviderException;
import jain.protocol.ip.mgcp.DeleteProviderException;
import jain.protocol.ip.mgcp.JainMgcpProvider;
import jain.protocol.ip.mgcp.JainMgcpStack;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.stack.JainMgcpStackProviderImpl;
import org.mobicents.mgcp.stack.MessageHandler;
import org.mobicents.mgcp.stack.TransactionHandler;

public class JainMgcpStackImpl
extends Thread
implements JainMgcpStack {
    private String protocolVersion = "1.0";
    protected int port = 2727;
    private DatagramSocket socket;
    private boolean stopped = true;
    private Logger logger = Logger.getLogger(JainMgcpStackImpl.class);
    protected ExecutorService jainMgcpStackImplPool = Executors.newFixedThreadPool(50, new ThreadFactoryImpl());
    protected JainMgcpStackProviderImpl provider;
    protected ConcurrentHashMap<Integer, TransactionHandler> loaclTransactions = new ConcurrentHashMap();
    protected ConcurrentHashMap<Integer, Integer> remoteTxToLocalTxMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<Integer, TransactionHandler> responseTx = new ConcurrentHashMap();

    public JainMgcpStackImpl(InetAddress localAddress, int port) {
        this.port = port;
        if (this.socket == null) {
            while (true) {
                try {
                    InetSocketAddress bindAddress = new InetSocketAddress(localAddress, port);
                    this.socket = new DatagramSocket(bindAddress);
                    this.logger.info((Object)("Jain Mgcp stack bound to IP " + localAddress + " and UDP port " + this.port));
                }
                catch (SocketException e) {
                    this.logger.error((Object)("Failed to bound to local port " + this.port + ". Caused by"), (Throwable)e);
                    if (this.port != port + 10) {
                        ++this.port;
                        continue;
                    }
                    throw new RuntimeException("Failed to find a local port to bound stack");
                }
                break;
            }
        }
        this.stopped = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Starting main thread " + this));
        }
        this.provider = new JainMgcpStackProviderImpl(this);
        this.start();
    }

    public void close() {
        this.stopped = true;
        try {
            this.logger.debug((Object)"Closing socket");
            this.socket.close();
            this.jainMgcpStackImplPool.shutdown();
        }
        catch (Exception e) {
            this.logger.warn((Object)"Could not gracefully close socket", (Throwable)e);
        }
    }

    public JainMgcpProvider createProvider() throws CreateProviderException {
        return this.provider;
    }

    public void deleteProvider(JainMgcpProvider provider) throws DeleteProviderException {
    }

    public void setPort(int port) {
        throw new UnsupportedOperationException("this stack impl doesn't support port reconfiguring");
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    protected synchronized void send(DatagramPacket packet) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Sending " + packet.getLength() + " bytes to " + packet.getAddress()));
            }
            this.socket.send(packet);
        }
        catch (IOException e) {
            this.logger.error((Object)"I/O Exception uccured, caused by", (Throwable)e);
        }
    }

    public boolean isRequest(String header) {
        return header.matches("[\\w]{4}(\\s|\\S)*");
    }

    public void run() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("MGCP stack started successfully on " + this.socket.getLocalAddress() + ":" + this.socket.getLocalPort()));
        }
        byte[] buffer = new byte[86400];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        while (!this.stopped) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Waiting for packet delivery");
                }
                this.socket.receive(packet);
            }
            catch (IOException e) {
                if (this.stopped) break;
                this.logger.error((Object)"I/O exception occured:", (Throwable)e);
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Receive " + packet.getLength() + " bytes from " + packet.getAddress() + ":" + packet.getPort()));
            }
            byte[] data = new byte[packet.getLength()];
            System.arraycopy(packet.getData(), 0, data, 0, data.length);
            MessageHandler handler = new MessageHandler(this, data, packet.getAddress(), packet.getPort());
            this.jainMgcpStackImplPool.execute(handler);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"MGCP stack stopped gracefully");
        }
    }

    static class ThreadFactoryImpl
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        ThreadFactoryImpl() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "JainMgcpStackImpl-FixedThreadPool-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 5L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

