/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.stack;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.DeleteConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.NotificationRequestParms;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.mgcp.stack.TransactionHandler;
import org.mobicents.mgcp.stack.parser.MgcpContentHandler;
import org.mobicents.mgcp.stack.parser.MgcpMessageParser;
import org.mobicents.mgcp.stack.parser.Utils;

public class DeleteConnectionHandler
extends TransactionHandler {
    private DeleteConnection command;
    private DeleteConnectionResponse response;
    private Logger logger = Logger.getLogger(DeleteConnectionHandler.class);

    public DeleteConnectionHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public DeleteConnectionHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    public JainMgcpCommandEvent decodeCommand(String message) throws ParseException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Decoding delete connection command");
        }
        MgcpMessageParser parser = new MgcpMessageParser(new CommandContentHandle());
        try {
            parser.parse(message);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.command;
    }

    public JainMgcpResponseEvent decodeResponse(String message) throws ParseException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Decoding delete connection response command");
        }
        MgcpMessageParser parser = new MgcpMessageParser(new ResponseContentHandle());
        try {
            parser.parse(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.response;
    }

    public String encode(JainMgcpCommandEvent event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Encoding DeleteConnection object into MGCP delete connection command");
        }
        DeleteConnection evt = (DeleteConnection)event;
        String msg = "DLCX " + evt.getTransactionHandle() + " " + evt.getEndpointIdentifier() + " MGCP 1.0\n";
        if (evt.getBearerInformation() != null) {
            msg = msg + "B:e:" + evt.getBearerInformation() + "\n";
        }
        if (evt.getCallIdentifier() != null) {
            msg = msg + "C:" + evt.getCallIdentifier() + "\n";
        }
        if (evt.getConnectionIdentifier() != null) {
            msg = msg + "I:" + evt.getConnectionIdentifier() + "\n";
        }
        if (evt.getConnectionParms() != null) {
            msg = msg + "P:" + Utils.encodeConnectionParms(evt.getConnectionParms()) + "\n";
        }
        if (evt.getNotificationRequestParms() != null) {
            msg = msg + Utils.encodeNotificationRequestParms(evt.getNotificationRequestParms());
        }
        if (evt.getReasonCode() != null) {
            msg = msg + "E:" + evt.getReasonCode();
        }
        return msg;
    }

    public String encode(JainMgcpResponseEvent event) {
        DeleteConnectionResponse response = (DeleteConnectionResponse)event;
        ReturnCode returnCode = response.getReturnCode();
        String msg = returnCode.getValue() + " " + response.getTransactionHandle() + " " + returnCode.getComment() + "\n";
        if (response.getConnectionParms() != null) {
            msg = msg + response.getConnectionParms() + "\n";
        }
        return msg;
    }

    public JainMgcpResponseEvent getProvisionalResponse() {
        DeleteConnectionResponse provisionalResponse = null;
        if (!this.sent) {
            provisionalResponse = new DeleteConnectionResponse(this.commandEvent.getSource(), ReturnCode.Transaction_Being_Executed);
            provisionalResponse.setTransactionHandle(this.commandEvent.getTransactionHandle());
        }
        return provisionalResponse;
    }

    private class ResponseContentHandle
    implements MgcpContentHandler {
        public void header(String header) throws ParseException {
            String[] tokens = header.split("\\s");
            int tid = Integer.parseInt(tokens[1]);
            DeleteConnectionHandler.this.response = new DeleteConnectionResponse((Object)DeleteConnectionHandler.this.stack, Utils.decodeReturnCode(Integer.parseInt(tokens[0])));
            DeleteConnectionHandler.this.response.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
            if (name.equalsIgnoreCase("I")) {
                // empty if block
            }
        }

        public void sessionDescription(String sd) throws ParseException {
        }
    }

    public class CommandContentHandle
    implements MgcpContentHandler {
        public void header(String header) throws ParseException {
            String[] tokens = header.split("\\s");
            String verb = tokens[0].trim();
            String transactionID = tokens[1].trim();
            String version = tokens[3].trim() + " " + tokens[4].trim();
            int tid = Integer.parseInt(transactionID);
            EndpointIdentifier endpoint = Utils.decodeEndpointIdentifier(tokens[2].trim());
            DeleteConnectionHandler.this.command = new DeleteConnection(DeleteConnectionHandler.this.getObjectSource(tid), endpoint);
            DeleteConnectionHandler.this.command.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
            if (name.equalsIgnoreCase("B")) {
                DeleteConnectionHandler.this.command.setBearerInformation(Utils.createBearerInformation(value));
            } else if (name.equalsIgnoreCase("c")) {
                DeleteConnectionHandler.this.command.setCallIdentifier(new CallIdentifier(value));
            } else if (name.equalsIgnoreCase("I")) {
                DeleteConnectionHandler.this.command.setConnectionIdentifier(new ConnectionIdentifier(value));
            } else if (name.equalsIgnoreCase("X")) {
                DeleteConnectionHandler.this.command.setNotificationRequestParms(new NotificationRequestParms(new RequestIdentifier(value)));
            } else if (name.equalsIgnoreCase("R")) {
                DeleteConnectionHandler.this.command.getNotificationRequestParms().setRequestedEvents(Utils.decodeRequestedEvents(value));
            } else if (name.equalsIgnoreCase("S")) {
                DeleteConnectionHandler.this.command.getNotificationRequestParms().setSignalRequests(Utils.decodeEventNames(value));
            } else if (name.equalsIgnoreCase("T")) {
                DeleteConnectionHandler.this.command.getNotificationRequestParms().setDetectEvents(Utils.decodeEventNames(value));
            } else if (name.equalsIgnoreCase("P")) {
                DeleteConnectionHandler.this.command.setConnectionParms(Utils.decodeConnectionParms(value));
            } else if (name.equalsIgnoreCase("E")) {
                DeleteConnectionHandler.this.command.setReasonCode(Utils.decodeReasonCode(value));
            }
        }

        public void sessionDescription(String sd) throws ParseException {
        }
    }
}

