/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.stack;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.mobicents.mgcp.stack.CreateConnectionHandler;
import org.mobicents.mgcp.stack.DeleteConnectionHandler;
import org.mobicents.mgcp.stack.EndpointConfigurationHandler;
import org.mobicents.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.mgcp.stack.ModifyConnectionHandler;
import org.mobicents.mgcp.stack.NotificationRequestHandler;
import org.mobicents.mgcp.stack.NotifyHandler;
import org.mobicents.mgcp.stack.RestartInProgressHandler;
import org.mobicents.mgcp.stack.TransactionHandler;

public class MessageHandler
implements Runnable {
    private JainMgcpStackImpl stack;
    private byte[] data;
    private InetAddress address;
    private int port;
    private static Logger logger = Logger.getLogger(MessageHandler.class);

    public MessageHandler(JainMgcpStackImpl stack, byte[] data, InetAddress address, int port) {
        this.stack = stack;
        this.data = data;
        this.address = address;
        this.port = port;
    }

    public static String[] piggyDismount(String packet) {
        String pb = "\r?\n\\.\r?\n";
        Pattern p = Pattern.compile("\r?\n\\.\r?\n");
        int idx = 0;
        ArrayList<String> mList = new ArrayList<String>();
        Matcher m = p.matcher(packet);
        while (m.find()) {
            mList.add(packet.substring(idx, m.start()) + "\n");
            idx = m.end();
        }
        mList.add(packet.substring(idx));
        String[] result = new String[mList.size()];
        return mList.toArray(result);
    }

    public boolean isRequest(String header) {
        return header.matches("[\\w]{4}(\\s|\\S)*");
    }

    public void run() {
        for (String msg : MessageHandler.piggyDismount(new String(this.data))) {
            String tid;
            TransactionHandler handler;
            int pos = msg.indexOf("\n");
            String header = msg.substring(0, pos).trim();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message header: " + header));
            }
            String[] tokens = header.split("\\s");
            if (this.isRequest(header)) {
                TransactionHandler handle;
                String verb = tokens[0];
                String remoteTxIdString = tokens[1];
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Processing command message = " + verb + " remote Tx = " + remoteTxIdString));
                }
                Integer remoteTxIdIntegere = new Integer(remoteTxIdString);
                Set completedTxSet = this.stack.responseTx.keySet();
                for (Integer completedTx : completedTxSet) {
                    if (!completedTx.equals(remoteTxIdIntegere)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Received Command for which stack has already sent response Tx = " + completedTx));
                    }
                    TransactionHandler completedTxHandler = this.stack.responseTx.get(completedTx);
                    new Thread(completedTxHandler).start();
                    return;
                }
                if (verb.equalsIgnoreCase("crcx")) {
                    handle = new CreateConnectionHandler(this.stack, this.address, this.port);
                } else if (verb.equalsIgnoreCase("mdcx")) {
                    handle = new ModifyConnectionHandler(this.stack, this.address, this.port);
                } else if (verb.equalsIgnoreCase("dlcx")) {
                    handle = new DeleteConnectionHandler(this.stack, this.address, this.port);
                } else if (verb.equalsIgnoreCase("epcf")) {
                    handle = new EndpointConfigurationHandler(this.stack, this.address, this.port);
                } else if (verb.equalsIgnoreCase("rqnt")) {
                    handle = new NotificationRequestHandler(this.stack, this.address, this.port);
                } else if (verb.equalsIgnoreCase("ntfy")) {
                    handle = new NotifyHandler(this.stack, this.address, this.port);
                } else if (verb.equalsIgnoreCase("rsip")) {
                    handle = new RestartInProgressHandler(this.stack, this.address, this.port);
                } else {
                    logger.warn((Object)("Unsupported message verbose " + verb));
                    return;
                }
                handle.receiveCommand(msg);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Processing response message");
            }
            if ((handler = this.stack.transactions.get(Integer.valueOf(tid = tokens[1]))) == null) {
                logger.warn((Object)("Unknown transaction: " + tid));
                return;
            }
            handler.receiveResponse(msg);
        }
    }
}

