/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.stack;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.parms.DigitMap;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import org.mobicents.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.mgcp.stack.TransactionHandler;
import org.mobicents.mgcp.stack.parser.MgcpContentHandler;
import org.mobicents.mgcp.stack.parser.MgcpMessageParser;
import org.mobicents.mgcp.stack.parser.Utils;

public class NotificationRequestHandler
extends TransactionHandler {
    private NotificationRequest command;
    private NotificationRequestResponse response;

    public NotificationRequestHandler(JainMgcpStackImpl stack) {
        super(stack);
    }

    public NotificationRequestHandler(JainMgcpStackImpl stack, InetAddress address, int port) {
        super(stack, address, port);
    }

    protected JainMgcpCommandEvent decodeCommand(String message) throws ParseException {
        MgcpMessageParser parser = new MgcpMessageParser(new CommandContentHandle());
        try {
            parser.parse(message);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), -1);
        }
        return this.command;
    }

    protected JainMgcpResponseEvent decodeResponse(String message) throws ParseException {
        MgcpMessageParser parser = new MgcpMessageParser(new ResponseContentHandle());
        try {
            parser.parse(message);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.response;
    }

    protected String encode(JainMgcpCommandEvent event) {
        NotificationRequest req = (NotificationRequest)event;
        StringBuffer buffer = new StringBuffer();
        buffer.append("RQNT " + event.getTransactionHandle() + " " + req.getEndpointIdentifier() + " MGCP 1.0\n");
        if (req.getNotifiedEntity() != null) {
            buffer.append("N:" + req.getNotifiedEntity() + "\n");
        }
        buffer.append("X:" + req.getRequestIdentifier() + "\n");
        if (req.getDigitMap() != null) {
            // empty if block
        }
        if (req.getSignalRequests() != null) {
            buffer.append("S:" + Utils.encodeEventNames(req.getSignalRequests()) + "\n");
        }
        if (req.getRequestedEvents() != null) {
            buffer.append("R:" + Utils.encodeRequestedEvents(req.getRequestedEvents()) + "\n");
        }
        if (req.getDetectEvents() != null) {
            buffer.append("T:" + Utils.encodeEventNames(req.getDetectEvents()) + "\n");
        }
        return buffer.toString();
    }

    protected String encode(JainMgcpResponseEvent event) {
        return event.getReturnCode().getValue() + " " + event.getTransactionHandle() + event.getReturnCode().getComment() + "\n";
    }

    private class ResponseContentHandle
    implements MgcpContentHandler {
        private ResponseContentHandle() {
        }

        public void header(String header) throws ParseException {
            String[] tokens = header.split("\\s");
            int tid = Integer.parseInt(tokens[1]);
            NotificationRequestHandler.this.response = new NotificationRequestResponse((Object)NotificationRequestHandler.this.stack, Utils.decodeReturnCode(Integer.parseInt(tokens[0])));
            NotificationRequestHandler.this.response.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void sessionDescription(String sd) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class CommandContentHandle
    implements MgcpContentHandler {
        private CommandContentHandle() {
        }

        public void header(String header) throws ParseException {
            String[] tokens = header.split("\\s");
            String verb = tokens[0].trim();
            String transactionID = tokens[1].trim();
            String version = tokens[3].trim() + " " + tokens[4].trim();
            int tid = Integer.parseInt(transactionID);
            EndpointIdentifier endpoint = Utils.decodeEndpointIdentifier(tokens[2].trim());
            NotificationRequestHandler.this.command = new NotificationRequest(NotificationRequestHandler.this.getObjectSource(tid), endpoint, new RequestIdentifier("0"));
            NotificationRequestHandler.this.command.setTransactionHandle(tid);
        }

        public void param(String name, String value) throws ParseException {
            if (name.equalsIgnoreCase("N")) {
                NotificationRequestHandler.this.command.setNotifiedEntity(new NotifiedEntity(value));
            } else if (name.equalsIgnoreCase("X")) {
                NotificationRequestHandler.this.command.setRequestIdentifier(new RequestIdentifier(value));
            } else if (name.equalsIgnoreCase("R")) {
                NotificationRequestHandler.this.command.setRequestedEvents(Utils.decodeRequestedEvents(value));
            } else if (name.equalsIgnoreCase("S")) {
                NotificationRequestHandler.this.command.setSignalRequests(Utils.decodeEventNames(value));
            } else if (name.equalsIgnoreCase("T")) {
                NotificationRequestHandler.this.command.setDetectEvents(Utils.decodeEventNames(value));
            } else if (name.equalsIgnoreCase("D")) {
                NotificationRequestHandler.this.command.setDigitMap(new DigitMap(value));
            }
        }

        public void sessionDescription(String sd) throws ParseException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

