/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.io.sctp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.client.api.io.NotInitializedException;
import org.jdiameter.server.impl.io.sctp.SCTPServerConnection;
import org.mobicents.protocols.api.Association;
import org.mobicents.protocols.api.AssociationListener;
import org.mobicents.protocols.api.IpChannelType;
import org.mobicents.protocols.api.Management;
import org.mobicents.protocols.api.PayloadData;
import org.mobicents.protocols.api.Server;
import org.mobicents.protocols.api.ServerListener;
import org.mobicents.protocols.sctp.ManagementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCTPTransportServer {
    private Management management = null;
    private Association serverAssociation = null;
    private Association remoteClientAssociation = null;
    private SCTPServerConnection parentConnection;
    private String serverAssociationName;
    private String remoteClientAssociationName;
    private String serverName;
    protected InetSocketAddress destAddress;
    protected InetSocketAddress origAddress;
    private Server server = null;
    private static final Logger logger = LoggerFactory.getLogger(SCTPTransportServer.class);
    private int payloadProtocolId = 0;
    private int streamNumber = 0;

    public SCTPTransportServer() {
    }

    SCTPTransportServer(SCTPServerConnection parentConnectionConnection) {
        this.parentConnection = parentConnectionConnection;
    }

    public SCTPServerConnection getParent() {
        return this.parentConnection;
    }

    public Management getManagement() {
        return this.management;
    }

    public void setManagement(Management management) {
        this.management = management;
    }

    public void startNewRemoteConnection(Server server, Association association, String peerAddress, int peerPort) {
        logger.debug("Initializing new Remote Connection '{}' -> '{}' ---> '{}:{}'", new Object[]{this.origAddress, this.destAddress, peerAddress, peerPort});
        this.remoteClientAssociationName = peerAddress + ":" + peerPort;
        this.serverName = server.getName();
        try {
            logger.debug("Adding new server association for [{}:{}]", (Object)peerAddress, (Object)peerPort);
            this.remoteClientAssociation = association;
            this.remoteClientAssociation.acceptAnonymousAssociation((AssociationListener)new ServerAssociationListener());
            logger.info(String.format("Connected to {}", this.remoteClientAssociation));
        }
        catch (Exception e) {
            logger.error("Failed to initialize new remote connection.", (Throwable)e);
        }
    }

    public void startServer() throws NotInitializedException {
        logger.debug("Initializing SCTP server");
        try {
            if (this.management == null) {
                this.management = new ManagementImpl("server-management-" + this.origAddress.getAddress().getHostAddress() + "." + this.origAddress.getPort());
                this.management.setBufferSize(Integer.valueOf(System.getProperty("org.restcomm.sctp.bufferSize", "65535")).intValue());
                logger.debug("SCTP Server Buffer Size set to {}", (Object)this.management.getBufferSize());
                this.management.setSingleThread(true);
                this.management.start();
                this.management.removeAllResourses();
            }
            logger.debug("Orig Address: '{}:{}'", (Object)this.origAddress.getAddress().getHostAddress(), (Object)this.origAddress.getPort());
            logger.debug("Dest Address: '{}'", (Object)this.destAddress);
            this.serverName = this.serverAssociationName = this.origAddress.getHostName() + ":" + this.origAddress.getPort();
            for (Server s : this.management.getServers()) {
                if (!s.getName().equals(this.serverName)) continue;
                this.server = s;
                break;
            }
            if (this.server == null) {
                this.server = this.management.addServer(this.serverName, this.origAddress.getAddress().getHostAddress(), this.origAddress.getPort(), IpChannelType.SCTP, true, 10, null);
            }
            for (String assocName : this.server.getAssociations()) {
                Association a = this.management.getAssociation(assocName);
                if (!a.getName().equals(this.serverAssociationName)) continue;
                this.serverAssociation = a;
                break;
            }
            if (this.serverAssociation == null) {
                this.serverAssociation = this.management.addServerAssociation(this.origAddress.getAddress().getHostAddress(), this.origAddress.getPort(), this.serverName, this.serverAssociationName, IpChannelType.SCTP);
            }
            this.management.setServerListener((ServerListener)new ServerEventListener());
            this.serverAssociation.setAssociationListener((AssociationListener)new ServerAssociationListener());
            this.management.startAssociation(this.serverAssociationName);
            if (!this.server.isStarted()) {
                logger.debug("Starting server");
                this.management.startServer(this.serverName);
            }
        }
        catch (Exception e) {
            logger.error("Failed to initialize client ", (Throwable)e);
        }
        if (this.getParent() == null) {
            throw new NotInitializedException("No parent connection is set is set");
        }
        logger.debug("Successfuly initialized SCTP Server Host[{}:{}] Peer[{}:{}]", new Object[]{this.serverAssociation.getHostAddress(), this.serverAssociation.getHostPort(), this.serverAssociation.getPeerAddress(), this.serverAssociation.getPeerPort()});
        logger.debug("Server Association Status: Started[{}] Connected[{}] Up[{}] ", new Object[]{this.serverAssociation.isStarted(), this.serverAssociation.isConnected(), this.serverAssociation.isUp()});
        logger.trace("Server Association [{}]", (Object)this.serverAssociation);
    }

    public void destroy() throws Exception {
        logger.debug("Destroying SCTP Server");
        if (this.remoteClientAssociation != null) {
            this.management.stopAssociation(this.remoteClientAssociationName);
            this.management.removeAssociation(this.remoteClientAssociationName);
            this.remoteClientAssociation = null;
        }
        if (this.serverAssociation != null) {
            this.management.stopAssociation(this.serverAssociationName);
            this.management.removeAssociation(this.serverAssociationName);
            this.management.stopServer(this.serverName);
            this.management.removeServer(this.serverName);
            this.management.stop();
            this.serverAssociation = null;
        }
    }

    public void stop() throws Exception {
        logger.debug("Stopping SCTP Server");
        if (this.remoteClientAssociation != null) {
            this.management.stopAssociation(this.remoteClientAssociationName);
        }
    }

    public void release() throws Exception {
        logger.debug("Releasing SCTP Server");
        this.stop();
        if (this.remoteClientAssociation != null) {
            this.management.removeAssociation(this.remoteClientAssociationName);
            this.remoteClientAssociation = null;
        }
    }

    public InetSocketAddress getDestAddress() {
        return this.destAddress;
    }

    public void setDestAddress(InetSocketAddress address) {
        this.destAddress = address;
        if (logger.isDebugEnabled()) {
            logger.debug("Destination address is set to [{}:{}]", (Object)this.destAddress.getHostName(), (Object)this.destAddress.getPort());
        }
    }

    public void setOrigAddress(InetSocketAddress address) {
        this.origAddress = address;
        if (logger.isDebugEnabled()) {
            logger.debug("Origin address is set to [{}:{}]", (Object)this.origAddress.getHostName(), (Object)this.origAddress.getPort());
        }
    }

    public InetSocketAddress getOrigAddress() {
        return this.origAddress;
    }

    public void sendMessage(ByteBuffer bytes) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("About to send a byte buffer of size [{}] over the SCTP", (Object)bytes.array().length);
        }
        PayloadData payloadData = new PayloadData(bytes.array().length, bytes.array(), true, false, this.payloadProtocolId, this.streamNumber);
        try {
            this.remoteClientAssociation.send(payloadData);
        }
        catch (Exception e) {
            logger.error("Failed sending byte buffer over SCTP", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Sent a byte buffer of size [{}] over SCTP", (Object)bytes.array().length);
        }
    }

    boolean isConnected() {
        if (this.remoteClientAssociation == null) {
            return false;
        }
        return this.remoteClientAssociation.isConnected();
    }

    private class ServerEventListener
    implements ServerListener {
        private final Logger logger = LoggerFactory.getLogger(ServerEventListener.class);

        private ServerEventListener() {
        }

        public void onNewRemoteConnection(Server server, Association association) {
            this.logger.debug("Received notfification of a new remote connection!");
            try {
                SCTPTransportServer.this.getParent().onNewRemoteConnection(server, association);
            }
            catch (Exception e) {
                try {
                    association.stopAnonymousAssociation();
                }
                catch (Exception ex) {
                    this.logger.error("Error closing channel: " + ex.getMessage());
                }
            }
        }
    }

    private class ServerAssociationListener
    implements AssociationListener {
        private final Logger logger = LoggerFactory.getLogger(ServerAssociationListener.class);

        private ServerAssociationListener() {
        }

        public void onCommunicationUp(Association association, int maxInboundStreams, int maxOutboundStreams) {
            this.logger.debug("onCommunicationUp called for [{}]", (Object)this);
            SCTPTransportServer.this.getParent().onConnected();
        }

        public void onCommunicationShutdown(Association association) {
            this.logger.debug("onCommunicationShutdown called for [{}]", (Object)this);
            try {
                SCTPTransportServer.this.getParent().onDisconnect();
                if (SCTPTransportServer.this.remoteClientAssociation != null) {
                    SCTPTransportServer.this.management.stopAssociation(SCTPTransportServer.this.remoteClientAssociationName);
                    SCTPTransportServer.this.management.removeAssociation(SCTPTransportServer.this.remoteClientAssociationName);
                    SCTPTransportServer.this.remoteClientAssociation = null;
                }
            }
            catch (Exception e) {
                this.logger.debug("Error", (Throwable)e);
            }
        }

        public void onCommunicationLost(Association association) {
            this.logger.debug("onCommunicationLost called for [{}]", (Object)this);
        }

        public void onCommunicationRestart(Association association) {
            this.logger.debug("onCommunicationRestart called for [{}]", (Object)this);
        }

        public void onPayload(Association association, PayloadData payloadData) {
            SCTPTransportServer.this.payloadProtocolId = payloadData.getPayloadProtocolId();
            SCTPTransportServer.this.streamNumber = payloadData.getStreamNumber();
            byte[] data = new byte[payloadData.getDataLength()];
            System.arraycopy(payloadData.getData(), 0, data, 0, payloadData.getDataLength());
            this.logger.debug("SCTP Server received a message of length: [{}] ", (Object)data.length);
            try {
                SCTPTransportServer.this.getParent().onMessageReceived(ByteBuffer.wrap(data));
            }
            catch (AvpDataException e) {
                this.logger.debug("Garbage was received. Discarding.");
                SCTPTransportServer.this.getParent().onAvpDataException(e);
            }
        }

        public void inValidStreamId(PayloadData payloadData) {
        }
    }
}

