/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.app.slg;

import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.slg.ServerSLgSession;
import org.jdiameter.api.slg.ServerSLgSessionListener;
import org.jdiameter.api.slg.events.LocationReportAnswer;
import org.jdiameter.api.slg.events.LocationReportRequest;
import org.jdiameter.api.slg.events.ProvideLocationAnswer;
import org.jdiameter.api.slg.events.ProvideLocationRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.slg.ISLgMessageFactory;
import org.jdiameter.common.api.app.slg.SLgSessionState;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.slg.SLgSession;
import org.jdiameter.server.impl.app.slg.Event;
import org.jdiameter.server.impl.app.slg.IServerSLgSessionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLgServerSessionImpl
extends SLgSession
implements ServerSLgSession,
EventListener<Request, Answer>,
NetworkReqListener {
    private static final Logger logger = LoggerFactory.getLogger(SLgServerSessionImpl.class);
    private transient ServerSLgSessionListener listener;
    protected long appId = -1L;
    protected IServerSLgSessionData sessionData;

    public SLgServerSessionImpl(IServerSLgSessionData sessionData, ISLgMessageFactory fct, ISessionFactory sf, ServerSLgSessionListener lst) {
        super(sf, sessionData);
        if (lst == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        this.appId = fct.getApplicationId();
        if (this.appId < 0L) {
            throw new IllegalArgumentException("ApplicationId can not be less than zero");
        }
        this.listener = lst;
        this.messageFactory = fct;
        this.sessionData = sessionData;
    }

    public void sendProvideLocationAnswer(ProvideLocationAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, null, (AppEvent)answer);
    }

    public void sendLocationReportRequest(LocationReportRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, (AppEvent)request, null);
    }

    public <E> E getState(Class<E> stateType) {
        return (E)((Object)(stateType == SLgSessionState.class ? this.sessionData.getSLgSessionState() : null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        try {
            this.sendAndStateLock.lock();
            if (!this.session.isValid()) {
                boolean bl = false;
                return bl;
            }
            SLgSessionState state = this.sessionData.getSLgSessionState();
            Event localEvent = (Event)event;
            Event.Type eventType = (Event.Type)event.getType();
            switch (state) {
                case IDLE: {
                    switch (eventType) {
                        case RECEIVE_PLR: {
                            this.sessionData.setBuffer((Request)((AppEvent)event.getData()).getMessage());
                            super.cancelMsgTimer();
                            super.startMsgTimer();
                            SLgSessionState newState = SLgSessionState.MESSAGE_SENT_RECEIVED;
                            this.setState(newState);
                            this.listener.doProvideLocationRequestEvent((ServerSLgSession)this, (ProvideLocationRequest)event.getData());
                            return true;
                        }
                        case SEND_MESSAGE: {
                            this.session.send(((AppEvent)event.getData()).getMessage(), (EventListener)this);
                            SLgSessionState newState = SLgSessionState.MESSAGE_SENT_RECEIVED;
                            this.setState(newState);
                            return true;
                        }
                    }
                    logger.error("Wrong action in SLg Server FSM. State: IDLE, Event Type: {}", (Object)eventType);
                    return true;
                }
                case MESSAGE_SENT_RECEIVED: {
                    switch (eventType) {
                        case TIMEOUT_EXPIRES: {
                            SLgSessionState newState = SLgSessionState.TIMEDOUT;
                            this.setState(newState);
                            return true;
                        }
                        case RECEIVE_LRA: {
                            SLgSessionState newState = SLgSessionState.TERMINATED;
                            this.setState(newState);
                            this.listener.doLocationReportAnswerEvent((ServerSLgSession)this, (LocationReportRequest)localEvent.getRequest(), (LocationReportAnswer)localEvent.getAnswer());
                            return true;
                        }
                        case SEND_MESSAGE: {
                            try {
                                this.session.send(((AppEvent)event.getData()).getMessage(), (EventListener)this);
                                return true;
                            }
                            finally {
                                SLgSessionState newState = SLgSessionState.TERMINATED;
                                this.setState(newState);
                            }
                        }
                    }
                    throw new InternalException("Should not receive more messages after initial. Command: " + event.getData());
                }
                case TERMINATED: {
                    throw new InternalException("Cant receive message in state TERMINATED. Command: " + event.getData());
                }
                case TIMEDOUT: {
                    throw new InternalException("Cant receive message in state TIMEDOUT. Command: " + event.getData());
                }
            }
            logger.error("SLg Server FSM in wrong state: {}", (Object)state);
            return true;
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery rd = new AnswerDelivery();
        rd.session = this;
        rd.request = request;
        rd.answer = answer;
        this.scheduler.execute(rd);
    }

    public void timeoutExpired(Request request) {
        try {
            this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, new AppRequestEventImpl((Message)request), null));
        }
        catch (Exception e) {
            logger.debug("Failed to process timeout message", (Throwable)e);
        }
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    protected void send(Event.Type type, AppEvent request, AppEvent answer) throws InternalException {
        try {
            if (type != null) {
                this.handleEvent(new Event(type, request, answer));
            }
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
    }

    protected void setState(SLgSessionState newState) {
        SLgSessionState oldState = this.sessionData.getSLgSessionState();
        this.sessionData.setSLgSessionState(newState);
        for (StateChangeListener i : this.stateListeners) {
            i.stateChanged((Object)this, (Enum)oldState, (Enum)newState);
        }
        if (newState == SLgSessionState.TERMINATED || newState == SLgSessionState.TIMEDOUT) {
            super.cancelMsgTimer();
            this.release();
        }
    }

    @Override
    public void onTimer(String timerName) {
        if (timerName.equals("MSG_TIMEOUT")) {
            try {
                this.sendAndStateLock.lock();
                try {
                    this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, new AppRequestEventImpl((Message)this.sessionData.getBuffer()), null));
                }
                catch (Exception e) {
                    logger.debug("Failure handling Timeout event.");
                }
                this.sessionData.setBuffer(null);
                this.sessionData.setTsTimerId(null);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        }
    }

    @Override
    public void release() {
        if (this.isValid()) {
            try {
                this.sendAndStateLock.lock();
                super.release();
            }
            catch (Exception e) {
                logger.debug("Failed to release session", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        } else {
            logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }

    private class AnswerDelivery
    implements Runnable {
        ServerSLgSession session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        @Override
        public void run() {
            try {
                switch (this.answer.getCommandCode()) {
                    case 0x80000D: {
                        SLgServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_LRA, (AppEvent)SLgServerSessionImpl.this.messageFactory.createLocationReportRequest(this.request), (AppEvent)SLgServerSessionImpl.this.messageFactory.createLocationReportAnswer(this.answer)));
                        break;
                    }
                    default: {
                        SLgServerSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process success message", (Throwable)e);
            }
        }
    }

    private class RequestDelivery
    implements Runnable {
        ServerSLgSession session;
        Request request;

        private RequestDelivery() {
        }

        @Override
        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    case 0x80000C: {
                        SLgServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_PLR, (AppEvent)SLgServerSessionImpl.this.messageFactory.createProvideLocationRequest(this.request), null));
                        break;
                    }
                    default: {
                        SLgServerSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), null);
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process request message", (Throwable)e);
            }
        }
    }
}

