/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.app.gq;

import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.auth.ServerAuthSession;
import org.jdiameter.api.auth.ServerAuthSessionListener;
import org.jdiameter.api.auth.events.AbortSessionAnswer;
import org.jdiameter.api.auth.events.AbortSessionRequest;
import org.jdiameter.api.auth.events.ReAuthAnswer;
import org.jdiameter.api.auth.events.ReAuthRequest;
import org.jdiameter.api.auth.events.SessionTermAnswer;
import org.jdiameter.api.auth.events.SessionTermRequest;
import org.jdiameter.api.gq.GqServerSession;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.auth.IAuthMessageFactory;
import org.jdiameter.common.api.app.auth.IServerAuthActionContext;
import org.jdiameter.common.api.app.auth.ServerAuthSessionState;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.auth.AbortSessionAnswerImpl;
import org.jdiameter.common.impl.app.auth.AbortSessionRequestImpl;
import org.jdiameter.common.impl.app.auth.AppAuthSessionImpl;
import org.jdiameter.common.impl.app.auth.ReAuthAnswerImpl;
import org.jdiameter.common.impl.app.auth.ReAuthRequestImpl;
import org.jdiameter.common.impl.app.auth.SessionTermRequestImpl;
import org.jdiameter.server.impl.app.auth.IServerAuthSessionData;
import org.jdiameter.server.impl.app.gq.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GqServerSessionImpl
extends AppAuthSessionImpl
implements GqServerSession,
EventListener<Request, Answer>,
NetworkReqListener {
    protected static final Logger logger = LoggerFactory.getLogger(GqServerSessionImpl.class);
    protected IServerAuthSessionData sessionData;
    private Lock sendAndStateLock = new ReentrantLock();
    protected transient IAuthMessageFactory factory;
    protected transient IServerAuthActionContext context;
    protected transient ServerAuthSessionListener listener;
    protected static final String TIMER_NAME_TS = "GQ_TS";

    public GqServerSessionImpl(IServerAuthSessionData sessionData, ISessionFactory sf, ServerAuthSessionListener lst, IAuthMessageFactory fct, StateChangeListener<AppSession> scListener, IServerAuthActionContext context, long tsTimeout, boolean stateless) {
        super(sf, sessionData);
        this.appId = fct.getApplicationId();
        this.listener = lst;
        this.factory = fct;
        this.context = context;
        this.sessionData = sessionData;
        this.sessionData.setStateless(stateless);
        this.sessionData.setTsTimeout(tsTimeout);
        super.addStateChangeNotification(scListener);
    }

    public void sendAuthAnswer(AppAnswerEvent appAnswerEvent) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(null, (AppEvent)appAnswerEvent);
    }

    public void sendReAuthRequest(ReAuthRequest reAuthRequest) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(null, (AppEvent)reAuthRequest);
    }

    public void sendAbortSessionRequest(AbortSessionRequest abortSessionRequest) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_ASR_REQUEST, (AppEvent)abortSessionRequest);
    }

    public void sendSessionTerminationAnswer(SessionTermAnswer sessionTermAnswer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.sendPost(Event.Type.SEND_STR_ANSWER, (AppEvent)sessionTermAnswer);
    }

    protected void sendPost(Event.Type type, AppEvent event) throws InternalException {
        try {
            this.sendAndStateLock.lock();
            this.session.send(event.getMessage(), (EventListener)this);
            if (type != null) {
                this.handleEvent(new Event(type, event));
            }
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    protected void send(Event.Type type, AppEvent event) throws InternalException {
        try {
            this.sendAndStateLock.lock();
            if (type != null) {
                this.handleEvent(new Event(type, event));
            }
            this.session.send(event.getMessage(), (EventListener)this);
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    public boolean isStateless() {
        return this.sessionData.isStateless();
    }

    protected void setState(ServerAuthSessionState newState) {
        ServerAuthSessionState oldState = this.sessionData.getServerAuthSessionState();
        this.sessionData.setServerAuthSessionState(newState);
        for (StateChangeListener i : this.stateListeners) {
            i.stateChanged((Object)this, (Enum)oldState, (Enum)newState);
        }
    }

    public <E> E getState(Class<E> eClass) {
        return (E)(eClass == ServerAuthSessionState.class ? this.sessionData.getServerAuthSessionState() : null);
    }

    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        return this.isStateless() ? this.handleEventForStatelessSession(event) : this.handleEventForStatefullSession(event);
    }

    public boolean handleEventForStatelessSession(StateEvent event) throws InternalException, OverloadException {
        try {
            block1 : switch (this.sessionData.getServerAuthSessionState()) {
                case IDLE: {
                    switch ((Event.Type)event.getType()) {
                        case RECEIVE_AUTH_REQUEST: {
                            this.listener.doAuthRequestEvent((ServerAuthSession)this, (AppRequestEvent)event.getData());
                            this.setState(ServerAuthSessionState.IDLE);
                            break block1;
                        }
                    }
                    logger.debug("Unknown event {}", (Object)event.getType());
                }
            }
        }
        catch (Throwable t) {
            throw new InternalException(t);
        }
        return true;
    }

    public boolean handleEventForStatefullSession(StateEvent event) throws InternalException, OverloadException {
        ServerAuthSessionState state;
        ServerAuthSessionState oldState = state = this.sessionData.getServerAuthSessionState();
        try {
            block6 : switch (state) {
                case IDLE: {
                    switch ((Event.Type)event.getType()) {
                        case RECEIVE_AUTH_REQUEST: {
                            try {
                                this.listener.doAuthRequestEvent((ServerAuthSession)this, (AppRequestEvent)event.getData());
                                this.setState(ServerAuthSessionState.OPEN);
                            }
                            catch (Exception e) {
                                this.setState(ServerAuthSessionState.IDLE);
                            }
                            break block6;
                        }
                        case RECEIVE_STR_REQUEST: {
                            try {
                                this.listener.doSessionTerminationRequestEvent((ServerAuthSession)this, (SessionTermRequest)event.getData());
                            }
                            catch (Exception e) {
                                logger.debug("Can not handle event", (Throwable)e);
                            }
                            break block6;
                        }
                        case SEND_ASR_REQUEST: {
                            this.setState(ServerAuthSessionState.DISCONNECTED);
                            break block6;
                        }
                        case SEND_STR_ANSWER: {
                            this.setState(ServerAuthSessionState.IDLE);
                            break block6;
                        }
                        case TIMEOUT_EXPIRES: {
                            if (this.context != null) {
                                this.context.accessTimeoutElapses((ServerAuthSession)this);
                            }
                            this.setState(ServerAuthSessionState.IDLE);
                            break block6;
                        }
                    }
                    logger.debug("Unknown event {}", (Object)event.getType());
                    break;
                }
                case OPEN: {
                    switch ((Event.Type)event.getType()) {
                        case RECEIVE_AUTH_REQUEST: {
                            try {
                                this.listener.doAuthRequestEvent((ServerAuthSession)this, (AppRequestEvent)event.getData());
                            }
                            catch (Exception e) {
                                this.setState(ServerAuthSessionState.IDLE);
                            }
                            break block6;
                        }
                        case RECEIVE_STR_REQUEST: {
                            try {
                                this.listener.doSessionTerminationRequestEvent((ServerAuthSession)this, (SessionTermRequest)event.getData());
                            }
                            catch (Exception e) {
                                logger.debug("Can not handle event", (Throwable)e);
                            }
                            break block6;
                        }
                        case SEND_ASR_REQUEST: {
                            this.setState(ServerAuthSessionState.DISCONNECTED);
                            break block6;
                        }
                        case SEND_STR_ANSWER: {
                            this.setState(ServerAuthSessionState.IDLE);
                            break block6;
                        }
                        case TIMEOUT_EXPIRES: {
                            if (this.context != null) {
                                this.context.accessTimeoutElapses((ServerAuthSession)this);
                            }
                            this.setState(ServerAuthSessionState.IDLE);
                            break block6;
                        }
                    }
                    logger.debug("Unknown event {}", (Object)event.getType());
                    break;
                }
                case DISCONNECTED: {
                    switch ((Event.Type)event.getType()) {
                        case SEND_ASR_FAILURE: {
                            this.setState(ServerAuthSessionState.DISCONNECTED);
                            break block6;
                        }
                        case RECEIVE_ASR_ANSWER: {
                            this.listener.doAbortSessionAnswerEvent((ServerAuthSession)this, (AbortSessionAnswer)event.getData());
                            break block6;
                        }
                        case RECEIVE_STR_REQUEST: {
                            try {
                                this.listener.doSessionTerminationRequestEvent((ServerAuthSession)this, (SessionTermRequest)event.getData());
                            }
                            catch (Exception e) {
                                logger.debug("Can not handle event", (Throwable)e);
                            }
                            break block6;
                        }
                        case SEND_STR_ANSWER: {
                            this.setState(ServerAuthSessionState.IDLE);
                            break block6;
                        }
                    }
                    logger.debug("Unknown event {}", (Object)event.getType());
                    break;
                }
                default: {
                    logger.debug("Unknown state {}", (Object)state);
                }
            }
            if (oldState != state && ServerAuthSessionState.OPEN.equals(state) && this.context != null && this.context != null) {
                this.cancelTsTimer();
                this.startTsTimer();
            }
        }
        catch (Throwable t) {
            throw new InternalException(t);
        }
        return true;
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery rd = new AnswerDelivery();
        rd.session = this;
        rd.request = request;
        rd.answer = answer;
        this.scheduler.execute(rd);
    }

    public void timeoutExpired(Request request) {
        try {
            if (request.getCommandCode() == 274) {
                this.handleEvent(new Event(Event.Type.SEND_ASR_FAILURE, new AbortSessionRequestImpl((Message)request)));
            } else {
                logger.debug("Timeout for unknown request {}", (Object)request);
            }
        }
        catch (Exception e) {
            logger.debug("Can not handle event", (Throwable)e);
        }
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    @Override
    public boolean isReplicable() {
        return true;
    }

    protected void startTsTimer() {
        try {
            this.sendAndStateLock.lock();
            if (this.sessionData.getTsTimeout() > 0L) {
                this.sessionData.setTsTimerId(this.timerFacility.schedule(this.sessionData.getSessionId(), TIMER_NAME_TS, this.sessionData.getTsTimeout()));
            }
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    protected void cancelTsTimer() {
        try {
            this.sendAndStateLock.lock();
            Serializable tsTimerId = this.sessionData.getTsTimerId();
            if (tsTimerId != null) {
                this.timerFacility.cancel(tsTimerId);
                this.sessionData.setTsTimerId(null);
            }
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    @Override
    public void onTimer(String timerName) {
        if (timerName.equals("IDLE_SESSION_TIMER")) {
            this.checkIdleAppSession();
        } else if (timerName.equals(TIMER_NAME_TS)) {
            try {
                this.sendAndStateLock.lock();
                this.sessionData.setTsTimerId(null);
                this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, null));
            }
            catch (Exception e) {
                logger.debug("Can not handle event", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        } else {
            logger.warn("Received an unknown timer '{}' for Session-ID '{}'", (Object)timerName, (Object)this.getSessionId());
        }
    }

    protected ReAuthAnswer createReAuthAnswer(Answer answer) {
        return new ReAuthAnswerImpl(answer);
    }

    protected ReAuthRequest createReAuthRequest(Request request) {
        return new ReAuthRequestImpl((Message)request);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.sessionData == null ? 0 : this.sessionData.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GqServerSessionImpl other = (GqServerSessionImpl)obj;
        return !(this.sessionData == null ? other.sessionData != null : !this.sessionData.equals(other.sessionData));
    }

    private class AnswerDelivery
    implements Runnable {
        GqServerSession session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        @Override
        public void run() {
            try {
                GqServerSessionImpl.this.sendAndStateLock.lock();
                if (this.request.getCommandCode() == 258) {
                    GqServerSessionImpl.this.listener.doReAuthAnswerEvent((ServerAuthSession)this.session, GqServerSessionImpl.this.createReAuthRequest(this.request), GqServerSessionImpl.this.createReAuthAnswer(this.answer));
                } else if (this.request.getCommandCode() == 274) {
                    GqServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_ASR_ANSWER, new AbortSessionAnswerImpl(this.answer)));
                } else {
                    GqServerSessionImpl.this.listener.doOtherEvent((AppSession)this.session, GqServerSessionImpl.this.factory.createAuthRequest(this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
                }
            }
            catch (Exception e) {
                logger.debug("Can not handle event", (Throwable)e);
            }
            finally {
                GqServerSessionImpl.this.sendAndStateLock.unlock();
            }
        }
    }

    private class RequestDelivery
    implements Runnable {
        GqServerSession session;
        Request request;

        private RequestDelivery() {
        }

        @Override
        public void run() {
            if (this.request != null) {
                try {
                    GqServerSessionImpl.this.sendAndStateLock.lock();
                    if (this.request.getCommandCode() == GqServerSessionImpl.this.factory.getAuthMessageCommandCode()) {
                        GqServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_AUTH_REQUEST, (AppEvent)GqServerSessionImpl.this.factory.createAuthRequest(this.request)));
                    } else if (this.request.getCommandCode() == 275) {
                        GqServerSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_STR_REQUEST, new SessionTermRequestImpl((Message)this.request)));
                    } else {
                        GqServerSessionImpl.this.listener.doOtherEvent((AppSession)this.session, GqServerSessionImpl.this.factory.createAuthRequest(this.request), null);
                    }
                }
                catch (Exception e) {
                    logger.debug("Can not handle event", (Throwable)e);
                }
                finally {
                    GqServerSessionImpl.this.sendAndStateLock.unlock();
                }
            }
        }
    }
}

