/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jdiameter.api.Message;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.api.validation.AvpRepresentation;
import org.jdiameter.api.validation.Dictionary;
import org.jdiameter.api.validation.MessageRepresentation;
import org.jdiameter.api.validation.ValidatorLevel;
import org.jdiameter.client.impl.DictionarySingleton;
import org.jdiameter.common.impl.validation.AvpRepresentationImpl;
import org.jdiameter.common.impl.validation.MessageRepresentationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DictionaryImpl
implements Dictionary {
    private static transient Logger logger = LoggerFactory.getLogger(DictionaryImpl.class);
    public static Dictionary INSTANCE = DictionaryImpl.getInstance("dictionary.xml");
    private static final String UNDEFINED_AVP_TYPE = "UNDEFINED";
    private static final String AVP_DEFAULT_INDEX = "-1";
    private static final String AVP_DEFAULT_MULTIPLICITY = "0+";
    public static final String _AVP_ATTRIBUTE_NAME = "name";
    public static final String _AVP_ATTRIBUTE_CODE = "code";
    public static final String _AVP_ATTRIBUTE_VENDOR = "vendor";
    public static final String _AVP_ATTRIBUTE_MULTIPLICITY = "multiplicity";
    public static final String _AVP_ATTRIBUTE_INDEX = "index";
    private Map<AvpRepresentation, AvpRepresentation> avpMap = new HashMap<AvpRepresentation, AvpRepresentation>();
    private Map<String, AvpRepresentation> avpByNameMap = new HashMap<String, AvpRepresentation>();
    private Map<String, String> vendorMap = new HashMap<String, String>();
    private Map<MessageRepresentation, MessageRepresentation> commandMap = new HashMap<MessageRepresentation, MessageRepresentation>();
    private Map<String, String> typedefMap = new HashMap<String, String>();
    private boolean configured = false;
    private boolean enabled = true;
    private ValidatorLevel sendValidationLevel = ValidatorLevel.ALL;
    private ValidatorLevel receiveValidationLevel = ValidatorLevel.OFF;

    private DictionaryImpl(InputStream is) {
        this.init(is);
    }

    public static Dictionary getInstance(InputStream is) {
        if (is == null) {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            String confFile = "dictionary.xml";
            is = DictionaryImpl.getInputStream(confFile);
        }
        if (INSTANCE != null) {
            ((DictionaryImpl)INSTANCE).init(is);
        } else {
            INSTANCE = new DictionaryImpl(is);
        }
        return INSTANCE;
    }

    public static Dictionary getInstance(String confFile) {
        if (confFile == null) {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            confFile = "dictionary.xml";
        }
        InputStream is = DictionaryImpl.getInputStream(confFile);
        return DictionaryImpl.getInstance(is);
    }

    private static InputStream getInputStream(String confFile) {
        InputStream is = null;
        try {
            is = DictionarySingleton.class.getResourceAsStream(confFile);
            if (is == null) {
                logger.debug("Failed to locate dictionary configuration file: {}, in class classloader. Trying thread context class loader.", (Object)confFile);
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(confFile);
            }
            if (is == null) {
                logger.debug("Failed to locate dictionary configuration file: {}, in thread context class loader. Trying using 'config/' prefix.", (Object)confFile);
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream("config/" + confFile);
            }
            if (is == null) {
                logger.debug("Failed to locate dictionary configuration file: {}, in thread context class loader. Trying regular file.", (Object)confFile);
                File fDict = new File(confFile);
                if (fDict.exists()) {
                    is = new FileInputStream(fDict);
                } else {
                    logger.debug("Failed to locate dictionary configuration file: {}, from regular file. Trying using 'config/' prefix.", (Object)confFile);
                    fDict = new File("config/" + confFile);
                    if (fDict.exists()) {
                        is = new FileInputStream(fDict);
                    }
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            logger.debug("Could not load configuration file: {}, from any known location.", (Object)confFile);
        }
        return is;
    }

    private void init(InputStream is) {
        try {
            if (is != null) {
                this.configure(is);
            } else {
                this.setEnabled(false);
                logger.warn("Failed to initialize and configure Diameter Dictionary since configuration file was not found. Validator is disabled.");
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(InputStream is) {
        if (is == null) {
            logger.error("No input stream to configure dictionary from?");
            return;
        }
        try {
            long startTime = System.currentTimeMillis();
            this.avpByNameMap = new TreeMap<String, AvpRepresentation>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1 == null ? 1 : (o2 == null ? -1 : o1.compareTo(o2));
                }
            });
            this.vendorMap = new HashMap<String, String>();
            this.typedefMap = new HashMap<String, String>();
            this.avpMap = new HashMap<AvpRepresentation, AvpRepresentation>();
            this.commandMap = new HashMap<MessageRepresentation, MessageRepresentation>();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(is);
            doc.getDocumentElement().normalize();
            this.parseVendors(doc);
            this.parseTypeDefs(doc);
            this.parseAvps(doc);
            this.parseCommands(doc);
            this.configured = true;
            long endTime = System.currentTimeMillis();
            if (logger.isInfoEnabled()) {
                logger.info("Mobicents Diameter Dictionary loaded in {}ms -- Vendors[{}] Commands[{}] Types[{}] AVPs[{}]", new Object[]{endTime - startTime, this.vendorMap.size(), this.commandMap.size(), this.typedefMap.size(), this.avpMap.size()});
            }
            if (logger.isInfoEnabled()) {
                StringBuffer sb = new StringBuffer();
                int c = 0;
                for (AvpRepresentation key : this.avpMap.keySet()) {
                    if (!this.avpMap.get(key).isWeak()) continue;
                    ++c;
                    sb.append("---------------------------------\n").append("Found incomplete AVP definition:\n").append(this.avpMap.get(key)).append("\n");
                }
                if (c > 0) {
                    sb.append("------- TOTAL INCOMPLETE AVPS COUNT: ").append(c).append(" -------");
                    logger.info(sb.toString());
                }
            }
        }
        catch (Exception e) {
            this.enabled = false;
            this.configured = false;
            logger.error("Failed to parse validator configuration. Validator disabled.", (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.debug("Failed to close InputStream for Dictionary XML.", (Throwable)e);
            }
        }
    }

    protected void parseVendors(Document doc) {
        NodeList vendorNodes = doc.getElementsByTagName(_AVP_ATTRIBUTE_VENDOR);
        for (int v = 0; v < vendorNodes.getLength(); ++v) {
            Node vendorNode = vendorNodes.item(v);
            if (vendorNode.getNodeType() != 1) continue;
            Element vendorElement = (Element)vendorNode;
            String vendorCode = vendorElement.getAttribute(_AVP_ATTRIBUTE_CODE);
            String vendorId = vendorElement.getAttribute("vendor-id");
            this.vendorMap.put(vendorId, vendorCode);
        }
    }

    protected void parseTypeDefs(Document doc) {
        NodeList typedefNodes = doc.getElementsByTagName("typedefn");
        for (int td = 0; td < typedefNodes.getLength(); ++td) {
            Node typedefNode = typedefNodes.item(td);
            if (typedefNode.getNodeType() != 1) continue;
            Element typedefElement = (Element)typedefNode;
            String typeName = typedefElement.getAttribute("type-name");
            String typeParent = typedefElement.getAttribute("type-parent");
            if (typeParent == null || typeParent.equals("") || typeName.equals("UTF8String") || typeName.equals("Time")) {
                typeParent = typeName;
            }
            this.typedefMap.put(typeName, typeParent);
        }
    }

    protected void parseAvps(Document doc) {
        NodeList avpDefnNodes = doc.getElementsByTagName("avpdefn");
        for (int i = 0; i < avpDefnNodes.getLength(); ++i) {
            String avpOriginalType;
            Node avpNode = avpDefnNodes.item(i);
            Element avpDefnElement = (Element)avpNode;
            String avpName = avpDefnElement.getAttribute(_AVP_ATTRIBUTE_NAME);
            String avpCode = avpDefnElement.getAttribute(_AVP_ATTRIBUTE_CODE);
            String avpVendorId = avpDefnElement.getAttribute("vendor-id");
            String avpMandatory = avpDefnElement.getAttribute("mandatory");
            String avpProtected = avpDefnElement.getAttribute("protected").equals("") ? "may" : avpDefnElement.getAttribute("protected");
            String avpMayEncrypt = avpDefnElement.getAttribute("may-encrypt");
            String avpVendorBit = avpDefnElement.getAttribute("vendor-bit");
            long vendorCode = this.getVendorCode(avpVendorId);
            String avpType = avpOriginalType = UNDEFINED_AVP_TYPE;
            ArrayList<AvpRepresentation> groupedAvpChilds = new ArrayList<AvpRepresentation>();
            NodeList avpDefnChildNodes = avpNode.getChildNodes();
            for (int j = 0; j < avpDefnChildNodes.getLength(); ++j) {
                Node avpDefnChildNode = avpDefnChildNodes.item(j);
                if (avpDefnChildNode.getNodeType() != 1) continue;
                Element avpDefnChildElement = (Element)avpDefnChildNode;
                if (avpDefnChildElement.getNodeName().equals("grouped")) {
                    avpType = avpOriginalType = "Grouped";
                    NodeList groupedAvpMembers = avpDefnChildElement.getChildNodes();
                    for (int gChildIndex = 0; gChildIndex < groupedAvpMembers.getLength(); ++gChildIndex) {
                        Node groupedAvpChildNode = groupedAvpMembers.item(gChildIndex);
                        if (groupedAvpChildNode.getNodeType() != 1) continue;
                        Element groupedAvpChildElement = (Element)groupedAvpChildNode;
                        String childName = null;
                        String childMultiplicity = AVP_DEFAULT_MULTIPLICITY;
                        String childIndexIndicator = AVP_DEFAULT_INDEX;
                        if (!groupedAvpChildElement.hasAttribute(_AVP_ATTRIBUTE_NAME)) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug(new StringBuffer("[ERROR] Grouped child does not have name, grouped avp:  Name[").append(avpName).append("] Description[").append("").append("] Code[").append(avpCode).append("] May-Encrypt[").append(avpMayEncrypt).append("] Mandatory[").append(avpMandatory).append("] Protected [").append(avpProtected).append("] Vendor-Bit [").append(avpVendorBit).append("] Vendor-Id [").append(avpVendorId).append("] Constrained[").append("").append("] Type [").append(avpType).append("]").toString());
                            continue;
                        }
                        childName = groupedAvpChildElement.getAttribute(_AVP_ATTRIBUTE_NAME);
                        childMultiplicity = groupedAvpChildElement.hasAttribute(_AVP_ATTRIBUTE_MULTIPLICITY) ? groupedAvpChildElement.getAttribute(_AVP_ATTRIBUTE_MULTIPLICITY) : AVP_DEFAULT_MULTIPLICITY;
                        childIndexIndicator = groupedAvpChildElement.hasAttribute(_AVP_ATTRIBUTE_INDEX) ? groupedAvpChildElement.getAttribute(_AVP_ATTRIBUTE_INDEX) : AVP_DEFAULT_INDEX;
                        AvpRepresentation childRep = this.avpByNameMap.get(childName);
                        AvpRepresentationImpl child = null;
                        if (childRep != null) {
                            try {
                                child = (AvpRepresentationImpl)childRep.clone();
                            }
                            catch (CloneNotSupportedException cnse) {
                                if (logger.isWarnEnabled()) {
                                    logger.warn("Unable to clone AVP " + childRep, (Throwable)cnse);
                                }
                            }
                        } else {
                            child = new AvpRepresentationImpl(childName, vendorCode);
                            child.markWeak(true);
                        }
                        child.setMultiplicityIndicator(childMultiplicity);
                        child.markFixPosition(Integer.valueOf(childIndexIndicator));
                        groupedAvpChilds.add(child);
                    }
                    continue;
                }
                if (avpDefnChildElement.getNodeName().equals("type")) {
                    avpType = avpOriginalType = avpDefnChildElement.getAttribute("type-name");
                    if ((avpType = this.typedefMap.get(avpType)) != null) continue;
                    logger.warn("Unknown AVP Type ({}) for AVP with code {} and vendor-id {} ", new Object[]{avpDefnChildElement.getAttribute("type-name"), avpCode, avpVendorId});
                    continue;
                }
                logger.warn("Unknown AVP Definition child element for AVP with code {} and vendor-id {} ", (Object)avpCode, (Object)avpVendorId);
            }
            try {
                AvpRepresentationImpl avp = null;
                avp = new AvpRepresentationImpl(avpName, "N/A", Integer.valueOf(avpCode), avpMayEncrypt.equals("yes"), avpMandatory, avpProtected, avpVendorBit, vendorCode, avpOriginalType, avpType);
                if (avp.isGrouped()) {
                    avp.setChildren(groupedAvpChilds);
                    avp.markWeak(true);
                }
                this.resolveWeakLinks(avp);
                AvpRepresentation existingAvp = null;
                existingAvp = this.avpMap.get(avp);
                if (existingAvp != null) {
                    logger.warn("Duplicated AVP Definition for AVP Code: {}, Vendor-Id: {}. See TRACE logs for definitions.", (Object)avp.getCode(), (Object)avp.getVendorId());
                    logger.trace("Existing AVP:\r\n {}\r\n New AVP:\r\n {}", (Object)existingAvp, (Object)avp);
                } else {
                    this.avpMap.put(avp, avp);
                }
                AvpRepresentation oldAvp = this.avpByNameMap.put(avp.getName(), avp);
                if (oldAvp == null) continue;
                logger.debug("[WARN] Overwrited definition of AVP with the same name: Old: {}, New: {}", new Object[]{oldAvp, avp});
                continue;
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug(new StringBuffer("[ERROR] Failed Parsing AVP: Name[").append(avpName).append("] Description[").append("N/A").append("] Code[").append(avpCode).append("] May-Encrypt[").append(avpMayEncrypt).append("] Mandatory[").append(avpMandatory).append("] Protected [").append(avpProtected).append("] Vendor-Bit [").append(avpVendorBit).append("] Vendor-Id [").append(avpVendorId).append("] Constrained[").append("N/A").append("] OriginalType [").append(avpOriginalType).append("] Type [").append(avpType).append("]").toString(), (Throwable)e);
            }
        }
        for (AvpRepresentation rep : this.avpMap.values()) {
            this.markWeaks((AvpRepresentationImpl)rep);
        }
    }

    private boolean markWeaks(AvpRepresentationImpl rep) {
        if (rep.isGrouped()) {
            boolean isWeak = false;
            for (AvpRepresentation repC : rep.getChildren()) {
                if (!this.markWeaks((AvpRepresentationImpl)repC)) continue;
                isWeak = true;
            }
            rep.markWeak(isWeak);
        } else {
            rep.markWeak(rep.getCode() == -1);
        }
        return rep.isWeak();
    }

    private void resolveWeakLinks(AvpRepresentation newAvp) {
        for (AvpRepresentation avp : this.avpMap.values()) {
            if (!avp.isGrouped() || avp.getName().equals(newAvp.getName())) continue;
            List avpChilds = avp.getChildren();
            for (int n = 0; n < avpChilds.size(); ++n) {
                AvpRepresentation avpChild = (AvpRepresentation)avpChilds.get(n);
                if (!avpChild.getName().equals(newAvp.getName())) continue;
                try {
                    AvpRepresentationImpl strongAvp = (AvpRepresentationImpl)newAvp.clone();
                    strongAvp.setMultiplicityIndicator(avpChild.getMultiplicityIndicator());
                    strongAvp.markFixPosition(avpChild.getPositionIndex());
                    strongAvp.markWeak(false);
                    avpChilds.set(n, strongAvp);
                    this.resolveWeakLinks(avp);
                    continue;
                }
                catch (CloneNotSupportedException cnse) {
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn("Unable to clone AVP " + newAvp, (Throwable)cnse);
                }
            }
        }
    }

    private void parseCommands(Document doc) {
        NodeList applicationNodes = doc.getElementsByTagName("application");
        for (int applicationIndex = 0; applicationIndex < applicationNodes.getLength(); ++applicationIndex) {
            if (applicationNodes.item(applicationIndex).getNodeType() != 1) continue;
            Element applicationElement = (Element)applicationNodes.item(applicationIndex);
            if (!applicationElement.hasAttribute("id")) {
                logger.debug("[ERROR] Application definition does not have ID, skipping message");
                continue;
            }
            long applicationCode = Long.valueOf(applicationElement.getAttribute("id"));
            NodeList commandNodes = applicationElement.getElementsByTagName("command");
            for (int c = 0; c < commandNodes.getLength(); ++c) {
                Node commandNode = commandNodes.item(c);
                if (commandNode.getNodeType() != 1) continue;
                Element commandElement = (Element)commandNode;
                if (!commandElement.hasAttribute("request")) {
                    logger.debug("[ERROR] Command for application: {} does not define if its request or answer, skipping.", (Object)applicationCode);
                    continue;
                }
                String commandName = commandElement.getAttribute(_AVP_ATTRIBUTE_NAME);
                String commandCode = commandElement.getAttribute(_AVP_ATTRIBUTE_CODE);
                String isRequest = commandElement.getAttribute("request");
                MessageRepresentationImpl msg = new MessageRepresentationImpl(Integer.valueOf(commandCode), applicationCode, Boolean.parseBoolean(isRequest), commandName);
                HashMap<AvpRepresentation, AvpRepresentation> commandAvpList = new HashMap<AvpRepresentation, AvpRepresentation>();
                this.commandMap.put(msg, msg);
                NodeList commandAvpsList = commandElement.getElementsByTagName("avp");
                for (int commandAvpIndex = 0; commandAvpIndex < commandAvpsList.getLength(); ++commandAvpIndex) {
                    if (commandAvpsList.item(commandAvpIndex).getNodeType() != 1) continue;
                    Element commandAvpElement = (Element)commandAvpsList.item(commandAvpIndex);
                    String multiplicity = null;
                    String name = null;
                    String index = null;
                    if (!commandAvpElement.hasAttribute(_AVP_ATTRIBUTE_NAME)) {
                        logger.debug("[ERROR] Command defines avp without name! Command: {}, Code: {}, ApplicationID: {}", new Object[]{msg.getName(), msg.getCommandCode(), msg.getApplicationId()});
                        continue;
                    }
                    name = commandAvpElement.getAttribute(_AVP_ATTRIBUTE_NAME);
                    if (!commandAvpElement.hasAttribute(_AVP_ATTRIBUTE_MULTIPLICITY)) {
                        logger.debug("[WARN] Command defines avp without multiplicity.");
                        multiplicity = AVP_DEFAULT_MULTIPLICITY;
                    } else {
                        multiplicity = commandAvpElement.getAttribute(_AVP_ATTRIBUTE_MULTIPLICITY);
                    }
                    index = commandAvpElement.hasAttribute(_AVP_ATTRIBUTE_INDEX) ? commandAvpElement.getAttribute(_AVP_ATTRIBUTE_INDEX) : AVP_DEFAULT_INDEX;
                    String avpCode = commandAvpElement.getAttribute(_AVP_ATTRIBUTE_CODE);
                    String avpVendor = commandAvpElement.getAttribute(_AVP_ATTRIBUTE_VENDOR);
                    if (avpCode == null) {
                        logger.debug("[ERROR] Command defines avp without code! Command: {}, Code: {}, ApplicationID: {}", new Object[]{msg.getName(), msg.getCommandCode(), msg.getApplicationId()});
                        continue;
                    }
                    if (avpVendor == null) {
                        logger.debug("[WARN] Command defines avp without vendor, assuming default. Command: {}, Code: {}, ApplicationID: {}", new Object[]{msg.getName(), msg.getCommandCode(), msg.getApplicationId()});
                        avpVendor = "0";
                    }
                    AvpRepresentation strongRepresentation = null;
                    AvpRepresentation strongKey = this.getMapKey(Integer.valueOf(avpCode), Long.valueOf(avpVendor));
                    strongRepresentation = this.avpMap.get(strongKey);
                    if (strongRepresentation != null && !strongRepresentation.isWeak()) {
                        try {
                            AvpRepresentationImpl clone = (AvpRepresentationImpl)strongRepresentation.clone();
                            clone.setMultiplicityIndicator(multiplicity);
                            clone.markFixPosition(Integer.valueOf(index));
                            commandAvpList.put(clone, clone);
                        }
                        catch (CloneNotSupportedException cnse) {
                            if (!logger.isWarnEnabled()) continue;
                            logger.warn("Unable to clone AVP " + strongRepresentation, (Throwable)cnse);
                        }
                        continue;
                    }
                    logger.debug("[WARN] No strong avp for key {}, in name: {}", new Object[]{strongKey, name});
                }
                msg.setMessageAvps(commandAvpList);
            }
        }
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public AvpRepresentation getAvp(int code) {
        return this.getAvp(code, 0L);
    }

    public AvpRepresentation getAvp(int code, long vendorId) {
        if (!this.configured) {
            return null;
        }
        AvpRepresentation avp = this.avpMap.get(this.getMapKey(code, vendorId));
        if (avp == null) {
            logger.warn("AVP with code {} and Vendor-Id {} not present in dictionary!", (Object)code, (Object)vendorId);
        }
        return avp;
    }

    public AvpRepresentation getAvp(String avpName) {
        return this.configured ? this.avpByNameMap.get(avpName) : null;
    }

    private long getVendorCode(String vendorId) {
        String vendorCode;
        long value = -1L;
        value = vendorId == null ? 0L : ((vendorCode = this.vendorMap.get(vendorId)) == null ? 0L : Long.parseLong(vendorCode));
        return value;
    }

    private AvpRepresentation getMapKey(int avpCode, long vendorId) {
        return new AvpRepresentationImpl(avpCode, vendorId);
    }

    public MessageRepresentation getMessage(int commandCode, boolean isRequest) {
        return this.getMessage(commandCode, 0L, isRequest);
    }

    public MessageRepresentation getMessage(int commandCode, long applicationId, boolean isRequest) {
        if (!this.configured) {
            return null;
        }
        MessageRepresentationImpl key = new MessageRepresentationImpl(commandCode, applicationId, isRequest);
        return this.commandMap.get(key);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ValidatorLevel getSendLevel() {
        return this.sendValidationLevel;
    }

    public ValidatorLevel getReceiveLevel() {
        return this.receiveValidationLevel;
    }

    public void setSendLevel(ValidatorLevel level) {
        this.sendValidationLevel = level;
    }

    public void setReceiveLevel(ValidatorLevel level) {
        this.receiveValidationLevel = level;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setConfigured(boolean configured) {
        this.configured = configured;
    }

    public void validate(Message msg, boolean incoming) throws AvpNotAllowedException {
        if (!this.enabled || !this.configured) {
            return;
        }
        MessageRepresentationImpl rep = new MessageRepresentationImpl(msg.getCommandCode(), msg.getApplicationId(), msg.isRequest());
        if ((rep = (MessageRepresentationImpl)this.commandMap.get(rep)) == null) {
            logger.warn("Validation could not be performed, command not defined!. Code={}, Application-Id={}, Req={}", new Object[]{msg.getCommandCode(), msg.getApplicationId(), msg.isRequest()});
            return;
        }
        rep.validate(msg, incoming ? this.receiveValidationLevel : this.sendValidationLevel);
    }

    public Map<AvpRepresentation, AvpRepresentation> getAvpMap() {
        return this.avpMap;
    }

    public Map<String, String> getVendorMap() {
        return this.vendorMap;
    }

    public Map<MessageRepresentation, MessageRepresentation> getCommandMap() {
        return this.commandMap;
    }

    public Map<String, String> getTypedefMap() {
        return this.typedefMap;
    }

    public Map<String, AvpRepresentation> getNameToCodeMap() {
        return this.avpByNameMap;
    }

    protected void printAvpTree(AvpRepresentation rep, String tab) {
        String x = tab + "+-- " + rep.getCode() + "/" + rep.getVendorId();
        while (x.length() < 25) {
            x = x + ".";
        }
        System.out.println(x + rep.getName() + " > " + rep.getType());
        if (rep.isGrouped()) {
            for (AvpRepresentation repC : rep.getChildren()) {
                this.printAvpTree(repC, "  " + tab);
            }
        }
    }
}

