/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.validation;

import java.util.ArrayList;
import java.util.List;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.api.validation.AvpRepresentation;

public class AvpRepresentationImpl
implements AvpRepresentation {
    protected String description;
    protected boolean mayEncrypt;
    protected boolean _protected;
    protected boolean _mandatory;
    protected String ruleMandatory;
    protected String ruleProtected;
    protected String ruleVendorBit;
    protected String originalType;
    protected String type;
    private int positionIndex = -1;
    protected int code = -1;
    protected long vendor = 0L;
    protected boolean allowed = true;
    protected String multiplicityIndicator = "0";
    protected String name = "Some-AVP";
    protected boolean grouped = false;
    protected List<AvpRepresentation> children = new ArrayList<AvpRepresentation>();
    protected boolean weak = false;

    public AvpRepresentationImpl(AvpRepresentationImpl clone) {
        this(-1, clone.code, clone.getVendorId(), clone.getMultiplicityIndicator(), clone.getName());
        this.allowed = clone.allowed;
        this.code = clone.code;
        this.grouped = clone.grouped;
        this.multiplicityIndicator = clone.multiplicityIndicator;
        this.name = clone.name;
        this.positionIndex = clone.positionIndex;
        this.vendor = clone.vendor;
        this.weak = clone.weak;
        this._mandatory = clone._mandatory;
        this._protected = clone._protected;
        this.description = clone.description;
        this.mayEncrypt = clone.mayEncrypt;
        this.ruleMandatory = clone.ruleMandatory;
        this.ruleProtected = clone.ruleProtected;
        this.ruleVendorBit = clone.ruleVendorBit;
        this.originalType = clone.originalType;
        this.type = clone.type;
        if (this.multiplicityIndicator.equals("0")) {
            this.allowed = false;
        }
    }

    public AvpRepresentationImpl() {
        this.weak = true;
    }

    public AvpRepresentationImpl(String name, long vendor) {
        this.name = name;
        this.vendor = vendor;
        this.weak = true;
    }

    public AvpRepresentationImpl(int code, long vendor) {
        this.code = code;
        this.vendor = vendor;
        if (this.multiplicityIndicator.equals("0")) {
            this.allowed = false;
        }
    }

    public AvpRepresentationImpl(int positionIndex, int code, long vendor, String multiplicityIndicator, String name) {
        this.positionIndex = positionIndex;
        this.code = code;
        this.vendor = vendor;
        this.multiplicityIndicator = multiplicityIndicator;
        this.name = name;
        if (this.multiplicityIndicator.equals("0")) {
            this.allowed = false;
        }
    }

    public AvpRepresentationImpl(int code, long vendor, String name) {
        this.positionIndex = -1;
        this.code = code;
        this.vendor = vendor;
        this.multiplicityIndicator = "0+";
        this.name = name;
        if (this.multiplicityIndicator.equals("0")) {
            this.allowed = false;
        }
    }

    public AvpRepresentationImpl(String name, String description, int code, boolean mayEncrypt, String ruleMandatory, String ruleProtected, String ruleVendorBit, long vendorId, String originalType, String type) {
        this(-1, code, vendorId, "0+", name);
        this.description = description;
        this.mayEncrypt = mayEncrypt;
        this.ruleMandatory = ruleMandatory;
        this.ruleProtected = ruleProtected;
        this.ruleVendorBit = ruleVendorBit;
        if (this.ruleMandatory == null || this.ruleMandatory.equals("")) {
            this.ruleMandatory = "may";
        }
        if (this.ruleProtected == null || this.ruleProtected.equals("")) {
            this.ruleProtected = "may";
        }
        if (this.ruleVendorBit == null || this.ruleVendorBit.equals("")) {
            this.ruleVendorBit = "mustnot";
        }
        this.originalType = originalType;
        this.type = type;
        this._mandatory = this.ruleMandatory.equals("must");
        this._protected = this.ruleProtected.equals("must");
        if (type.equals(AvpRepresentation.Type.Grouped.toString())) {
            this.setGrouped(true);
        }
        if (this.multiplicityIndicator.equals("0")) {
            this.allowed = false;
        }
    }

    public boolean isPositionFixed() {
        return this.positionIndex == -1;
    }

    public void markFixPosition(int index) {
        this.positionIndex = index;
    }

    public boolean isCountValidForMultiplicity(AvpSet destination, int numberToAdd) {
        AvpSet innerSet = destination.getAvps(this.getCode(), this.getVendorId());
        int count = numberToAdd;
        if (innerSet != null) {
            count += innerSet.size();
        }
        return this.isCountValidForMultiplicity(count);
    }

    public boolean isCountValidForMultiplicity(int avpCount) {
        return !this.allowed ? avpCount == 0 : (this.multiplicityIndicator.equals("0+") ? avpCount >= 0 : (this.multiplicityIndicator.equals("0-1") ? avpCount == 0 || avpCount == 1 : (this.multiplicityIndicator.equals("1") ? avpCount == 1 : this.multiplicityIndicator.equals("1+") && avpCount >= 1)));
    }

    public static int get_FIX_POSITION_INDEX() {
        return -1;
    }

    public int getPositionIndex() {
        return this.positionIndex;
    }

    public int getCode() {
        return this.code;
    }

    public long getVendorId() {
        return this.vendor;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public boolean isAllowed(int avpCode, long vendorId) {
        if (this.isGrouped()) {
            for (AvpRepresentation rep : this.children) {
                if (rep.getCode() != avpCode || rep.getVendorId() != vendorId) continue;
                return rep.isAllowed();
            }
            return true;
        }
        return false;
    }

    public boolean isAllowed(int avpCode) {
        return this.isAllowed(avpCode, 0L);
    }

    public String getMultiplicityIndicator() {
        return this.multiplicityIndicator;
    }

    public String getName() {
        return this.name;
    }

    public boolean isGrouped() {
        return this.grouped;
    }

    public void setGrouped(boolean grouped) {
        this.grouped = grouped;
    }

    public List<AvpRepresentation> getChildren() {
        return this.children;
    }

    public void setChildren(List<AvpRepresentation> children) {
        this.children = children;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setVendorId(long vendor) {
        this.vendor = vendor;
    }

    public void setMultiplicityIndicator(String multiplicityIndicator) {
        this.multiplicityIndicator = multiplicityIndicator;
        if (this.multiplicityIndicator.equals("0")) {
            this.allowed = false;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isWeak() {
        return this.weak;
    }

    public void markWeak(boolean isWeak) {
        this.weak = isWeak;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isMayEncrypt() {
        return this.mayEncrypt;
    }

    public String getRuleMandatory() {
        return this.ruleMandatory;
    }

    public int getRuleMandatoryAsInt() {
        return AvpRepresentation.Rule.valueOf((String)this.ruleMandatory).ordinal();
    }

    public String getRuleProtected() {
        return this.ruleProtected;
    }

    public int getRuleProtectedAsInt() {
        return AvpRepresentation.Rule.valueOf((String)this.ruleProtected).ordinal();
    }

    public String getRuleVendorBit() {
        return this.ruleVendorBit;
    }

    public int getRuleVendorBitAsInt() {
        return AvpRepresentation.Rule.valueOf((String)this.ruleVendorBit).ordinal();
    }

    public String getOriginalType() {
        return this.originalType;
    }

    public String getType() {
        return this.type;
    }

    public boolean isProtected() {
        return this._protected;
    }

    public boolean isMandatory() {
        return this._mandatory;
    }

    public void validate(Avp avp) throws AvpNotAllowedException {
        if (this.isGrouped()) {
            try {
                AvpSet avpAsGrouped = avp.getGrouped();
                this.validate(avpAsGrouped);
            }
            catch (AvpDataException e) {
                throw new AvpNotAllowedException("Failed to parse AVP to grouped!", (Throwable)e, this.code, this.vendor);
            }
        }
    }

    public void validate(AvpSet avpSet) throws AvpNotAllowedException {
        for (AvpRepresentation childrenVAvp : this.getChildren()) {
            AvpSet childSset;
            int count;
            if (!childrenVAvp.isCountValidForMultiplicity(count = (childSset = avpSet.getAvps(childrenVAvp.getCode(), childrenVAvp.getVendorId())).size())) {
                throw new AvpNotAllowedException("AVP: " + childrenVAvp + " has wrong count, in grouped parent avp - " + count + ", allowed: " + childrenVAvp.getMultiplicityIndicator(), this.getCode(), this.getVendorId());
            }
            if (!childrenVAvp.isGrouped()) continue;
            for (int index = 0; index < childSset.size(); ++index) {
                Avp presumablyGrouped = childSset.getAvpByIndex(index);
                childrenVAvp.validate(presumablyGrouped);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("name: ").append(this.getName()).append(", code: ").append(this.getCode()).append(", vendor: ").append(this.getVendorId()).append(", weak: ").append(this.isWeak()).append(", grouped: ").append(this.isGrouped()).append(", type: ").append(this.getType()).append(", multiplicity: ").append(this.getMultiplicityIndicator());
        if (this.isGrouped()) {
            for (AvpRepresentation child : this.getChildren()) {
                String childStr = child.toString().replace("\n", "\n---");
                sb.append("\n---" + childStr);
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.code;
        result = 31 * result + (int)(this.vendor ^ this.vendor >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AvpRepresentationImpl other = (AvpRepresentationImpl)obj;
        if (this.code != other.code) {
            return false;
        }
        return this.vendor == other.vendor;
    }

    public Object clone() throws CloneNotSupportedException {
        AvpRepresentationImpl clone = new AvpRepresentationImpl();
        clone.allowed = this.allowed;
        clone.code = this.code;
        clone.grouped = this.grouped;
        clone.multiplicityIndicator = this.multiplicityIndicator;
        clone.name = this.name;
        clone.positionIndex = this.positionIndex;
        clone.vendor = this.vendor;
        clone.weak = this.weak;
        clone._mandatory = this._mandatory;
        clone._protected = this._protected;
        clone.description = this.description;
        clone.mayEncrypt = this.mayEncrypt;
        clone.ruleMandatory = this.ruleMandatory;
        clone.ruleProtected = this.ruleProtected;
        clone.ruleVendorBit = this.ruleVendorBit;
        clone.originalType = this.originalType;
        clone.type = this.type;
        ArrayList<AvpRepresentation> cloneChildren = new ArrayList<AvpRepresentation>();
        clone.children = cloneChildren;
        for (AvpRepresentation c : this.children) {
            cloneChildren.add((AvpRepresentation)c.clone());
        }
        return clone;
    }
}

