/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import org.jdiameter.common.api.statistic.IStatistic;
import org.jdiameter.common.api.statistic.IStatisticRecord;
import org.jdiameter.common.impl.concurrent.AbstractTask;

class DefaultCallable<L>
extends AbstractTask<Callable<L>>
implements Callable<L> {
    DefaultCallable(Callable<L> task, IStatistic statistic, IStatisticRecord ... statisticRecords) {
        super(task, statistic, statisticRecords);
    }

    @Override
    public L call() throws Exception {
        long time = 0L;
        if (this.statistic.isEnabled()) {
            this.getCounter(IStatisticRecord.Counters.WorkingThread).inc();
            time = System.nanoTime();
        }
        try {
            Object v = ((Callable)this.parentTask).call();
            return (L)v;
        }
        catch (CancellationException e) {
            if (this.statistic.isEnabled()) {
                this.getCounter(IStatisticRecord.Counters.CanceledTasks).inc();
            }
            throw e;
        }
        catch (Exception e) {
            if (this.statistic.isEnabled()) {
                this.getCounter(IStatisticRecord.Counters.BrokenTasks).inc();
            }
            throw e;
        }
        finally {
            if (this.statistic.isEnabled()) {
                this.updateTimeStatistic(time, time - this.createdTime);
                this.getCounter(IStatisticRecord.Counters.WorkingThread).dec();
            }
        }
    }
}

