/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.concurrent;

import org.jdiameter.common.api.statistic.IStatistic;
import org.jdiameter.common.api.statistic.IStatisticRecord;

abstract class AbstractTask<L> {
    protected L parentTask;
    protected long createdTime = System.nanoTime();
    protected IStatistic statistic;
    protected IStatisticRecord execTimeSumm;
    protected IStatisticRecord execTimeCount;
    protected IStatisticRecord waitTimeSumm;
    protected IStatisticRecord waitTimeCount;

    AbstractTask(L task, IStatistic statistic, IStatisticRecord ... statisticRecords) {
        this.parentTask = task;
        this.execTimeSumm = statisticRecords[0];
        this.execTimeCount = statisticRecords[1];
        this.waitTimeSumm = statisticRecords[2];
        this.waitTimeCount = statisticRecords[3];
        this.statistic = statistic;
    }

    protected IStatisticRecord getCounter(IStatisticRecord.Counters counter) {
        return this.statistic.getRecordByName(counter.name());
    }

    protected void updateTimeStatistic(long time, long waitTime) {
        if (this.statistic.isEnabled()) {
            this.execTimeSumm.inc((System.nanoTime() - time) / 999999L);
            this.execTimeCount.inc();
            this.waitTimeSumm.inc(waitTime / 999999L);
            this.waitTimeCount.inc();
        }
    }

    public boolean equals(Object o) {
        return this == o || this.parentTask.equals(o);
    }

    public int hashCode() {
        return this.parentTask.hashCode();
    }

    public static class AverageValueHolder
    implements IStatisticRecord.ValueHolder {
        private IStatistic statistic;
        private IStatisticRecord.Counters counter;

        AverageValueHolder(IStatistic statistic, IStatisticRecord.Counters counter) {
            this.statistic = statistic;
            this.counter = counter;
        }

        public double getValueAsDouble() {
            IStatisticRecord record = this.statistic.getRecordByName(this.counter.name());
            if (this.statistic.isEnabled() && (record.getChilds().length == 2 || record.getChilds()[1].getValueAsLong() != 0L)) {
                long count = record.getChilds()[1].getValueAsLong();
                return (float)record.getChilds()[0].getValueAsLong() / (float)(count != 0L ? count : 1L);
            }
            return 0.0;
        }

        @Override
        public String getValueAsString() {
            return String.valueOf(this.getValueAsDouble());
        }
    }
}

