/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.transport.tls.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import javax.net.ssl.SSLEngine;
import org.jdiameter.client.impl.transport.tls.netty.DiameterMessageDecoder;
import org.jdiameter.client.impl.transport.tls.netty.DiameterMessageEncoder;
import org.jdiameter.client.impl.transport.tls.netty.DiameterMessageHandler;
import org.jdiameter.client.impl.transport.tls.netty.InbandSecurityHandler;
import org.jdiameter.client.impl.transport.tls.netty.SslContextFactory;
import org.jdiameter.client.impl.transport.tls.netty.TLSTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartTlsServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(StartTlsServerHandler.class);
    private final TLSTransportClient tlsTransportClient;

    public StartTlsServerHandler(TLSTransportClient tlsTransportClient) {
        this.tlsTransportClient = tlsTransportClient;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        logger.debug("StartTlsServerHandler");
        ByteBuf buf = (ByteBuf)msg;
        byte[] bytes = new byte[buf.readableBytes()];
        buf.getBytes(buf.readerIndex(), bytes);
        if ("StartTlsRequest".equals(new String(bytes))) {
            logger.debug("Received StartTlsRequest");
            SslContext sslContext = SslContextFactory.getSslContextForServer(this.tlsTransportClient.getConfig());
            SSLEngine sslEngine = sslContext.newEngine(ctx.alloc());
            sslEngine.setUseClientMode(false);
            SslHandler sslHandler = new SslHandler(sslEngine, false);
            final ChannelPipeline pipeline = ctx.pipeline();
            pipeline.remove("decoder");
            pipeline.remove("msgHandler");
            pipeline.remove("encoder");
            pipeline.remove("inbandWriter");
            pipeline.remove((ChannelHandler)this);
            pipeline.addLast("sslHandler", (ChannelHandler)sslHandler);
            sslHandler.handshakeFuture().addListener(new GenericFutureListener(){

                public void operationComplete(Future future) throws Exception {
                    if (future.isSuccess()) {
                        logger.debug("StartTls server handshake succesfull");
                        StartTlsServerHandler.this.tlsTransportClient.setTlsHandshakingState(TLSTransportClient.TlsHandshakingState.SHAKEN);
                        logger.debug("restoring all handlers");
                        pipeline.addLast("decoder", (ChannelHandler)new DiameterMessageDecoder(StartTlsServerHandler.this.tlsTransportClient.getParent(), StartTlsServerHandler.this.tlsTransportClient.getParser()));
                        pipeline.addLast("msgHandler", (ChannelHandler)new DiameterMessageHandler(StartTlsServerHandler.this.tlsTransportClient.getParent(), true));
                        pipeline.addLast("encoder", (ChannelHandler)new DiameterMessageEncoder(StartTlsServerHandler.this.tlsTransportClient.getParser()));
                        pipeline.addLast("inbandWriter", (ChannelHandler)new InbandSecurityHandler());
                    }
                }
            });
            ReferenceCountUtil.release((Object)msg);
            logger.debug("Sending StartTlsResponse");
            ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])"StartTlsResponse".getBytes())).addListener(new GenericFutureListener(){

                public void operationComplete(Future f) throws Exception {
                    if (!f.isSuccess()) {
                        logger.error(f.cause().getMessage(), f.cause());
                    }
                }
            });
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error(cause.getMessage(), cause);
    }
}

