/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.transport.tls.netty;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.jdiameter.api.Configuration;
import org.jdiameter.client.impl.helpers.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SslContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(SslContextFactory.class);

    public static SslContext getSslContextForClient(Configuration config) throws SSLException, Exception {
        SslContext sslContext = SslContextBuilder.forClient().keyManager(SslContextFactory.getKeyManagerFactory(config)).trustManager(SslContextFactory.getTrustManagerFactory(config)).build();
        return sslContext;
    }

    public static SslContext getSslContextForServer(Configuration config) throws SSLException, Exception {
        SslContext sslContext = SslContextBuilder.forServer((KeyManagerFactory)SslContextFactory.getKeyManagerFactory(config)).trustManager(SslContextFactory.getTrustManagerFactory(config)).build();
        return sslContext;
    }

    public static KeyManagerFactory getKeyManagerFactory(Configuration sslConfig) throws Exception {
        Configuration kdConfig = sslConfig.getChildren(Parameters.KeyData.ordinal())[0];
        String keyManagerAlgo = kdConfig.getStringValue(Parameters.KDManager.ordinal(), null);
        String keyStoreType = kdConfig.getStringValue(Parameters.KDStore.ordinal(), null);
        String keyStorePassword = kdConfig.getStringValue(Parameters.KDPwd.ordinal(), null);
        String keyStoreFile = kdConfig.getStringValue(Parameters.KDFile.ordinal(), null);
        logger.debug("keyManagerAlgo: {}", (Object)keyManagerAlgo);
        logger.debug("keyStoreType: {}", (Object)keyStoreType);
        logger.debug("keyStorePassword: {}", (Object)keyStorePassword);
        logger.debug("keyStoreFile: {}", (Object)keyStoreFile);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerAlgo);
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        char[] key = keyStorePassword.toCharArray();
        keyStore.load(new FileInputStream(keyStoreFile), key);
        keyManagerFactory.init(keyStore, key);
        return keyManagerFactory;
    }

    public static TrustManagerFactory getTrustManagerFactory(Configuration sslConfig) throws Exception {
        Configuration tdConfig = sslConfig.getChildren(Parameters.TrustData.ordinal())[0];
        String trustManagerAlgo = tdConfig.getStringValue(Parameters.TDManager.ordinal(), null);
        String trustStoreType = tdConfig.getStringValue(Parameters.TDStore.ordinal(), null);
        String trustStorePassword = tdConfig.getStringValue(Parameters.TDPwd.ordinal(), null);
        String trustStoreFile = tdConfig.getStringValue(Parameters.TDFile.ordinal(), null);
        logger.debug("trustManagerAlgo: {}", (Object)trustManagerAlgo);
        logger.debug("trustStoreType: {}", (Object)trustStoreType);
        logger.debug("trustStorePassword: {}", (Object)trustStorePassword);
        logger.debug("trustStoreFile: {}", (Object)trustStoreFile);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustManagerAlgo);
        KeyStore trustKeyStore = KeyStore.getInstance(trustStoreType);
        char[] trustKey = trustStorePassword.toCharArray();
        trustKeyStore.load(new FileInputStream(trustStoreFile), trustKey);
        trustManagerFactory.init(trustKeyStore);
        return trustManagerFactory;
    }
}

