/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.transport.tls.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.nio.ByteBuffer;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.parser.IMessageParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiameterMessageEncoder
extends MessageToByteEncoder<IMessage> {
    private static final Logger logger = LoggerFactory.getLogger(DiameterMessageEncoder.class);
    protected final IMessageParser parser;

    public DiameterMessageEncoder(IMessageParser parser) {
        this.parser = parser;
    }

    protected void encode(ChannelHandlerContext ctx, IMessage msg, ByteBuf out) throws Exception {
        logger.debug("DiameterMessageEncoder");
        logger.debug("Encoding message command code {}", (Object)msg.getCommandCode());
        out.writeBytes(Unpooled.wrappedBuffer((ByteBuffer)this.parser.encodeMessage(msg)));
    }
}

