/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.transport.sctp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.OverloadException;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.io.IConnection;
import org.jdiameter.client.api.io.IConnectionListener;
import org.jdiameter.client.api.io.TransportError;
import org.jdiameter.client.api.io.TransportException;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.impl.transport.sctp.SCTPTransportClient;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCTPClientConnection
implements IConnection {
    private static Logger logger = LoggerFactory.getLogger(SCTPClientConnection.class);
    private final long createdTime;
    private SCTPTransportClient client;
    private LinkedBlockingQueue<Event> buffer = new LinkedBlockingQueue(64);
    private IMessageParser parser;
    private Lock lock = new ReentrantLock();
    private ConcurrentLinkedQueue<IConnectionListener> listeners = new ConcurrentLinkedQueue();
    private String cachedKey = null;

    protected SCTPClientConnection(IMessageParser parser) {
        this.createdTime = System.currentTimeMillis();
        this.parser = parser;
        this.client = new SCTPTransportClient(this);
    }

    public SCTPClientConnection(Configuration config, IConcurrentFactory concurrentFactory, InetAddress remoteAddress, int remotePort, InetAddress localAddress, int localPort, IMessageParser parser, String ref) {
        this(parser);
        logger.debug("SCTP Client constructor. Remote [{}:{}] Local [{}:{}]", new Object[]{remoteAddress, remotePort, localAddress, localPort});
        this.client.setDestAddress(new InetSocketAddress(remoteAddress, remotePort));
        this.client.setOrigAddress(new InetSocketAddress(localAddress, localPort));
    }

    public SCTPClientConnection(Configuration config, IConcurrentFactory concurrentFactory, InetAddress remoteAddress, int remotePort, InetAddress localAddress, int localPort, IConnectionListener listener, IMessageParser parser, String ref) {
        this(parser);
        logger.debug("SCTP Client constructor (with ref). Remote [{}:{}] Local [{}:{}]", new Object[]{remoteAddress, remotePort, localAddress, localPort});
        this.client.setDestAddress(new InetSocketAddress(remoteAddress, remotePort));
        this.client.setOrigAddress(new InetSocketAddress(localAddress, localPort));
        this.listeners.add(listener);
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public void connect() throws TransportException {
        try {
            this.getClient().initialize();
            this.getClient().start();
        }
        catch (IOException e) {
            throw new TransportException("Cannot init transport: ", TransportError.NetWorkError, e);
        }
        catch (Exception e) {
            throw new TransportException("Cannot init transport: ", TransportError.Internal, e);
        }
    }

    @Override
    public void disconnect() throws InternalError {
        try {
            if (this.getClient() != null) {
                this.getClient().stop();
            }
        }
        catch (Exception e) {
            throw new InternalError("Error while stopping transport: " + e.getMessage());
        }
    }

    @Override
    public void release() throws IOException {
        try {
            if (this.getClient() != null) {
                this.getClient().release();
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        finally {
            this.parser = null;
            this.buffer.clear();
            this.remAllConnectionListener();
        }
    }

    @Override
    public void sendMessage(IMessage message) throws TransportException, OverloadException {
        try {
            if (this.getClient() != null) {
                this.getClient().sendMessage(this.parser.encodeMessage(message));
            }
        }
        catch (Exception e) {
            throw new TransportException("Cannot send message: ", TransportError.FailedSendMessage, e);
        }
    }

    protected SCTPTransportClient getClient() {
        return this.client;
    }

    @Override
    public boolean isNetworkInitiated() {
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.getClient() != null && this.getClient().isConnected();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.getClient().getDestAddress().getAddress();
    }

    @Override
    public int getRemotePort() {
        return this.getClient().getDestAddress().getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionListener(IConnectionListener listener) {
        this.lock.lock();
        try {
            this.listeners.add(listener);
            if (this.buffer.size() != 0) {
                for (Event e : this.buffer) {
                    try {
                        this.onEvent(e);
                    }
                    catch (AvpDataException avpDataException) {}
                }
                this.buffer.clear();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void remAllConnectionListener() {
        this.lock.lock();
        try {
            this.listeners.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void remConnectionListener(IConnectionListener listener) {
        this.lock.lock();
        try {
            this.listeners.remove(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isWrapperFor(Class<?> aClass) throws InternalException {
        return false;
    }

    public <T> T unwrap(Class<T> aClass) throws InternalException {
        return null;
    }

    @Override
    public String getKey() {
        if (this.cachedKey == null) {
            this.cachedKey = new StringBuffer("aaa://").append(this.getRemoteAddress().getHostName()).append(":").append(this.getRemotePort()).toString();
        }
        return this.cachedKey;
    }

    protected void onDisconnect() throws AvpDataException {
        this.onEvent(new Event(EventType.DISCONNECTED));
    }

    protected void onMessageReceived(ByteBuffer message) throws AvpDataException {
        if (logger.isDebugEnabled()) {
            logger.debug("Received message of size [{}]", (Object)message.array().length);
        }
        this.onEvent(new Event(EventType.MESSAGE_RECEIVED, message));
    }

    protected void onAvpDataException(AvpDataException e) {
        try {
            this.onEvent(new Event(EventType.DATA_EXCEPTION, (Exception)((Object)e)));
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    protected void onConnected() {
        try {
            this.onEvent(new Event(EventType.CONNECTED));
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEvent(Event event) throws AvpDataException {
        this.lock.lock();
        try {
            if (this.processBufferedMessages(event)) {
                for (IConnectionListener listener : this.listeners) {
                    switch (event.type) {
                        case CONNECTED: {
                            listener.connectionOpened(this.getKey());
                            break;
                        }
                        case DISCONNECTED: {
                            listener.connectionClosed(this.getKey(), null);
                            break;
                        }
                        case MESSAGE_RECEIVED: {
                            listener.messageReceived(this.getKey(), this.parser.createMessage(event.message));
                            break;
                        }
                        case DATA_EXCEPTION: {
                            listener.internalError(this.getKey(), null, new TransportException("Avp Data Exception:", TransportError.ReceivedBrokenMessage, event.exception));
                        }
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean processBufferedMessages(Event event) throws AvpDataException {
        if (this.listeners.size() == 0) {
            try {
                this.buffer.add(event);
            }
            catch (IllegalStateException e) {
                Event[] tempBuffer = this.buffer.toArray(new Event[this.buffer.size()]);
                this.buffer.remove(tempBuffer[tempBuffer.length - 1]);
                this.buffer.add(event);
            }
            return false;
        }
        return true;
    }

    private static class Event {
        EventType type;
        ByteBuffer message;
        Exception exception;

        Event(EventType type) {
            this.type = type;
        }

        Event(EventType type, Exception exception) {
            this(type);
            this.exception = exception;
        }

        Event(EventType type, ByteBuffer message) {
            this(type);
            this.message = message;
        }
    }

    private static enum EventType {
        CONNECTED,
        DISCONNECTED,
        MESSAGE_RECEIVED,
        DATA_EXCEPTION;

    }
}

