/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.app.slh;

import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.slh.ClientSLhSession;
import org.jdiameter.api.slh.ClientSLhSessionListener;
import org.jdiameter.api.slh.events.LCSRoutingInfoAnswer;
import org.jdiameter.api.slh.events.LCSRoutingInfoRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.slh.Event;
import org.jdiameter.client.impl.app.slh.IClientSLhSessionData;
import org.jdiameter.common.api.app.slh.ISLhMessageFactory;
import org.jdiameter.common.api.app.slh.SLhSessionState;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.slh.SLhSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLhClientSessionImpl
extends SLhSession
implements ClientSLhSession,
EventListener<Request, Answer>,
NetworkReqListener {
    private static final Logger logger = LoggerFactory.getLogger(SLhClientSessionImpl.class);
    private transient ClientSLhSessionListener listener;
    protected long appId = -1L;
    protected IClientSLhSessionData sessionData;

    public SLhClientSessionImpl(IClientSLhSessionData sessionData, ISLhMessageFactory fct, ISessionFactory sf, ClientSLhSessionListener lst) {
        super(sf, sessionData);
        if (lst == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        if (fct.getApplicationId() < 0L) {
            throw new IllegalArgumentException("ApplicationId can not be less than zero");
        }
        this.appId = fct.getApplicationId();
        this.listener = lst;
        this.messageFactory = fct;
        this.sessionData = sessionData;
    }

    public <E> E getState(Class<E> stateType) {
        return (E)((Object)(stateType == SLhSessionState.class ? this.sessionData.getSLhSessionState() : null));
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    public void sendLCSRoutingInfoRequest(LCSRoutingInfoRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, (AppEvent)request, null);
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery rd = new AnswerDelivery();
        rd.session = this;
        rd.request = request;
        rd.answer = answer;
        this.scheduler.execute(rd);
    }

    public void timeoutExpired(Request request) {
        try {
            this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, new AppRequestEventImpl((Message)request), null));
        }
        catch (Exception e) {
            logger.debug("Failed to process timeout message", (Throwable)e);
        }
    }

    protected void send(Event.Type type, AppEvent request, AppEvent answer) throws InternalException {
        try {
            if (type != null) {
                this.handleEvent(new Event(type, request, answer));
            }
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        try {
            this.sendAndStateLock.lock();
            if (!this.session.isValid()) {
                boolean bl = false;
                return bl;
            }
            SLhSessionState state = this.sessionData.getSLhSessionState();
            Event localEvent = (Event)event;
            Event.Type eventType = (Event.Type)event.getType();
            switch (state) {
                case IDLE: {
                    switch (eventType) {
                        case SEND_MESSAGE: {
                            SLhSessionState newState = SLhSessionState.MESSAGE_SENT_RECEIVED;
                            this.session.send(((AppEvent)event.getData()).getMessage(), (EventListener)this);
                            this.setState(newState);
                            return true;
                        }
                    }
                    logger.error("Invalid Event Type {} for SLh Client Session at state {}.", (Object)eventType, (Object)this.sessionData.getSLhSessionState());
                    return true;
                }
                case MESSAGE_SENT_RECEIVED: {
                    switch (eventType) {
                        case TIMEOUT_EXPIRES: {
                            SLhSessionState newState = SLhSessionState.TIMEDOUT;
                            this.setState(newState);
                            return true;
                        }
                        case SEND_MESSAGE: {
                            try {
                                this.session.send(((AppEvent)event.getData()).getMessage(), (EventListener)this);
                                return true;
                            }
                            finally {
                                SLhSessionState newState = SLhSessionState.TERMINATED;
                                this.setState(newState);
                            }
                        }
                        case RECEIVE_RIA: {
                            SLhSessionState newState = SLhSessionState.TERMINATED;
                            this.setState(newState);
                            this.listener.doLCSRoutingInfoAnswerEvent((ClientSLhSession)this, (LCSRoutingInfoRequest)localEvent.getRequest(), (LCSRoutingInfoAnswer)localEvent.getAnswer());
                            return true;
                        }
                    }
                    throw new InternalException("Unexpected/Unknown message received: " + event.getData());
                }
                case TERMINATED: {
                    throw new InternalException("Cant receive message in state TERMINATED. Command: " + event.getData());
                }
                case TIMEDOUT: {
                    throw new InternalException("Cant receive message in state TIMEDOUT. Command: " + event.getData());
                }
                default: {
                    logger.error("SLh Client FSM in wrong state: {}", (Object)state);
                    return true;
                }
            }
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    protected void setState(SLhSessionState newState) {
        SLhSessionState oldState = this.sessionData.getSLhSessionState();
        this.sessionData.setSLhSessionState(newState);
        for (StateChangeListener i : this.stateListeners) {
            i.stateChanged((Object)this, (Enum)oldState, (Enum)newState);
        }
        if (newState == SLhSessionState.TERMINATED || newState == SLhSessionState.TIMEDOUT) {
            super.cancelMsgTimer();
            this.release();
        }
    }

    @Override
    public void onTimer(String timerName) {
        if (timerName.equals("MSG_TIMEOUT")) {
            try {
                this.sendAndStateLock.lock();
                try {
                    this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, new AppRequestEventImpl((Message)this.sessionData.getBuffer()), null));
                }
                catch (Exception e) {
                    logger.debug("Failure handling Timeout event.");
                }
                this.sessionData.setBuffer(null);
                this.sessionData.setTsTimerId(null);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.appId ^ this.appId >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SLhClientSessionImpl other = (SLhClientSessionImpl)obj;
        return this.appId == other.appId;
    }

    @Override
    public void release() {
        if (this.isValid()) {
            try {
                this.sendAndStateLock.lock();
                super.release();
            }
            catch (Exception e) {
                logger.debug("Failed to release session", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        } else {
            logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }

    private class AnswerDelivery
    implements Runnable {
        ClientSLhSession session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        @Override
        public void run() {
            try {
                switch (this.answer.getCommandCode()) {
                    case 0x80000E: {
                        SLhClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_RIA, (AppEvent)SLhClientSessionImpl.this.messageFactory.createLCSRoutingInfoRequest(this.request), (AppEvent)SLhClientSessionImpl.this.messageFactory.createLCSRoutingInfoAnswer(this.answer)));
                        break;
                    }
                    default: {
                        SLhClientSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process success message", (Throwable)e);
            }
        }
    }

    private class RequestDelivery
    implements Runnable {
        ClientSLhSession session;
        Request request;

        private RequestDelivery() {
        }

        @Override
        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    default: 
                }
                SLhClientSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), null);
            }
            catch (Exception e) {
                logger.debug("Failed to process request message", (Throwable)e);
            }
        }
    }
}

