/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.app.slg;

import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.slg.ClientSLgSession;
import org.jdiameter.api.slg.ClientSLgSessionListener;
import org.jdiameter.api.slg.events.LocationReportAnswer;
import org.jdiameter.api.slg.events.LocationReportRequest;
import org.jdiameter.api.slg.events.ProvideLocationAnswer;
import org.jdiameter.api.slg.events.ProvideLocationRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.slg.Event;
import org.jdiameter.client.impl.app.slg.IClientSLgSessionData;
import org.jdiameter.common.api.app.slg.ISLgMessageFactory;
import org.jdiameter.common.api.app.slg.SLgSessionState;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.slg.SLgSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLgClientSessionImpl
extends SLgSession
implements ClientSLgSession,
EventListener<Request, Answer>,
NetworkReqListener {
    private static final Logger logger = LoggerFactory.getLogger(SLgClientSessionImpl.class);
    private transient ClientSLgSessionListener listener;
    protected long appId = -1L;
    protected IClientSLgSessionData sessionData;

    public SLgClientSessionImpl(IClientSLgSessionData sessionData, ISLgMessageFactory fct, ISessionFactory sf, ClientSLgSessionListener lst) {
        super(sf, sessionData);
        if (lst == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        if (fct.getApplicationId() < 0L) {
            throw new IllegalArgumentException("ApplicationId can not be less than zero");
        }
        this.appId = fct.getApplicationId();
        this.listener = lst;
        this.messageFactory = fct;
        this.sessionData = sessionData;
    }

    public <E> E getState(Class<E> stateType) {
        return (E)((Object)(stateType == SLgSessionState.class ? this.sessionData.getSLgSessionState() : null));
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    public void sendProvideLocationRequest(ProvideLocationRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, (AppEvent)request, null);
    }

    public void sendLocationReportAnswer(LocationReportAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, null, (AppEvent)answer);
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery rd = new AnswerDelivery();
        rd.session = this;
        rd.request = request;
        rd.answer = answer;
        this.scheduler.execute(rd);
    }

    public void timeoutExpired(Request request) {
        try {
            this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, new AppRequestEventImpl((Message)request), null));
        }
        catch (Exception e) {
            logger.debug("Failed to process timeout message", (Throwable)e);
        }
    }

    protected void send(Event.Type type, AppEvent request, AppEvent answer) throws InternalException {
        try {
            if (type != null) {
                this.handleEvent(new Event(type, request, answer));
            }
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        try {
            this.sendAndStateLock.lock();
            if (!this.session.isValid()) {
                boolean bl = false;
                return bl;
            }
            SLgSessionState state = this.sessionData.getSLgSessionState();
            Event localEvent = (Event)event;
            Event.Type eventType = (Event.Type)event.getType();
            switch (state) {
                case IDLE: {
                    switch (eventType) {
                        case SEND_MESSAGE: {
                            SLgSessionState newState = SLgSessionState.MESSAGE_SENT_RECEIVED;
                            this.session.send(((AppEvent)event.getData()).getMessage(), (EventListener)this);
                            this.setState(newState);
                            return true;
                        }
                        case RECEIVE_LRR: {
                            this.sessionData.setBuffer((Request)((AppEvent)event.getData()).getMessage());
                            super.cancelMsgTimer();
                            super.startMsgTimer();
                            SLgSessionState newState = SLgSessionState.MESSAGE_SENT_RECEIVED;
                            this.setState(newState);
                            this.listener.doLocationReportRequestEvent((ClientSLgSession)this, (LocationReportRequest)event.getData());
                            return true;
                        }
                    }
                    logger.error("Invalid Event Type {} for SLg Client Session at state {}.", (Object)eventType, (Object)this.sessionData.getSLgSessionState());
                    return true;
                }
                case MESSAGE_SENT_RECEIVED: {
                    switch (eventType) {
                        case TIMEOUT_EXPIRES: {
                            SLgSessionState newState = SLgSessionState.TIMEDOUT;
                            this.setState(newState);
                            return true;
                        }
                        case SEND_MESSAGE: {
                            try {
                                this.session.send(((AppEvent)event.getData()).getMessage(), (EventListener)this);
                                return true;
                            }
                            finally {
                                SLgSessionState newState = SLgSessionState.TERMINATED;
                                this.setState(newState);
                            }
                        }
                        case RECEIVE_PLA: {
                            SLgSessionState newState = SLgSessionState.TERMINATED;
                            this.setState(newState);
                            this.listener.doProvideLocationAnswerEvent((ClientSLgSession)this, (ProvideLocationRequest)localEvent.getRequest(), (ProvideLocationAnswer)localEvent.getAnswer());
                            return true;
                        }
                    }
                    throw new InternalException("Unexpected/Unknown message received: " + event.getData());
                }
                case TERMINATED: {
                    throw new InternalException("Cant receive message in state TERMINATED. Command: " + event.getData());
                }
                case TIMEDOUT: {
                    throw new InternalException("Cant receive message in state TIMEDOUT. Command: " + event.getData());
                }
                default: {
                    logger.error("SLg Client FSM in wrong state: {}", (Object)state);
                    return true;
                }
            }
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    protected void setState(SLgSessionState newState) {
        SLgSessionState oldState = this.sessionData.getSLgSessionState();
        this.sessionData.setSLgSessionState(newState);
        for (StateChangeListener i : this.stateListeners) {
            i.stateChanged((Object)this, (Enum)oldState, (Enum)newState);
        }
        if (newState == SLgSessionState.TERMINATED || newState == SLgSessionState.TIMEDOUT) {
            super.cancelMsgTimer();
            this.release();
        }
    }

    @Override
    public void onTimer(String timerName) {
        if (timerName.equals("MSG_TIMEOUT")) {
            try {
                this.sendAndStateLock.lock();
                try {
                    this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, new AppRequestEventImpl((Message)this.sessionData.getBuffer()), null));
                }
                catch (Exception e) {
                    logger.debug("Failure handling Timeout event.");
                }
                this.sessionData.setBuffer(null);
                this.sessionData.setTsTimerId(null);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.appId ^ this.appId >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SLgClientSessionImpl other = (SLgClientSessionImpl)obj;
        return this.appId == other.appId;
    }

    @Override
    public void release() {
        if (this.isValid()) {
            try {
                this.sendAndStateLock.lock();
                super.release();
            }
            catch (Exception e) {
                logger.debug("Failed to release session", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        } else {
            logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }

    private class AnswerDelivery
    implements Runnable {
        ClientSLgSession session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        @Override
        public void run() {
            try {
                switch (this.answer.getCommandCode()) {
                    case 0x80000C: {
                        SLgClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_PLA, (AppEvent)SLgClientSessionImpl.this.messageFactory.createProvideLocationRequest(this.request), (AppEvent)SLgClientSessionImpl.this.messageFactory.createProvideLocationAnswer(this.answer)));
                        break;
                    }
                    default: {
                        SLgClientSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process success message", (Throwable)e);
            }
        }
    }

    private class RequestDelivery
    implements Runnable {
        ClientSLgSession session;
        Request request;

        private RequestDelivery() {
        }

        @Override
        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    case 0x80000D: {
                        SLgClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_LRR, (AppEvent)SLgClientSessionImpl.this.messageFactory.createLocationReportRequest(this.request), null));
                        break;
                    }
                    default: {
                        SLgClientSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), null);
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process request message", (Throwable)e);
            }
        }
    }
}

