/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.app.rx;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.Answer;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.rx.ClientRxSession;
import org.jdiameter.api.rx.ClientRxSessionListener;
import org.jdiameter.api.rx.events.RxAAAnswer;
import org.jdiameter.api.rx.events.RxAARequest;
import org.jdiameter.api.rx.events.RxAbortSessionAnswer;
import org.jdiameter.api.rx.events.RxAbortSessionRequest;
import org.jdiameter.api.rx.events.RxReAuthAnswer;
import org.jdiameter.api.rx.events.RxReAuthRequest;
import org.jdiameter.api.rx.events.RxSessionTermAnswer;
import org.jdiameter.api.rx.events.RxSessionTermRequest;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.api.parser.ParseException;
import org.jdiameter.client.impl.app.rx.Event;
import org.jdiameter.client.impl.app.rx.IClientRxSessionData;
import org.jdiameter.common.api.app.rx.ClientRxSessionState;
import org.jdiameter.common.api.app.rx.IClientRxSessionContext;
import org.jdiameter.common.api.app.rx.IRxMessageFactory;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.rx.AppRxSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRxSessionImpl
extends AppRxSessionImpl
implements ClientRxSession,
NetworkReqListener,
EventListener<Request, Answer> {
    private static final Logger logger = LoggerFactory.getLogger(ClientRxSessionImpl.class);
    protected Lock sendAndStateLock = new ReentrantLock();
    protected transient IRxMessageFactory factory;
    protected transient ClientRxSessionListener listener;
    protected transient IClientRxSessionContext context;
    protected transient IMessageParser parser;
    protected IClientRxSessionData sessionData;
    protected long[] authAppIds = new long[]{4L};
    static final int NON_INITIALIZED = -300;
    protected boolean isEventBased = false;
    protected byte[] buffer;
    protected String originHost;
    protected String originRealm;
    private static final long INVALID_SERVICE_INFORMATION = 5061L;
    private static final long FILTER_RESTRICTIONS = 5062L;
    private static final long REQUESTED_SERVICE_NOT_AUTHORIZED = 5063L;
    private static final long DUPLICATED_AF_SESSION = 5064L;
    private static final long IP_CAN_SESSION_NOT_AVAILABLE = 5065L;
    private static final long UNAUTHORIZED_NON_EMERGENCY_SESSION = 5066L;
    private static final long UNAUTHORIZED_SPONSORED_DATA_CONNECTIVITY = 5067L;
    private static final long DIAMETER_UNABLE_TO_DELIVER = 3002L;
    private static final long DIAMETER_TOO_BUSY = 3004L;
    private static final long DIAMETER_LOOP_DETECTED = 3005L;
    protected static final Set<Long> temporaryErrorCodes;
    protected ArrayList<Event> eventQueue = new ArrayList();

    public ClientRxSessionImpl(IClientRxSessionData sessionData, IRxMessageFactory fct, ISessionFactory sf, ClientRxSessionListener lst, IClientRxSessionContext ctx, StateChangeListener<AppSession> stLst) {
        super(sf, sessionData);
        if (lst == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        if (fct.getApplicationIds() == null) {
            throw new IllegalArgumentException("ApplicationId can not be less than zero");
        }
        this.context = ctx;
        this.authAppIds = fct.getApplicationIds();
        this.listener = lst;
        this.factory = fct;
        IContainer icontainer = sf.getContainer();
        this.parser = icontainer.getAssemblerFacility().getComponentInstance(IMessageParser.class);
        this.sessionData = sessionData;
        super.addStateChangeNotification(stLst);
    }

    public void sendAARequest(RxAARequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        try {
            this.handleEvent(new Event(true, (AppRequestEvent)request, null));
        }
        catch (AvpDataException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public void sendSessionTermRequest(RxSessionTermRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        try {
            this.handleEvent(new Event(true, (AppRequestEvent)request, null));
        }
        catch (AvpDataException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public void sendReAuthAnswer(RxReAuthAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.handleEvent(new Event(Event.Type.SEND_RAA, null, (AppAnswerEvent)answer));
    }

    public void sendAbortSessionAnswer(RxAbortSessionAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.handleEvent(new Event(Event.Type.SEND_ASA, null, (AppAnswerEvent)answer));
    }

    public boolean isStateless() {
        return false;
    }

    public boolean isEventBased() {
        return this.isEventBased;
    }

    public <E> E getState(Class<E> stateType) {
        return (E)(stateType == ClientRxSessionState.class ? this.sessionData.getClientRxSessionState() : null);
    }

    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        return this.isEventBased() ? this.handleEventForEventBased(event) : this.handleEventForSessionBased(event);
    }

    protected boolean handleEventForEventBased(StateEvent event) throws InternalException, OverloadException {
        try {
            this.sendAndStateLock.lock();
            ClientRxSessionState state = this.sessionData.getClientRxSessionState();
            Event localEvent = (Event)event;
            Event.Type eventType = (Event.Type)localEvent.getType();
            block4 : switch (state) {
                case IDLE: {
                    switch (eventType) {
                        case SEND_EVENT_REQUEST: {
                            this.setState(ClientRxSessionState.PENDING_EVENT);
                            try {
                                this.dispatchEvent(localEvent.getRequest());
                            }
                            catch (Exception e) {
                                logger.debug("Failure handling send event request", (Throwable)e);
                                this.handleSendFailure(e, eventType, localEvent.getRequest().getMessage());
                            }
                            break block4;
                        }
                    }
                    logger.warn("Event Based Handling - Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    break;
                }
                case PENDING_EVENT: {
                    switch (eventType) {
                        case RECEIVE_EVENT_ANSWER: {
                            AppAnswerEvent answer = (AppAnswerEvent)localEvent.getAnswer();
                            try {
                                long resultCode = answer.getResultCodeAvp().getUnsigned32();
                                if (this.isSuccess(resultCode)) {
                                    this.setState(ClientRxSessionState.IDLE, false);
                                }
                                if (this.isProvisional(resultCode) || this.isFailure(resultCode)) {
                                    this.handleFailureMessage(answer, (AppRequestEvent)localEvent.getRequest(), eventType);
                                }
                                this.deliverRxAAAnswer((RxAARequest)localEvent.getRequest(), (RxAAAnswer)localEvent.getAnswer());
                            }
                            catch (AvpDataException e) {
                                logger.debug("Failure handling received answer event", (Throwable)e);
                                this.setState(ClientRxSessionState.IDLE, false);
                            }
                            break block4;
                        }
                    }
                    logger.warn("Event Based Handling - Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    break;
                }
                case PENDING_BUFFERED: {
                    switch (eventType) {
                        case RECEIVE_EVENT_ANSWER: {
                            this.setState(ClientRxSessionState.IDLE, false);
                            this.buffer = null;
                            this.deliverRxAAAnswer((RxAARequest)localEvent.getRequest(), (RxAAAnswer)localEvent.getAnswer());
                            break block4;
                        }
                    }
                    logger.warn("Event Based Handling - Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    break;
                }
                default: {
                    logger.warn("Event Based Handling - Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                }
            }
            this.dispatch();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    protected boolean handleEventForSessionBased(StateEvent event) throws InternalException, OverloadException {
        try {
            this.sendAndStateLock.lock();
            ClientRxSessionState state = this.sessionData.getClientRxSessionState();
            Event localEvent = (Event)event;
            Event.Type eventType = (Event.Type)localEvent.getType();
            block10 : switch (state) {
                case IDLE: {
                    switch (eventType) {
                        case SEND_AAR: {
                            this.setState(ClientRxSessionState.PENDING_AAR);
                            try {
                                this.dispatchEvent(localEvent.getRequest());
                            }
                            catch (Exception e) {
                                this.handleSendFailure(e, eventType, localEvent.getRequest().getMessage());
                            }
                            break block10;
                        }
                    }
                    logger.warn("Session Based Handling - Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    break;
                }
                case PENDING_AAR: {
                    AppAnswerEvent answer = (AppAnswerEvent)localEvent.getAnswer();
                    switch (eventType) {
                        case RECEIVE_AAA: {
                            long resultCode = answer.getResultCodeAvp().getUnsigned32();
                            if (this.isSuccess(resultCode)) {
                                this.setState(ClientRxSessionState.OPEN);
                            } else if (this.isProvisional(resultCode) || this.isFailure(resultCode)) {
                                this.handleFailureMessage(answer, (AppRequestEvent)localEvent.getRequest(), eventType);
                            }
                            this.deliverRxAAAnswer((RxAARequest)localEvent.getRequest(), (RxAAAnswer)localEvent.getAnswer());
                            break block10;
                        }
                        case SEND_AAR: 
                        case SEND_STR: {
                            this.eventQueue.add(localEvent);
                            break block10;
                        }
                        case RECEIVE_RAR: {
                            this.deliverReAuthRequest((RxReAuthRequest)localEvent.getRequest());
                            break block10;
                        }
                        case SEND_RAA: {
                            try {
                                this.dispatchEvent(localEvent.getAnswer());
                            }
                            catch (Exception e) {
                                this.handleSendFailure(e, eventType, localEvent.getRequest().getMessage());
                            }
                            break block10;
                        }
                        case RECEIVE_ASR: {
                            this.deliverAbortSessionRequest((RxAbortSessionRequest)localEvent.getRequest());
                            break block10;
                        }
                        case SEND_ASA: {
                            try {
                                this.dispatchEvent(localEvent.getAnswer());
                            }
                            catch (Exception e) {
                                this.handleSendFailure(e, eventType, localEvent.getRequest().getMessage());
                            }
                            break block10;
                        }
                    }
                    logger.warn("Session Based Handling - Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    break;
                }
                case PENDING_STR: {
                    AppAnswerEvent stanswer = (AppAnswerEvent)localEvent.getAnswer();
                    switch (eventType) {
                        case RECEIVE_STA: {
                            long resultCode = stanswer.getResultCodeAvp().getUnsigned32();
                            if (this.isSuccess(resultCode)) {
                                this.setState(ClientRxSessionState.IDLE, false);
                            } else if (this.isProvisional(resultCode) || this.isFailure(resultCode)) {
                                this.handleFailureMessage(stanswer, (AppRequestEvent)localEvent.getRequest(), eventType);
                            }
                            this.deliverRxSessionTermAnswer((RxSessionTermRequest)localEvent.getRequest(), (RxSessionTermAnswer)localEvent.getAnswer());
                            break block10;
                        }
                        case SEND_AAR: {
                            try {
                                this.dispatchEvent(localEvent.getRequest());
                            }
                            catch (Exception exception) {}
                            break block10;
                        }
                    }
                    logger.warn("Session Based Handling - Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    break;
                }
                case OPEN: {
                    switch (eventType) {
                        case SEND_AAR: {
                            this.setState(ClientRxSessionState.PENDING_AAR);
                            try {
                                this.dispatchEvent(localEvent.getRequest());
                            }
                            catch (Exception e) {
                                this.handleSendFailure(e, eventType, localEvent.getRequest().getMessage());
                            }
                            break block10;
                        }
                        case SEND_STR: {
                            this.setState(ClientRxSessionState.PENDING_STR);
                            try {
                                this.dispatchEvent(localEvent.getRequest());
                            }
                            catch (Exception e) {
                                this.handleSendFailure(e, eventType, localEvent.getRequest().getMessage());
                            }
                            break block10;
                        }
                        case RECEIVE_RAR: {
                            this.deliverReAuthRequest((RxReAuthRequest)localEvent.getRequest());
                            break block10;
                        }
                        case SEND_RAA: {
                            try {
                                this.dispatchEvent(localEvent.getAnswer());
                            }
                            catch (Exception e) {
                                this.handleSendFailure(e, eventType, localEvent.getRequest().getMessage());
                            }
                            break block10;
                        }
                        case RECEIVE_ASR: {
                            this.deliverAbortSessionRequest((RxAbortSessionRequest)localEvent.getRequest());
                            break block10;
                        }
                        case SEND_ASA: {
                            try {
                                this.dispatchEvent(localEvent.getAnswer());
                            }
                            catch (Exception e) {
                                this.handleSendFailure(e, eventType, localEvent.getRequest().getMessage());
                            }
                            break block10;
                        }
                    }
                    logger.warn("Session Based Handling - Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    break;
                }
                default: {
                    this.setState(ClientRxSessionState.IDLE, true);
                }
            }
            this.dispatch();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery ad = new AnswerDelivery();
        ad.session = this;
        ad.request = request;
        ad.answer = answer;
        this.scheduler.execute(ad);
    }

    public void timeoutExpired(Request request) {
    }

    protected void setState(ClientRxSessionState newState) {
        this.setState(newState, true);
    }

    protected void setState(ClientRxSessionState newState, boolean release) {
        block4: {
            try {
                ClientRxSessionState oldState = this.sessionData.getClientRxSessionState();
                this.sessionData.setClientRxSessionState(newState);
                for (StateChangeListener i : this.stateListeners) {
                    i.stateChanged((Object)this, (Enum)oldState, (Enum)newState);
                }
                if (newState == ClientRxSessionState.IDLE && release) {
                    this.release();
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug("Failure switching to state " + this.sessionData.getClientRxSessionState() + " (release=" + release + ")", (Throwable)e);
            }
        }
    }

    @Override
    public void release() {
        if (this.isValid()) {
            try {
                this.sendAndStateLock.lock();
                super.release();
            }
            catch (Exception e) {
                logger.debug("Failed to release session", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        } else {
            logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }

    protected void handleSendFailure(Exception e, Event.Type eventType, Message request) throws Exception {
        logger.debug("Failed to send message, type: {} message: {}, failure: {}", new Object[]{eventType, request, e != null ? e.getLocalizedMessage() : ""});
    }

    protected void handleFailureMessage(AppAnswerEvent event, AppRequestEvent request, Event.Type eventType) {
        block2: {
            try {
                this.setState(ClientRxSessionState.IDLE);
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Failure handling failure message for Event " + event + " (" + (Object)((Object)eventType) + ") and Request " + request, (Throwable)e);
            }
        }
    }

    protected void dispatch() {
        if (this.isEventBased()) {
            if (this.buffer != null) {
                this.setState(ClientRxSessionState.PENDING_BUFFERED);
                try {
                    this.dispatchEvent(new AppRequestEventImpl(this.messageFromBuffer(ByteBuffer.wrap(this.buffer))));
                }
                catch (Exception e) {
                    try {
                        this.handleSendFailure(e, Event.Type.SEND_EVENT_REQUEST, this.messageFromBuffer(ByteBuffer.wrap(this.buffer)));
                    }
                    catch (Exception e1) {
                        logger.error("Failure handling buffer send failure", (Throwable)e1);
                    }
                }
            }
        } else if (this.sessionData.getClientRxSessionState() == ClientRxSessionState.OPEN && this.eventQueue.size() > 0) {
            try {
                this.handleEvent(this.eventQueue.remove(0));
            }
            catch (Exception e) {
                logger.error("Failure handling queued event", (Throwable)e);
            }
        }
    }

    protected void deliverRxAAAnswer(RxAARequest request, RxAAAnswer answer) {
        try {
            this.listener.doAAAnswer((ClientRxSession)this, request, answer);
        }
        catch (Exception e) {
            logger.warn("Failure delivering AAA", (Throwable)e);
        }
    }

    protected void deliverRxSessionTermAnswer(RxSessionTermRequest request, RxSessionTermAnswer answer) {
        try {
            this.listener.doSessionTermAnswer((ClientRxSession)this, request, answer);
        }
        catch (Exception e) {
            logger.warn("Failure delivering STA", (Throwable)e);
        }
    }

    protected void deliverReAuthRequest(RxReAuthRequest request) {
        try {
            this.listener.doReAuthRequest((ClientRxSession)this, request);
        }
        catch (Exception e) {
            logger.debug("Failure delivering RAR", (Throwable)e);
        }
    }

    protected void deliverAbortSessionRequest(RxAbortSessionRequest request) {
        try {
            this.listener.doAbortSessionRequest((ClientRxSession)this, request);
        }
        catch (Exception e) {
            logger.debug("Failure delivering RAR", (Throwable)e);
        }
    }

    protected void dispatchEvent(AppEvent event) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.session.send(event.getMessage(), (EventListener)this);
    }

    protected boolean isProvisional(long resultCode) {
        return resultCode >= 1000L && resultCode < 2000L;
    }

    protected boolean isSuccess(long resultCode) {
        return resultCode >= 2000L && resultCode < 3000L;
    }

    protected boolean isFailure(long code) {
        return !this.isProvisional(code) && !this.isSuccess(code) && code >= 3000L && code < 6000L && !temporaryErrorCodes.contains(code);
    }

    @Override
    public boolean isReplicable() {
        return true;
    }

    private Message messageFromBuffer(ByteBuffer request) throws InternalException {
        if (request != null) {
            try {
                IMessage m = this.parser.createMessage(request);
                return m;
            }
            catch (AvpDataException e) {
                throw new InternalException("Failed to decode message.", (Throwable)e);
            }
        }
        return null;
    }

    private ByteBuffer messageToBuffer(IMessage msg) throws InternalException {
        try {
            return this.parser.encodeMessage(msg);
        }
        catch (ParseException e) {
            throw new InternalException("Failed to encode message.", (Throwable)e);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.authAppIds);
        result = 31 * result + (this.isEventBased ? 1231 : 1237);
        result = 31 * result + (this.originHost == null ? 0 : this.originHost.hashCode());
        result = 31 * result + (this.originRealm == null ? 0 : this.originRealm.hashCode());
        result = 31 * result + (this.sessionData == null ? 0 : (this.sessionData.getClientRxSessionState() == null ? 0 : this.sessionData.getClientRxSessionState().hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientRxSessionImpl other = (ClientRxSessionImpl)obj;
        if (!Arrays.equals(this.authAppIds, other.authAppIds)) {
            return false;
        }
        if (this.isEventBased != other.isEventBased) {
            return false;
        }
        if (this.originHost == null ? other.originHost != null : !this.originHost.equals(other.originHost)) {
            return false;
        }
        if (this.originRealm == null ? other.originRealm != null : !this.originRealm.equals(other.originRealm)) {
            return false;
        }
        return !(this.sessionData == null ? other.sessionData != null : (this.sessionData.getClientRxSessionState() == null ? other.sessionData.getClientRxSessionState() != null : !this.sessionData.getClientRxSessionState().equals(other.sessionData.getClientRxSessionState())));
    }

    @Override
    public void onTimer(String timerName) {
        if (timerName.equals("IDLE_SESSION_TIMER")) {
            this.checkIdleAppSession();
        } else {
            logger.warn("Received an unknown timer '{}' for Session-ID '{}'", (Object)timerName, (Object)this.getSessionId());
        }
    }

    static {
        HashSet<Long> tmp = new HashSet<Long>();
        tmp.add(3002L);
        tmp.add(3004L);
        tmp.add(3005L);
        temporaryErrorCodes = Collections.unmodifiableSet(tmp);
    }

    private class AnswerDelivery
    implements Runnable {
        ClientRxSession session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        @Override
        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    case 265: {
                        RxAARequest myAARequest = ClientRxSessionImpl.this.factory.createAARequest(this.request);
                        RxAAAnswer myAAAnswer = ClientRxSessionImpl.this.factory.createAAAnswer(this.answer);
                        ClientRxSessionImpl.this.handleEvent(new Event(false, (AppRequestEvent)myAARequest, (AppAnswerEvent)myAAAnswer));
                        break;
                    }
                    case 275: {
                        RxSessionTermRequest mySTRequest = ClientRxSessionImpl.this.factory.createSessionTermRequest(this.request);
                        RxSessionTermAnswer mySTAnswer = ClientRxSessionImpl.this.factory.createSessionTermAnswer(this.answer);
                        ClientRxSessionImpl.this.handleEvent(new Event(false, (AppRequestEvent)mySTRequest, (AppAnswerEvent)mySTAnswer));
                        break;
                    }
                    default: {
                        ClientRxSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failure processing success message", (Throwable)e);
            }
        }
    }

    private class RequestDelivery
    implements Runnable {
        ClientRxSession session;
        Request request;

        private RequestDelivery() {
        }

        @Override
        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    case 258: {
                        ClientRxSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_RAR, (AppRequestEvent)ClientRxSessionImpl.this.factory.createReAuthRequest(this.request), null));
                        break;
                    }
                    case 274: {
                        ClientRxSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_ASR, (AppRequestEvent)ClientRxSessionImpl.this.factory.createAbortSessionRequest(this.request), null));
                        break;
                    }
                    default: {
                        ClientRxSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), null);
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failure processing request", (Throwable)e);
            }
        }
    }
}

