/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.app.ro;

import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.ro.events.RoCreditControlAnswer;
import org.jdiameter.api.ro.events.RoCreditControlRequest;

public class Event
implements StateEvent {
    Type type;
    AppRequestEvent request;
    AppAnswerEvent answer;

    Event(Type type) {
        this.type = type;
    }

    Event(Type type, AppRequestEvent request, AppAnswerEvent answer) {
        this.type = type;
        this.answer = answer;
        this.request = request;
    }

    Event(boolean isRequest, RoCreditControlRequest request, RoCreditControlAnswer answer) throws AvpDataException {
        block13: {
            block12: {
                this.answer = answer;
                this.request = request;
                if (!isRequest) break block12;
                switch (request.getRequestTypeAVPValue()) {
                    case 1: {
                        this.type = Type.SEND_INITIAL_REQUEST;
                        break block13;
                    }
                    case 2: {
                        this.type = Type.SEND_UPDATE_REQUEST;
                        break block13;
                    }
                    case 3: {
                        this.type = Type.SEND_TERMINATE_REQUEST;
                        break block13;
                    }
                    case 4: {
                        this.type = Type.SEND_EVENT_REQUEST;
                        break block13;
                    }
                    default: {
                        throw new RuntimeException("Wrong CC-Request-Type value: " + request.getRequestTypeAVPValue());
                    }
                }
            }
            switch (answer.getRequestTypeAVPValue()) {
                case 1: {
                    this.type = Type.RECEIVED_INITIAL_ANSWER;
                    break;
                }
                case 2: {
                    this.type = Type.RECEIVED_UPDATE_ANSWER;
                    break;
                }
                case 3: {
                    this.type = Type.RECEIVED_TERMINATED_ANSWER;
                    break;
                }
                case 4: {
                    this.type = Type.RECEIVE_EVENT_ANSWER;
                    break;
                }
                default: {
                    throw new RuntimeException("Wrong CC-Request-Type value: " + answer.getRequestTypeAVPValue());
                }
            }
        }
    }

    public Enum getType() {
        return this.type;
    }

    public int compareTo(Object o) {
        return 0;
    }

    public Object getData() {
        return this.request != null ? this.request : this.answer;
    }

    public void setData(Object data) {
    }

    public AppEvent getRequest() {
        return this.request;
    }

    public AppEvent getAnswer() {
        return this.answer;
    }

    public <E> E encodeType(Class<E> eClass) {
        return (E)((Object)(eClass == Type.class ? this.type : null));
    }

    public static enum Type {
        SEND_INITIAL_REQUEST,
        RECEIVED_INITIAL_ANSWER,
        SEND_UPDATE_REQUEST,
        RECEIVED_UPDATE_ANSWER,
        SEND_TERMINATE_REQUEST,
        RECEIVED_TERMINATED_ANSWER,
        RECEIVED_RAR,
        SEND_RAA,
        Tx_TIMER_FIRED,
        SEND_EVENT_REQUEST,
        RECEIVE_EVENT_ANSWER;

    }
}

