/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.app.rx;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.Answer;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.rx.ServerRxSession;
import org.jdiameter.api.rx.ServerRxSessionListener;
import org.jdiameter.api.rx.events.RxAAAnswer;
import org.jdiameter.api.rx.events.RxAARequest;
import org.jdiameter.api.rx.events.RxAbortSessionAnswer;
import org.jdiameter.api.rx.events.RxAbortSessionRequest;
import org.jdiameter.api.rx.events.RxReAuthAnswer;
import org.jdiameter.api.rx.events.RxReAuthRequest;
import org.jdiameter.api.rx.events.RxSessionTermAnswer;
import org.jdiameter.api.rx.events.RxSessionTermRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.rx.IRxMessageFactory;
import org.jdiameter.common.api.app.rx.IServerRxSessionContext;
import org.jdiameter.common.api.app.rx.ServerRxSessionState;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.rx.AppRxSessionImpl;
import org.jdiameter.server.impl.app.rx.Event;
import org.jdiameter.server.impl.app.rx.IServerRxSessionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerRxSessionImpl
extends AppRxSessionImpl
implements ServerRxSession,
NetworkReqListener,
EventListener<Request, Answer> {
    private static final Logger logger = LoggerFactory.getLogger(ServerRxSessionImpl.class);
    protected Lock sendAndStateLock = new ReentrantLock();
    protected transient IRxMessageFactory factory = null;
    protected transient IServerRxSessionContext context = null;
    protected transient ServerRxSessionListener listener = null;
    protected long[] authAppIds = new long[]{4L};
    protected IServerRxSessionData sessionData;

    public ServerRxSessionImpl(IServerRxSessionData sessionData, IRxMessageFactory fct, ISessionFactory sf, ServerRxSessionListener lst, IServerRxSessionContext ctx, StateChangeListener<AppSession> stLst) {
        super(sf, sessionData);
        if (lst == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        if (fct.getApplicationIds() == null) {
            throw new IllegalArgumentException("ApplicationId can not be less than zero");
        }
        this.context = ctx;
        this.authAppIds = fct.getApplicationIds();
        this.listener = lst;
        this.factory = fct;
        this.sessionData = sessionData;
        super.addStateChangeNotification(stLst);
    }

    public void sendAAAnswer(RxAAAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.handleEvent(new Event(false, null, (AppAnswerEvent)answer));
    }

    public void sendSessionTermAnswer(RxSessionTermAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.handleEvent(new Event(false, null, (AppAnswerEvent)answer));
    }

    public void sendReAuthRequest(RxReAuthRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_RAR, (AppRequestEvent)request, null);
    }

    public void sendAbortSessionRequest(RxAbortSessionRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_ASR, (AppRequestEvent)request, null);
    }

    public boolean isStateless() {
        return this.sessionData.isStateless();
    }

    public <E> E getState(Class<E> stateType) {
        return (E)(stateType == ServerRxSessionState.class ? this.sessionData.getServerRxSessionState() : null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        ServerRxSessionState newState = null;
        try {
            this.sendAndStateLock.lock();
            Event localEvent = (Event)event;
            ServerRxSessionState state = this.sessionData.getServerRxSessionState();
            Event.Type eventType = (Event.Type)localEvent.getType();
            block6 : switch (state) {
                case IDLE: {
                    RxAAAnswer answer;
                    switch (eventType) {
                        case RECEIVE_AAR: {
                            this.listener.doAARequest((ServerRxSession)this, (RxAARequest)localEvent.getRequest());
                            break block6;
                        }
                        case RECEIVE_EVENT_REQUEST: {
                            this.listener.doAARequest((ServerRxSession)this, (RxAARequest)localEvent.getRequest());
                            break block6;
                        }
                        case SEND_AAA: {
                            answer = (RxAAAnswer)localEvent.getAnswer();
                            try {
                                long resultCode = answer.getResultCodeAvp().getUnsigned32();
                                newState = this.isSuccess(resultCode) ? ServerRxSessionState.OPEN : ServerRxSessionState.IDLE;
                                this.dispatchEvent(localEvent.getAnswer());
                                break block6;
                            }
                            catch (AvpDataException e) {
                                throw new InternalException((Throwable)e);
                            }
                        }
                    }
                    throw new InternalException("Wrong state: " + ServerRxSessionState.IDLE + " one event: " + (Object)((Object)eventType) + " " + localEvent.getRequest() + " " + localEvent.getAnswer());
                }
                case OPEN: {
                    RxAAAnswer answer;
                    switch (eventType) {
                        case RECEIVE_AAR: {
                            this.listener.doAARequest((ServerRxSession)this, (RxAARequest)localEvent.getRequest());
                            break;
                        }
                        case SEND_AAA: {
                            answer = (RxAAAnswer)localEvent.getAnswer();
                            try {
                                if (!this.isSuccess(answer.getResultCodeAvp().getUnsigned32())) {
                                    // empty if block
                                }
                            }
                            catch (AvpDataException e) {
                                throw new InternalException((Throwable)e);
                            }
                            this.dispatchEvent(localEvent.getAnswer());
                            break;
                        }
                        case RECEIVE_STR: {
                            this.listener.doSessionTermRequest((ServerRxSession)this, (RxSessionTermRequest)localEvent.getRequest());
                            break;
                        }
                        case SEND_STA: {
                            RxSessionTermAnswer STA = (RxSessionTermAnswer)localEvent.getAnswer();
                            try {
                                try {
                                    if (this.isSuccess(STA.getResultCodeAvp().getUnsigned32())) {
                                        // empty if block
                                    }
                                    newState = ServerRxSessionState.IDLE;
                                }
                                catch (AvpDataException e) {
                                    throw new InternalException((Throwable)e);
                                }
                            }
                            catch (Throwable throwable) {
                                newState = ServerRxSessionState.IDLE;
                                throw throwable;
                            }
                            this.dispatchEvent(localEvent.getAnswer());
                            break;
                        }
                        case RECEIVE_RAA: {
                            this.listener.doReAuthAnswer((ServerRxSession)this, (RxReAuthRequest)localEvent.getRequest(), (RxReAuthAnswer)localEvent.getAnswer());
                            break;
                        }
                        case SEND_RAR: {
                            this.dispatchEvent(localEvent.getRequest());
                            break;
                        }
                        case RECEIVE_ASA: {
                            this.listener.doAbortSessionAnswer((ServerRxSession)this, (RxAbortSessionRequest)localEvent.getRequest(), (RxAbortSessionAnswer)localEvent.getAnswer());
                            break;
                        }
                        case SEND_ASR: {
                            this.dispatchEvent(localEvent.getRequest());
                        }
                    }
                    break;
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            if (newState != null) {
                this.setState(newState);
            }
            this.sendAndStateLock.unlock();
        }
    }

    @Override
    public boolean isReplicable() {
        return true;
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery rd = new AnswerDelivery();
        rd.session = this;
        rd.request = request;
        rd.answer = answer;
        this.scheduler.execute(rd);
    }

    @Override
    public void onTimer(String timerName) {
    }

    public void timeoutExpired(Request request) {
    }

    protected boolean isProvisional(long resultCode) {
        return resultCode >= 1000L && resultCode < 2000L;
    }

    protected boolean isSuccess(long resultCode) {
        return resultCode >= 2000L && resultCode < 3000L;
    }

    protected void setState(ServerRxSessionState newState) {
        this.setState(newState, true);
    }

    protected void setState(ServerRxSessionState newState, boolean release) {
        ServerRxSessionState oldState = this.sessionData.getServerRxSessionState();
        this.sessionData.setServerRxSessionState(newState);
        for (StateChangeListener i : this.stateListeners) {
            i.stateChanged((Object)this, (Enum)oldState, (Enum)newState);
        }
        if (newState == ServerRxSessionState.IDLE && release) {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.isValid()) {
            try {
                this.sendAndStateLock.lock();
                super.release();
            }
            catch (Exception e) {
                logger.debug("Failed to release session", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        } else {
            logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }

    protected void send(Event.Type type, AppRequestEvent request, AppAnswerEvent answer) throws InternalException {
        try {
            this.sendAndStateLock.lock();
            if (type != null) {
                this.handleEvent(new Event(type, request, answer));
            }
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    protected void dispatchEvent(AppEvent event) throws InternalException {
        try {
            this.session.send(event.getMessage(), (EventListener)this);
        }
        catch (Exception e) {
            logger.debug("Failure trying to dispatch event", (Throwable)e);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.sessionData == null ? 0 : this.sessionData.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerRxSessionImpl other = (ServerRxSessionImpl)obj;
        return !(this.sessionData == null ? other.sessionData != null : !this.sessionData.equals(other.sessionData));
    }

    private class AnswerDelivery
    implements Runnable {
        ServerRxSession session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    case 258: {
                        ServerRxSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_RAA, (AppRequestEvent)ServerRxSessionImpl.this.factory.createReAuthRequest(this.request), (AppAnswerEvent)ServerRxSessionImpl.this.factory.createReAuthAnswer(this.answer)));
                        break;
                    }
                    case 274: {
                        ServerRxSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_ASA, (AppRequestEvent)ServerRxSessionImpl.this.factory.createAbortSessionRequest(this.request), (AppAnswerEvent)ServerRxSessionImpl.this.factory.createAbortSessionAnswer(this.answer)));
                        break;
                    }
                    default: {
                        ServerRxSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process success message", (Throwable)e);
            }
        }
    }

    private class RequestDelivery
    implements Runnable {
        ServerRxSession session;
        Request request;

        private RequestDelivery() {
        }

        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    case 265: {
                        ServerRxSessionImpl.this.handleEvent(new Event(true, (AppRequestEvent)ServerRxSessionImpl.this.factory.createAARequest(this.request), null));
                        break;
                    }
                    case 275: {
                        ServerRxSessionImpl.this.handleEvent(new Event(true, (AppRequestEvent)ServerRxSessionImpl.this.factory.createSessionTermRequest(this.request), null));
                        break;
                    }
                    default: {
                        ServerRxSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), null);
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process request message", (Throwable)e);
            }
        }
    }
}

