/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.timer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.jdiameter.api.BaseSession;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.api.timer.ITimerFacility;
import org.jdiameter.common.impl.app.AppSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTimerFacilityImpl
implements ITimerFacility {
    private static final Logger logger = LoggerFactory.getLogger(LocalTimerFacilityImpl.class);
    private ScheduledThreadPoolExecutor executor;
    private ISessionDatasource sessionDataSource;
    private final GenericObjectPool pool = new GenericObjectPool((PoolableObjectFactory)new TimerTaskHandleFactory(), 100000, 2, 10L, 20000);

    public LocalTimerFacilityImpl(IContainer container) {
        this.executor = (ScheduledThreadPoolExecutor)container.getConcurrentFactory().getScheduledExecutorService(IConcurrentFactory.ScheduledExecServices.ApplicationSession.name());
        this.sessionDataSource = container.getAssemblerFacility().getComponentInstance(ISessionDatasource.class);
    }

    public void cancel(Serializable f) {
        TimerTaskHandle timerTaskHandle;
        if (f != null && f instanceof TimerTaskHandle && (timerTaskHandle = (TimerTaskHandle)f).future != null && this.executor.remove((Runnable)((Object)timerTaskHandle.future))) {
            timerTaskHandle.future.cancel(false);
            this.returnTimerTaskHandle(timerTaskHandle);
        }
    }

    public Serializable schedule(String sessionId, String timerName, long milliseconds) throws IllegalArgumentException {
        String id = sessionId + "/" + timerName;
        logger.debug("Scheduling timer with id [{}]", (Object)id);
        TimerTaskHandle ir = this.borrowTimerTaskHandle();
        ir.id = id;
        ir.sessionId = sessionId;
        ir.timerName = timerName;
        ir.future = this.executor.schedule(ir, milliseconds, TimeUnit.MILLISECONDS);
        return ir;
    }

    protected void returnTimerTaskHandle(TimerTaskHandle timerTaskHandle) {
        try {
            this.pool.returnObject((Object)timerTaskHandle);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
    }

    protected TimerTaskHandle borrowTimerTaskHandle() {
        try {
            TimerTaskHandle timerTaskHandle = (TimerTaskHandle)this.pool.borrowObject();
            return timerTaskHandle;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    private final class TimerTaskHandle
    implements Runnable,
    Externalizable {
        private String sessionId;
        private String timerName;
        private String id;
        private transient ScheduledFuture<?> future;

        private TimerTaskHandle() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                BaseSession bSession = LocalTimerFacilityImpl.this.sessionDataSource.getSession(this.sessionId);
                if (bSession == null || !bSession.isAppSession()) {
                    logger.error("Base Session is null for sessionId: {}", (Object)this.sessionId);
                    return;
                }
                try {
                    AppSessionImpl impl = (AppSessionImpl)bSession;
                    impl.onTimer(this.timerName);
                }
                catch (Exception e) {
                    logger.error("Caught exception from app session object!", (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error("Failure executing timer task witb id: " + this.id, (Throwable)e);
            }
            finally {
                LocalTimerFacilityImpl.this.returnTimerTaskHandle(this);
            }
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            throw new IOException("Failed to serialize local timer!");
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            throw new IOException("Failed to deserialize local timer!");
        }
    }

    class TimerTaskHandleFactory
    extends BasePoolableObjectFactory {
        TimerTaskHandleFactory() {
        }

        public Object makeObject() throws Exception {
            return new TimerTaskHandle();
        }

        public void passivateObject(Object obj) throws Exception {
            TimerTaskHandle timerTaskHandle = (TimerTaskHandle)obj;
            timerTaskHandle.id = null;
            timerTaskHandle.sessionId = null;
            timerTaskHandle.timerName = null;
            timerTaskHandle.future = null;
        }
    }
}

