/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.statistic;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdiameter.api.Configuration;
import org.jdiameter.client.impl.helpers.Parameters;
import org.jdiameter.common.api.statistic.IStatistic;
import org.jdiameter.common.api.statistic.IStatisticManager;
import org.jdiameter.common.api.statistic.IStatisticRecord;
import org.jdiameter.common.impl.statistic.StatisticImpl;
import org.jdiameter.common.impl.statistic.StatisticRecordImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticManagerImpl
implements IStatisticManager {
    private List<IStatistic> allStatistic = new CopyOnWriteArrayList<IStatistic>();
    private List<IStatisticRecord> allPSStatisticRecord = new CopyOnWriteArrayList<IStatisticRecord>();
    private List<IStatistic> frozenAllStatistic = Collections.unmodifiableList(this.allStatistic);
    private List<IStatisticRecord> frozenAllPSStatisticRecord = Collections.unmodifiableList(this.allPSStatisticRecord);
    private boolean enabled;
    private long pause;
    private long delay;
    private Set<String> activeRecords;

    public StatisticManagerImpl(Configuration config) {
        long pause = (Long)Parameters.StatisticsLoggerPause.defValue();
        long delay = (Long)Parameters.StatisticsLoggerDelay.defValue();
        boolean enabled = (Boolean)Parameters.StatisticsEnabled.defValue();
        String activeRecords = (String)Parameters.Statistics.defValue();
        Configuration[] loggerParams = config.getChildren(Parameters.Statistics.ordinal());
        if (loggerParams != null && loggerParams.length > 0) {
            pause = loggerParams[0].getLongValue(Parameters.StatisticsLoggerPause.ordinal(), pause);
            delay = loggerParams[0].getLongValue(Parameters.StatisticsLoggerDelay.ordinal(), delay);
            enabled = loggerParams[0].getBooleanValue(Parameters.StatisticsEnabled.ordinal(), enabled);
            activeRecords = loggerParams[0].getStringValue(Parameters.StatisticsActiveList.ordinal(), activeRecords);
        }
        this.pause = pause;
        this.delay = delay;
        this.enabled = enabled;
        HashSet<String> enabledSet = new HashSet<String>();
        if (activeRecords != null && activeRecords.length() > 0) {
            for (String s : activeRecords.split(",")) {
                enabledSet.add(s);
            }
        }
        this.activeRecords = Collections.unmodifiableSet(enabledSet);
    }

    @Override
    public IStatisticRecord newCounterRecord(IStatisticRecord.Counters recordDescription) {
        StatisticRecordImpl statisticRecord = new StatisticRecordImpl(recordDescription.name(), recordDescription.getDescription());
        statisticRecord.enable(this.isEnabled(recordDescription.name()));
        return statisticRecord;
    }

    @Override
    public IStatisticRecord newCounterRecord(IStatisticRecord.Counters recordDescription, IStatisticRecord.ValueHolder counters) {
        StatisticRecordImpl statisticRecord = new StatisticRecordImpl(recordDescription.name(), recordDescription.getDescription(), counters);
        statisticRecord.enable(this.isEnabled(recordDescription.name()));
        return statisticRecord;
    }

    @Override
    public IStatisticRecord newCounterRecord(IStatisticRecord.Counters recordDescription, IStatisticRecord.ValueHolder counter, IStatisticRecord ... rec) {
        StatisticRecordImpl statisticRecord = new StatisticRecordImpl(recordDescription.name(), recordDescription.getDescription(), counter, rec);
        statisticRecord.enable(this.isEnabled(recordDescription.name()));
        return statisticRecord;
    }

    @Override
    public IStatisticRecord newCounterRecord(String name, String description) {
        StatisticRecordImpl statisticRecord = new StatisticRecordImpl(name, description);
        statisticRecord.enable(this.isEnabled(name));
        return statisticRecord;
    }

    @Override
    public IStatisticRecord newCounterRecord(String name, String description, IStatisticRecord.ValueHolder counters) {
        StatisticRecordImpl statisticRecord = new StatisticRecordImpl(name, description, counters);
        statisticRecord.enable(this.isEnabled(name));
        return statisticRecord;
    }

    @Override
    public IStatisticRecord newPerSecondCounterRecord(String name, IStatisticRecord.Counters recordDescription, IStatisticRecord child) {
        StatisticRecordImpl prevValue = new StatisticRecordImpl(name, recordDescription.getDescription());
        StatisticRecordImpl psStatistic = new StatisticRecordImpl(recordDescription.name() + "." + name, recordDescription.getDescription(), child, prevValue);
        if (this.allPSStatisticRecord.contains(psStatistic)) {
            throw new IllegalArgumentException("Statistic already defined: " + psStatistic);
        }
        this.allPSStatisticRecord.add(psStatistic);
        return psStatistic;
    }

    @Override
    public IStatistic newStatistic(String name, IStatistic.Groups group, IStatisticRecord ... rec) {
        StatisticImpl statistic = new StatisticImpl(name, group, group.getDescription(), rec);
        statistic.enable(this.isEnabled(statistic.getName()));
        if (this.allStatistic.contains(statistic)) {
            throw new IllegalArgumentException("Statistic already defined: " + statistic);
        }
        this.allStatistic.add(statistic);
        return statistic;
    }

    @Override
    public void removePerSecondCounterRecord(IStatisticRecord rec) {
        this.allPSStatisticRecord.remove(rec);
    }

    @Override
    public void removeStatistic(IStatistic stat) {
        this.allStatistic.remove(stat);
    }

    private boolean isEnabled(String name) {
        if (this.activeRecords.contains(name)) {
            return true;
        }
        while (name.indexOf(".") > 0) {
            if (!this.activeRecords.contains(name = name.substring(0, name.lastIndexOf(".")))) continue;
            return true;
        }
        return this.activeRecords.contains(name);
    }

    @Override
    public boolean isOn() {
        return this.enabled;
    }

    @Override
    public long getPause() {
        return this.pause;
    }

    @Override
    public long getDelay() {
        return this.delay;
    }

    @Override
    public Set<String> getEnabled() {
        return this.activeRecords;
    }

    @Override
    public List<IStatisticRecord> getPSStatisticRecord() {
        return this.frozenAllPSStatisticRecord;
    }

    @Override
    public List<IStatistic> getStatistic() {
        return this.frozenAllStatistic;
    }
}

