/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.controller;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Peer;
import org.jdiameter.api.PeerState;
import org.jdiameter.api.PeerStateListener;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.URI;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.validation.Dictionary;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.IMetaData;
import org.jdiameter.client.api.IRequest;
import org.jdiameter.client.api.controller.IPeer;
import org.jdiameter.client.api.fsm.EventTypes;
import org.jdiameter.client.api.fsm.FsmEvent;
import org.jdiameter.client.api.fsm.IContext;
import org.jdiameter.client.api.fsm.IFsmFactory;
import org.jdiameter.client.api.fsm.IStateMachine;
import org.jdiameter.client.api.io.IConnection;
import org.jdiameter.client.api.io.IConnectionListener;
import org.jdiameter.client.api.io.ITransportLayerFactory;
import org.jdiameter.client.api.io.TransportError;
import org.jdiameter.client.api.io.TransportException;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.api.router.IRouter;
import org.jdiameter.client.impl.AbstractStateChangeListener;
import org.jdiameter.client.impl.DictionarySingleton;
import org.jdiameter.client.impl.controller.PeerTableImpl;
import org.jdiameter.client.impl.helpers.Parameters;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.api.statistic.IStatistic;
import org.jdiameter.common.api.statistic.IStatisticManager;
import org.jdiameter.common.api.statistic.IStatisticRecord;
import org.jdiameter.common.impl.controller.AbstractPeer;
import org.jdiameter.server.impl.MutablePeerTableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeerImpl
extends AbstractPeer
implements IPeer {
    private static final Logger logger = LoggerFactory.getLogger(PeerImpl.class);
    protected InetAddress[] addresses;
    protected String realmName;
    protected long vendorID;
    protected String productName;
    protected int firmWare;
    protected Set<ApplicationId> commonApplications = new HashSet<ApplicationId>();
    protected AtomicLong hopByHopId = new AtomicLong(uid.nextInt());
    protected int rating;
    protected boolean stopping = false;
    protected IMetaData metaData;
    protected PeerTableImpl table;
    protected IRouter router;
    protected final Map<Long, IMessage> peerRequests = new ConcurrentHashMap<Long, IMessage>();
    protected final Dictionary dictionary = DictionarySingleton.getDictionary();
    protected IStateMachine fsm;
    protected IMessageParser parser;
    protected boolean useUriAsFQDN = false;
    protected ISessionDatasource sessionDataSource;
    protected IConnection connection;
    protected IConnectionListener connListener = new IConnectionListener(){

        public void connectionOpened(String connKey) {
            logger.debug("Connection to {} is open", (Object)PeerImpl.this.uri);
            try {
                PeerImpl.this.fsm.handleEvent(new FsmEvent(EventTypes.CONNECT_EVENT, connKey));
            }
            catch (Exception e) {
                logger.warn("Unable to run start procedure", (Throwable)e);
            }
        }

        public void connectionClosed(String connKey, List notSent) {
            logger.debug("Connection from {} is closed", (Object)PeerImpl.this.uri);
            for (IMessage request : PeerImpl.this.peerRequests.values()) {
                if (request.getState() != 1) continue;
                request.setReTransmitted(true);
                request.setState(0);
                try {
                    PeerImpl.this.peerRequests.remove(request.getHopByHopIdentifier());
                    PeerImpl.this.table.sendMessage(request);
                }
                catch (Throwable exc) {
                    request.setReTransmitted(false);
                }
            }
            try {
                PeerImpl.this.fsm.handleEvent(new FsmEvent(EventTypes.DISCONNECT_EVENT, connKey));
            }
            catch (Exception e) {
                logger.warn("Unable to run stopping procedure", (Throwable)e);
            }
        }

        public void messageReceived(String connKey, IMessage message) {
            block9: {
                boolean req = message.isRequest();
                try {
                    int type = message.getCommandCode();
                    logger.debug("Receive message type [{}] to peer [{}]", new Object[]{type, connKey});
                    switch (type) {
                        case 257: {
                            PeerImpl.this.fsm.handleEvent(new FsmEvent(req ? EventTypes.CER_EVENT : EventTypes.CEA_EVENT, message, connKey));
                            break;
                        }
                        case 280: {
                            PeerImpl.this.fsm.handleEvent(new FsmEvent(req ? EventTypes.DWR_EVENT : EventTypes.DWA_EVENT, message, connKey));
                            break;
                        }
                        case 282: {
                            PeerImpl.this.fsm.handleEvent(new FsmEvent(req ? EventTypes.DPR_EVENT : EventTypes.DPA_EVENT, message));
                            break;
                        }
                        default: {
                            PeerImpl.this.fsm.handleEvent(new FsmEvent(EventTypes.RECEIVE_MSG_EVENT, message));
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn("Error while processing incoming message", (Throwable)e);
                    if (!req) break block9;
                    try {
                        message.setRequest(false);
                        message.setError(true);
                        message.getAvps().addAvp(268, 3004L, true);
                        PeerImpl.this.connection.sendMessage(message);
                    }
                    catch (Exception exc) {
                        logger.warn("Unable to send error answer", (Throwable)exc);
                    }
                }
            }
        }

        public void internalError(String connKey, IMessage message, TransportException cause) {
            try {
                logger.debug("internalError ", (Throwable)cause);
                PeerImpl.this.fsm.handleEvent(new FsmEvent(EventTypes.INTERNAL_ERROR, message));
            }
            catch (Exception e) {
                logger.debug("Unable to run internalError procedure", (Throwable)e);
            }
        }
    };

    public PeerImpl(PeerTableImpl table, int rating, URI remotePeer, String ip, String portRange, IMetaData metaData, Configuration config, Configuration peerConfig, IFsmFactory fsmFactory, ITransportLayerFactory trFactory, IStatisticManager statisticFactory, IConcurrentFactory concurrentFactory, IMessageParser parser, ISessionDatasource sessionDataSource) throws InternalException, TransportException {
        this(table, rating, remotePeer, ip, portRange, metaData, config, peerConfig, fsmFactory, trFactory, parser, statisticFactory, concurrentFactory, null, sessionDataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PeerImpl(PeerTableImpl table, int rating, URI remotePeer, String ip, String portRange, IMetaData metaData, Configuration config, Configuration peerConfig, IFsmFactory fsmFactory, ITransportLayerFactory trFactory, IMessageParser parser, IStatisticManager statisticFactory, IConcurrentFactory concurrentFactory, IConnection connection, ISessionDatasource sessionDataSource) throws InternalException, TransportException {
        super(remotePeer, statisticFactory);
        InetAddress remoteAddress;
        this.table = table;
        this.rating = rating;
        this.router = table.router;
        this.metaData = metaData;
        this.sessionDataSource = sessionDataSource;
        int port = remotePeer.getPort();
        try {
            remoteAddress = InetAddress.getByName(ip != null ? ip : remotePeer.getFQDN());
        }
        catch (UnknownHostException e) {
            throw new TransportException("Unable to retrieve host", TransportError.Internal, e);
        }
        IContext actionContext = this.getContext();
        this.fsm = fsmFactory.createInstanceFsm(actionContext, concurrentFactory, config);
        this.fsm.addStateChangeNotification(new AbstractStateChangeListener(){

            public void stateChanged(Enum oldState, Enum newState) {
                PeerState s = (PeerState)newState;
                if (PeerState.DOWN.equals((Object)s)) {
                    PeerImpl.this.stopping = false;
                }
            }
        });
        if (connection == null) {
            String ref = peerConfig.getStringValue(Parameters.SecurityRef.ordinal(), null);
            InetAddress localAddress = null;
            try {
                Peer local = metaData.getLocalPeer();
                localAddress = local.getIPAddresses() != null && local.getIPAddresses().length > 0 ? local.getIPAddresses()[0] : InetAddress.getByName(metaData.getLocalPeer().getUri().getFQDN());
            }
            catch (Exception e) {
                logger.warn("Unable to get local address", (Throwable)e);
            }
            int localPort = 0;
            if (portRange != null) {
                try {
                    String[] rng = portRange.trim().split("-");
                    int startRange = Integer.parseInt(rng[0]);
                    int endRange = Integer.parseInt(rng[1]);
                    boolean portNotAvailable = false;
                    int limit = 0;
                    int maxTries = endRange - startRange + 1;
                    logger.debug("Selecting local port randomly from range '{}-{}'. Doing {} tries (some ports may not be tested, others tested more than once).", new Object[]{startRange, endRange, maxTries});
                    do {
                        Object var31_34;
                        portNotAvailable = false;
                        ++limit;
                        localPort = startRange + new Random().nextInt(endRange - startRange + 1);
                        logger.trace("Checking if port '{}' is available.", (Object)localPort);
                        ServerSocket socket = null;
                        try {
                            try {
                                socket = new ServerSocket(localPort);
                                socket.setReuseAddress(true);
                            }
                            catch (IOException e) {
                                logger.trace("The port '{}' is NOT available.", (Object)localPort);
                                portNotAvailable = true;
                                var31_34 = null;
                                if (socket == null) continue;
                                logger.trace("The port '{}' is available and will be used.", (Object)localPort);
                                socket.close();
                                continue;
                            }
                            var31_34 = null;
                            if (socket == null) continue;
                        }
                        catch (Throwable throwable) {
                            var31_34 = null;
                            if (socket != null) {
                                logger.trace("The port '{}' is available and will be used.", (Object)localPort);
                                socket.close();
                            }
                            throw throwable;
                        }
                        logger.trace("The port '{}' is available and will be used.", (Object)localPort);
                        socket.close();
                    } while (portNotAvailable && limit < maxTries);
                    if (portNotAvailable) {
                        logger.warn("Unable to find available port in port range.");
                    }
                }
                catch (Exception exc) {
                    logger.warn("Unable to get local port.", (Throwable)exc);
                }
                logger.debug("Create connection with localAddress=[{}]; localPort=[{}]", (Object)localAddress, (Object)localPort);
            }
            this.connection = trFactory.createConnection(remoteAddress, concurrentFactory, port, localAddress, localPort, this.connListener, ref);
        } else {
            this.connection = connection;
            this.connection.addConnectionListener(this.connListener);
        }
        this.parser = parser;
        this.addresses = new InetAddress[]{remoteAddress};
        this.useUriAsFQDN = config.getBooleanValue(Parameters.UseUriAsFqdn.ordinal(), ((Boolean)Parameters.UseUriAsFqdn.defValue()).booleanValue());
    }

    public IContext getContext() {
        return new ActionContext();
    }

    private boolean isRedirectAnswer(Avp avpResCode, IMessage answer) {
        try {
            return (answer.getFlags() & 0x20) != 0 && avpResCode != null && avpResCode.getInteger32() == 3006;
        }
        catch (AvpDataException e) {
            return false;
        }
    }

    @Override
    public IStatistic getStatistic() {
        return this.statistic;
    }

    public void addPeerStateListener(final PeerStateListener listener) {
        this.fsm.addStateChangeNotification(new AbstractStateChangeListener(){

            public void stateChanged(Enum oldState, Enum newState) {
                listener.stateChanged((PeerState)oldState, (PeerState)newState);
            }

            public int hashCode() {
                return listener.hashCode();
            }

            public boolean equals(Object obj) {
                return listener.equals(obj);
            }
        });
    }

    public void removePeerStateListener(final PeerStateListener listener) {
        if (listener != null) {
            this.fsm.remStateChangeNotification(new AbstractStateChangeListener(){

                public void stateChanged(Enum oldState, Enum newState) {
                    listener.stateChanged((PeerState)oldState, (PeerState)newState);
                }

                public int hashCode() {
                    return listener.hashCode();
                }

                public boolean equals(Object obj) {
                    return listener.equals(obj);
                }
            });
        }
    }

    private IMessage processRedirectAnswer(IMessage request, IMessage answer) {
        int resultCode = 2001;
        try {
            this.router.processRedirectAnswer(request, answer, this.table);
            return null;
        }
        catch (RouteException exc) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to process redirect!", (Throwable)exc);
            }
            resultCode = 3005;
        }
        catch (Throwable exc) {
            logger.debug("Failed to process redirect!", exc);
            resultCode = 3002;
        }
        if (resultCode != 2001) {
            answer.setRequest(false);
            answer.setError(true);
            answer.getAvps().removeAvp(268);
            answer.getAvps().addAvp(268, (long)resultCode, true, false, true);
        }
        return answer;
    }

    public void connect() throws InternalException, IOException, IllegalDiameterStateException {
        if (this.getState(PeerState.class) != PeerState.DOWN) {
            throw new IllegalDiameterStateException("Invalid state:" + this.getState(PeerState.class));
        }
        try {
            this.fsm.handleEvent(new FsmEvent(EventTypes.START_EVENT));
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public void disconnect(int disconnectCause) throws InternalException, IllegalDiameterStateException {
        super.disconnect(disconnectCause);
        if (this.getState(PeerState.class) != PeerState.DOWN) {
            this.stopping = true;
            try {
                FsmEvent event = new FsmEvent(EventTypes.STOP_EVENT);
                event.setData(disconnectCause);
                this.fsm.handleEvent(event);
            }
            catch (OverloadException e) {
                this.stopping = false;
                logger.warn("Error during stopping procedure", (Throwable)e);
            }
        }
    }

    public <E> E getState(Class<E> enumc) {
        return (E)this.fsm.getState(enumc);
    }

    public URI getUri() {
        return this.uri;
    }

    public InetAddress[] getIPAddresses() {
        return this.addresses;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public long getVendorId() {
        return this.vendorID;
    }

    public String getProductName() {
        return this.productName;
    }

    public long getFirmware() {
        return this.firmWare;
    }

    public Set<ApplicationId> getCommonApplications() {
        return this.commonApplications;
    }

    @Override
    public long getHopByHopIdentifier() {
        return this.hopByHopId.incrementAndGet();
    }

    @Override
    public void addMessage(IMessage message) {
        this.peerRequests.put(message.getHopByHopIdentifier(), message);
    }

    @Override
    public void remMessage(IMessage message) {
        this.peerRequests.remove(message.getHopByHopIdentifier());
    }

    @Override
    public IMessage[] remAllMessage() {
        IMessage[] m = this.peerRequests.values().toArray(new IMessage[this.peerRequests.size()]);
        this.peerRequests.clear();
        return m;
    }

    @Override
    public boolean handleMessage(EventTypes type, IMessage message, String key) throws TransportException, OverloadException, InternalException {
        return !this.stopping && this.fsm.handleEvent(new FsmEvent(type, message, key));
    }

    @Override
    public boolean sendMessage(IMessage message) throws TransportException, OverloadException, InternalException {
        if (this.dictionary != null && this.dictionary.isEnabled()) {
            logger.debug("Message validation is ENABLED. Going to validate message before sending.");
            this.dictionary.validate((Message)message, false);
        }
        return !this.stopping && this.fsm.handleEvent(new FsmEvent(EventTypes.SEND_MSG_EVENT, message));
    }

    @Override
    public boolean hasValidConnection() {
        return this.connection != null && this.connection.isConnected();
    }

    @Override
    public void setRealm(String realm) {
        this.realmName = realm;
    }

    @Override
    public void addStateChangeListener(StateChangeListener listener) {
        this.fsm.addStateChangeNotification(listener);
    }

    @Override
    public void remStateChangeListener(StateChangeListener listener) {
        this.fsm.remStateChangeNotification(listener);
    }

    @Override
    public void addConnectionListener(IConnectionListener listener) {
        if (this.connection != null) {
            this.connection.addConnectionListener(listener);
        }
    }

    @Override
    public void remConnectionListener(IConnectionListener listener) {
        if (this.connection != null) {
            this.connection.remConnectionListener(listener);
        }
    }

    @Override
    public int getRating() {
        return this.rating;
    }

    @Override
    public boolean isConnected() {
        return this.getState(PeerState.class) == PeerState.OKAY;
    }

    public String toString() {
        return "CPeer{Uri=" + this.uri + "; State=" + (this.fsm != null ? (Serializable)this.fsm.getState(PeerState.class) : "n/a") + "; Con=" + this.connection + "}";
    }

    protected void fillIPAddressTable(IMessage message) {
        AvpSet avps = message.getAvps().getAvps(257);
        if (avps != null) {
            ArrayList<InetAddress> t = new ArrayList<InetAddress>();
            for (int i = 0; i < avps.size(); ++i) {
                try {
                    t.add(avps.getAvpByIndex(i).getAddress());
                    continue;
                }
                catch (AvpDataException e) {
                    logger.warn("Unable to retrieve IP Address from Host-IP-Address AVP");
                }
            }
            this.addresses = t.toArray(new InetAddress[t.size()]);
        }
    }

    protected Set<ApplicationId> getCommonApplicationIds(IMessage message) {
        HashSet<ApplicationId> newAppId = new HashSet<ApplicationId>();
        Set locAppId = this.metaData.getLocalPeer().getCommonApplications();
        List remAppId = message.getApplicationIdAvps();
        logger.debug("Checking common applications. Remote applications: {}. Local applications: {}", (Object)remAppId, (Object)locAppId);
        for (ApplicationId l : locAppId) {
            for (ApplicationId r : remAppId) {
                if (l.equals((Object)r)) {
                    newAppId.add(l);
                    continue;
                }
                if (r.getAcctAppId() != -1L && r.getAuthAppId() != -1L && l.getAcctAppId() != -1L && l.getAuthAppId() != -1L) continue;
                newAppId.add(r);
            }
        }
        return newAppId;
    }

    protected void sendErrorAnswer(IRequest request, String errorMessage, int resultCode, Avp ... avpsToAdd) {
        logger.debug("Could not process request. Result Code = [{}], Error Message: [{}]", (Object)resultCode, (Object)errorMessage);
        request.setRequest(false);
        request.getAvps().addAvp(268, (long)resultCode, true, false, true);
        if (avpsToAdd != null) {
            for (Avp a : avpsToAdd) {
                request.getAvps().addAvp(new Avp[]{a});
            }
        }
        request.getAvps().removeAvp(264);
        request.getAvps().removeAvp(296);
        request.getAvps().addAvp(264, this.metaData.getLocalPeer().getUri().getFQDN(), true, false, true);
        request.getAvps().addAvp(296, this.metaData.getLocalPeer().getRealmName(), true, false, true);
        if (errorMessage != null) {
            request.getAvps().addAvp(281, errorMessage, false);
        }
        request.getAvps().removeAvp(293);
        request.getAvps().removeAvp(283);
        try {
            logger.debug("Sending response indicating we could not process request");
            this.sendMessage((IMessage)request);
            if (this.statistic.isEnabled()) {
                this.statistic.getRecordByName(IStatisticRecord.Counters.SysGenResponse.name()).inc();
            }
        }
        catch (Exception e) {
            logger.debug("Unable to send answer", (Throwable)e);
        }
        if (this.statistic.isEnabled()) {
            this.statistic.getRecordByName(IStatisticRecord.Counters.NetGenRejectedRequest.name()).inc();
        }
    }

    protected class ActionContext
    implements IContext {
        protected ActionContext() {
        }

        public String toString() {
            return "ActionContext [getPeerDescription()=" + this.getPeerDescription() + ", isConnected()=" + this.isConnected() + ", isRestoreConnection()=" + this.isRestoreConnection() + "]";
        }

        public void connect() throws InternalException, IOException, IllegalDiameterStateException {
            try {
                PeerImpl.this.connection.connect();
                if (logger.isDebugEnabled()) {
                    logger.debug("Connected to peer {}", (Object)PeerImpl.this.getUri());
                }
            }
            catch (TransportException e) {
                logger.debug("Failure establishing connection.", (Throwable)e);
                switch (e.getCode()) {
                    case NetWorkError: {
                        throw new IOException("Unable to connect to " + PeerImpl.this.connection.getKey() + " - " + e.getMessage());
                    }
                    case FailedSendMessage: {
                        throw new IllegalDiameterStateException((Throwable)e);
                    }
                }
                throw new InternalException((Throwable)e);
            }
        }

        public void disconnect() throws InternalException, IllegalDiameterStateException {
            if (PeerImpl.this.connection != null) {
                PeerImpl.this.connection.disconnect();
                if (logger.isDebugEnabled()) {
                    logger.debug("Disconnected from peer {}", (Object)PeerImpl.this.getUri());
                }
            }
        }

        public String getPeerDescription() {
            return PeerImpl.this.uri.toString();
        }

        public boolean isConnected() {
            return PeerImpl.this.connection != null && PeerImpl.this.connection.isConnected();
        }

        public boolean sendMessage(IMessage message) throws TransportException, OverloadException {
            if (message.isTimeOut()) {
                logger.debug("Message {} skipped (timeout)", (Object)message);
                return false;
            }
            if (message.getState() == 1) {
                logger.debug("Message {} already sent", (Object)message);
                return false;
            }
            if (!message.isRequest()) {
                String[] originInfo;
                MutablePeerTableImpl peerTable;
                try {
                    long resultCode = message.getResultCode().getUnsigned32();
                    message.setError(resultCode >= 3000L && resultCode < 4000L);
                }
                catch (Exception e) {
                    logger.debug("Unable to retrieve Result-Code from answer. Not setting ERROR bit.");
                }
                message.getAvps().removeAvp(293);
                message.getAvps().removeAvp(283);
                int commandCode = message.getCommandCode();
                if (commandCode != 257 && commandCode != 280 && commandCode != 282 && PeerImpl.this.table instanceof MutablePeerTableImpl && (peerTable = (MutablePeerTableImpl)PeerImpl.this.table).isDuplicateProtection() && (originInfo = PeerImpl.this.router.getRequestRouteInfo(message)) != null) {
                    peerTable.saveToDuplicate(message.getDuplicationKey(originInfo[0], message.getEndToEndIdentifier()), message);
                }
            }
            PeerImpl.this.router.garbageCollectRequestRouteInfo(message);
            message.setState(1);
            logger.debug("Calling connection to send message [{}] to peer [{}] over the network", (Object)message, (Object)PeerImpl.this.getUri());
            PeerImpl.this.connection.sendMessage(message);
            logger.debug("Connection sent message [{}] to peer [{}] over the network", (Object)message, (Object)PeerImpl.this.getUri());
            return true;
        }

        public void sendCerMessage() throws TransportException, OverloadException {
            logger.debug("Send CER message");
            IMessage message = PeerImpl.this.parser.createEmptyMessage(257, 0L);
            message.setRequest(true);
            message.setHopByHopIdentifier(PeerImpl.this.getHopByHopIdentifier());
            if (PeerImpl.this.useUriAsFQDN) {
                message.getAvps().addAvp(264, PeerImpl.this.metaData.getLocalPeer().getUri().toString(), true, false, true);
            } else {
                message.getAvps().addAvp(264, PeerImpl.this.metaData.getLocalPeer().getUri().getFQDN(), true, false, true);
            }
            message.getAvps().addAvp(296, PeerImpl.this.metaData.getLocalPeer().getRealmName(), true, false, true);
            for (InetAddress ia : PeerImpl.this.metaData.getLocalPeer().getIPAddresses()) {
                message.getAvps().addAvp(257, ia, true, false);
            }
            message.getAvps().addAvp(266, PeerImpl.this.metaData.getLocalPeer().getVendorId(), true, false, true);
            message.getAvps().addAvp(269, PeerImpl.this.metaData.getLocalPeer().getProductName(), false);
            for (ApplicationId appId : PeerImpl.this.metaData.getLocalPeer().getCommonApplications()) {
                this.addAppId(appId, message);
            }
            message.getAvps().addAvp(267, PeerImpl.this.metaData.getLocalPeer().getFirmware(), true);
            message.getAvps().addAvp(278, PeerImpl.this.metaData.getLocalHostStateId(), true, false, true);
            this.sendMessage(message);
        }

        public void sendCeaMessage(int resultCode, Message cer, String errMessage) throws TransportException, OverloadException {
        }

        public void sendDwrMessage() throws TransportException, OverloadException {
            logger.debug("Send DWR message");
            IMessage message = PeerImpl.this.parser.createEmptyMessage(280, 0L);
            message.setRequest(true);
            message.setHopByHopIdentifier(PeerImpl.this.getHopByHopIdentifier());
            message.getAvps().addAvp(264, PeerImpl.this.metaData.getLocalPeer().getUri().getFQDN(), true, false, true);
            message.getAvps().addAvp(296, PeerImpl.this.metaData.getLocalPeer().getRealmName(), true, false, true);
            message.getAvps().addAvp(278, PeerImpl.this.metaData.getLocalHostStateId(), true, false, true);
            message.getAvps().removeAvp(293);
            message.getAvps().removeAvp(283);
            this.sendMessage(message);
        }

        public void sendDwaMessage(IMessage dwr, int resultCode, String errorMessage) throws TransportException, OverloadException {
            logger.debug("Send DWA message");
            IMessage message = PeerImpl.this.parser.createEmptyMessage(dwr);
            message.setRequest(false);
            message.setHopByHopIdentifier(dwr.getHopByHopIdentifier());
            message.setEndToEndIdentifier(dwr.getEndToEndIdentifier());
            message.getAvps().addAvp(268, (long)resultCode, true, false, true);
            message.getAvps().addAvp(264, PeerImpl.this.metaData.getLocalPeer().getUri().getFQDN(), true, false, true);
            message.getAvps().addAvp(296, PeerImpl.this.metaData.getLocalPeer().getRealmName(), true, false, true);
            if (errorMessage != null) {
                message.getAvps().addAvp(281, errorMessage, false);
            }
            message.getAvps().removeAvp(293);
            message.getAvps().removeAvp(283);
            this.sendMessage(message);
        }

        public boolean isRestoreConnection() {
            return true;
        }

        public void sendDprMessage(int disconnectCause) throws TransportException, OverloadException {
            logger.debug("Send DPR message with Disconnect-Cause [{}]", (Object)disconnectCause);
            IMessage message = PeerImpl.this.parser.createEmptyMessage(282, 0L);
            message.setRequest(true);
            message.setHopByHopIdentifier(PeerImpl.this.getHopByHopIdentifier());
            message.getAvps().addAvp(264, PeerImpl.this.metaData.getLocalPeer().getUri().getFQDN(), true, false, true);
            message.getAvps().addAvp(296, PeerImpl.this.metaData.getLocalPeer().getRealmName(), true, false, true);
            message.getAvps().addAvp(273, disconnectCause, true, false);
            this.sendMessage(message);
        }

        public void sendDpaMessage(IMessage dpr, int resultCode, String errorMessage) throws TransportException, OverloadException {
            logger.debug("Send DPA message");
            IMessage message = PeerImpl.this.parser.createEmptyMessage(dpr);
            message.setRequest(false);
            message.setHopByHopIdentifier(dpr.getHopByHopIdentifier());
            message.setEndToEndIdentifier(dpr.getEndToEndIdentifier());
            message.getAvps().addAvp(268, (long)resultCode, true, false, true);
            message.getAvps().addAvp(264, PeerImpl.this.metaData.getLocalPeer().getUri().getFQDN(), true, false, true);
            message.getAvps().addAvp(296, PeerImpl.this.metaData.getLocalPeer().getRealmName(), true, false, true);
            if (errorMessage != null) {
                message.getAvps().addAvp(281, errorMessage, false);
            }
            this.sendMessage(message);
        }

        public int processCerMessage(String key, IMessage message) {
            return 0;
        }

        public boolean processCeaMessage(String key, IMessage message) {
            boolean rc = true;
            try {
                Avp origHost = message.getAvps().getAvp(264);
                Avp origRealm = message.getAvps().getAvp(296);
                Avp vendorId = message.getAvps().getAvp(266);
                Avp prdName = message.getAvps().getAvp(269);
                Avp resCode = message.getAvps().getAvp(268);
                Avp frmId = message.getAvps().getAvp(267);
                if (origHost == null || origRealm == null || vendorId == null) {
                    logger.warn("Incorrect CEA message (missing mandatory AVPs)");
                } else {
                    int mrc;
                    if (PeerImpl.this.realmName == null) {
                        PeerImpl.this.realmName = origRealm.getDiameterIdentity();
                    }
                    if (PeerImpl.this.vendorID == 0L) {
                        PeerImpl.this.vendorID = vendorId.getUnsigned32();
                    }
                    PeerImpl.this.fillIPAddressTable(message);
                    if (PeerImpl.this.productName == null && prdName != null) {
                        PeerImpl.this.productName = prdName.getUTF8String();
                    }
                    if (resCode != null && (mrc = resCode.getInteger32()) != 2001) {
                        logger.debug("Result code value {}", (Object)mrc);
                        return false;
                    }
                    Set<ApplicationId> cai = PeerImpl.this.getCommonApplicationIds(message);
                    if (cai.size() > 0) {
                        PeerImpl.this.commonApplications.clear();
                        PeerImpl.this.commonApplications.addAll(cai);
                    } else {
                        logger.debug("CEA did not contained appId, therefore set local appids to common-appid field");
                        PeerImpl.this.commonApplications.clear();
                        PeerImpl.this.commonApplications.addAll(PeerImpl.this.metaData.getLocalPeer().getCommonApplications());
                    }
                    if (PeerImpl.this.firmWare == 0 && frmId != null) {
                        PeerImpl.this.firmWare = frmId.getInteger32();
                    }
                }
            }
            catch (Exception exc) {
                logger.debug("Incorrect CEA message", (Throwable)exc);
                rc = false;
            }
            return rc;
        }

        public boolean receiveMessage(IMessage message) {
            logger.debug("Receiving message in client.");
            boolean isProcessed = false;
            if (message.isRequest()) {
                logger.debug("Message is a request");
                String avpSessionId = message.getSessionId();
                if (avpSessionId != null) {
                    NetworkReqListener listener = PeerImpl.this.sessionDataSource.getSessionListener(avpSessionId);
                    if (listener != null) {
                        PeerImpl.this.router.registerRequestRouteInfo(message);
                        IMessage answer = (IMessage)listener.processRequest((Request)message);
                        if (answer != null) {
                            try {
                                this.sendMessage(answer);
                                if (PeerImpl.this.statistic.isEnabled()) {
                                    PeerImpl.this.statistic.getRecordByName(IStatisticRecord.Counters.AppGenResponse.name()).inc();
                                }
                            }
                            catch (Exception e) {
                                logger.warn("Unable to send immediate answer {}", (Object)answer);
                            }
                        }
                        if (PeerImpl.this.statistic.isEnabled()) {
                            PeerImpl.this.statistic.getRecordByName(IStatisticRecord.Counters.NetGenRequest.name()).inc();
                        }
                        isProcessed = true;
                    } else if (PeerImpl.this.statistic.isEnabled()) {
                        PeerImpl.this.statistic.getRecordByName(IStatisticRecord.Counters.NetGenRejectedRequest.name()).inc();
                    }
                }
            } else {
                logger.debug("Message is an answer");
                IMessage request = PeerImpl.this.peerRequests.remove(message.getHopByHopIdentifier());
                if (request != null && !request.isTimeOut()) {
                    request.clearTimer();
                    request.setState(3);
                    Avp avpResCode = message.getAvps().getAvp(268);
                    if (PeerImpl.this.isRedirectAnswer(avpResCode, message)) {
                        message.setListener(request.getEventListener());
                        message = PeerImpl.this.processRedirectAnswer(request, message);
                        boolean bl = isProcessed = message == null;
                    }
                    if (message != null) {
                        if (request.getEventListener() != null) {
                            request.getEventListener().receivedSuccessMessage((Message)request, (Message)message);
                        } else {
                            logger.debug("Unable to call answer listener for request {} because listener is not set", (Object)message);
                            if (PeerImpl.this.statistic.isEnabled()) {
                                PeerImpl.this.statistic.getRecordByName(IStatisticRecord.Counters.NetGenRejectedResponse.name()).inc();
                            }
                        }
                        isProcessed = true;
                        if (PeerImpl.this.statistic.isEnabled()) {
                            PeerImpl.this.statistic.getRecordByName(IStatisticRecord.Counters.NetGenResponse.name()).inc();
                        }
                    } else if (PeerImpl.this.statistic.isEnabled()) {
                        PeerImpl.this.statistic.getRecordByName(IStatisticRecord.Counters.NetGenRejectedResponse.name()).inc();
                    }
                } else if (PeerImpl.this.statistic.isEnabled()) {
                    PeerImpl.this.statistic.getRecordByName(IStatisticRecord.Counters.NetGenRejectedResponse.name()).inc();
                }
            }
            return isProcessed;
        }

        public int processDwrMessage(IMessage iMessage) {
            return 2001;
        }

        public int processDprMessage(IMessage iMessage) {
            return 2001;
        }

        protected void addAppId(ApplicationId appId, IMessage message) {
            if (appId.getVendorId() == 0L) {
                if (appId.getAuthAppId() != 0L) {
                    message.getAvps().addAvp(258, appId.getAuthAppId(), true, false, true);
                } else if (appId.getAcctAppId() != 0L) {
                    message.getAvps().addAvp(259, appId.getAcctAppId(), true, false, true);
                }
            } else {
                boolean vendorIdPresent = false;
                for (Avp avp : message.getAvps().getAvps(265)) {
                    try {
                        if (avp.getUnsigned32() != appId.getVendorId()) continue;
                        vendorIdPresent = true;
                        break;
                    }
                    catch (Exception e) {
                        logger.debug("Failed to read Supported-Vendor-Id.", (Throwable)e);
                    }
                }
                if (!vendorIdPresent) {
                    message.getAvps().addAvp(265, appId.getVendorId(), true, false, true);
                }
                AvpSet vendorApp = message.getAvps().addGroupedAvp(260, true, false);
                vendorApp.addAvp(266, appId.getVendorId(), true, false, true);
                if (appId.getAuthAppId() != 0L) {
                    vendorApp.addAvp(258, appId.getAuthAppId(), true, false, true);
                }
                if (appId.getAcctAppId() != 0L) {
                    vendorApp.addAvp(259, appId.getAcctAppId(), true, false, true);
                }
            }
        }

        public void removeStatistics() {
            PeerImpl.this.removePeerStatistics();
        }

        public void createStatistics() {
            PeerImpl.this.createPeerStatistics();
        }
    }
}

