/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.app.auth;

import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.auth.ServerAuthSession;
import org.jdiameter.api.auth.ServerAuthSessionListener;
import org.jdiameter.api.auth.events.AbortSessionAnswer;
import org.jdiameter.api.auth.events.AbortSessionRequest;
import org.jdiameter.api.auth.events.ReAuthRequest;
import org.jdiameter.api.auth.events.SessionTermAnswer;
import org.jdiameter.api.auth.events.SessionTermRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.auth.IAuthMessageFactory;
import org.jdiameter.common.api.app.auth.IServerAuthActionContext;
import org.jdiameter.common.api.app.auth.ServerAuthSessionState;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.auth.AbortSessionAnswerImpl;
import org.jdiameter.common.impl.app.auth.AbortSessionRequestImpl;
import org.jdiameter.common.impl.app.auth.AppAuthSessionImpl;
import org.jdiameter.server.impl.app.auth.Event;
import org.jdiameter.server.impl.app.auth.IServerAuthSessionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerAuthSessionImpl
extends AppAuthSessionImpl
implements ServerAuthSession,
EventListener<Request, Answer>,
NetworkReqListener {
    private static final long serialVersionUID = 1L;
    protected static final Logger logger = LoggerFactory.getLogger(ServerAuthSessionImpl.class);
    protected IServerAuthSessionData sessionData;
    private Lock sendAndStateLock = new ReentrantLock();
    protected transient IAuthMessageFactory factory;
    protected transient IServerAuthActionContext context;
    protected transient ServerAuthSessionListener listener;
    protected static final String TIMER_NAME_TS = "AUTH_TS";

    public ServerAuthSessionImpl(IServerAuthSessionData sessionData, ISessionFactory sf, ServerAuthSessionListener lst, IAuthMessageFactory fct, StateChangeListener<AppSession> scListener, IServerAuthActionContext context, long tsTimeout, boolean stateless) {
        super(sf, sessionData);
        this.appId = fct.getApplicationId();
        this.listener = lst;
        this.factory = fct;
        this.context = context;
        this.sessionData = sessionData;
        this.sessionData.setStateless(stateless);
        this.sessionData.setTsTimeout(tsTimeout);
        super.addStateChangeNotification(scListener);
    }

    public void sendAuthAnswer(AppAnswerEvent appAnswerEvent) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(null, (AppEvent)appAnswerEvent);
    }

    public void sendReAuthRequest(ReAuthRequest reAuthRequest) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(null, (AppEvent)reAuthRequest);
    }

    public void sendAbortSessionRequest(AbortSessionRequest abortSessionRequest) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_ASR_REQUEST, (AppEvent)abortSessionRequest);
    }

    public void sendSessionTerminationAnswer(SessionTermAnswer sessionTermAnswer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(null, (AppEvent)sessionTermAnswer);
    }

    protected void send(Event.Type type, AppEvent event) throws InternalException {
        try {
            this.sendAndStateLock.lock();
            if (type != null) {
                this.handleEvent(new Event(type, event));
            }
            this.session.send(event.getMessage(), (EventListener)this);
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    public boolean isStateless() {
        return this.sessionData.isStateless();
    }

    protected void setState(ServerAuthSessionState newState) {
        ServerAuthSessionState oldState = this.sessionData.getServerAuthSessionState();
        this.sessionData.setServerAuthSessionState(newState);
        for (StateChangeListener i : this.stateListeners) {
            i.stateChanged((Object)this, (Enum)oldState, (Enum)newState);
        }
    }

    public <E> E getState(Class<E> eClass) {
        return (E)(eClass == ServerAuthSessionState.class ? this.sessionData.getServerAuthSessionState() : null);
    }

    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        return this.isStateless() ? this.handleEventForStatelessSession(event) : this.handleEventForStatefullSession(event);
    }

    public boolean handleEventForStatelessSession(StateEvent event) throws InternalException, OverloadException {
        try {
            block1 : switch (this.sessionData.getServerAuthSessionState()) {
                case IDLE: {
                    switch ((Event.Type)event.getType()) {
                        case RECEIVE_AUTH_REQUEST: {
                            this.setState(ServerAuthSessionState.IDLE);
                            this.listener.doAuthRequestEvent((ServerAuthSession)this, (AppRequestEvent)event.getData());
                            break block1;
                        }
                    }
                    logger.debug("Unknown event {}", (Object)event.getType());
                }
            }
        }
        catch (Throwable t) {
            throw new InternalException(t);
        }
        return true;
    }

    public boolean handleEventForStatefullSession(StateEvent event) throws InternalException, OverloadException {
        ServerAuthSessionState state;
        ServerAuthSessionState oldState = state = this.sessionData.getServerAuthSessionState();
        try {
            block5 : switch (state) {
                case IDLE: {
                    switch ((Event.Type)event.getType()) {
                        case RECEIVE_AUTH_REQUEST: {
                            try {
                                this.setState(ServerAuthSessionState.OPEN);
                                this.listener.doAuthRequestEvent((ServerAuthSession)this, (AppRequestEvent)event.getData());
                            }
                            catch (Exception e) {
                                this.setState(ServerAuthSessionState.IDLE);
                            }
                            break block5;
                        }
                        case RECEIVE_STR_REQUEST: {
                            try {
                                this.setState(ServerAuthSessionState.IDLE);
                                this.listener.doSessionTerminationRequestEvent((ServerAuthSession)this, (SessionTermRequest)event.getData());
                            }
                            catch (Exception e) {
                                logger.debug("Can not handle event", (Throwable)e);
                            }
                            break block5;
                        }
                        case SEND_ASR_REQUEST: {
                            this.setState(ServerAuthSessionState.DISCONNECTED);
                            break block5;
                        }
                        case TIMEOUT_EXPIRES: {
                            if (this.context != null) {
                                this.context.accessTimeoutElapses(this);
                            }
                            this.setState(ServerAuthSessionState.IDLE);
                            break block5;
                        }
                    }
                    logger.debug("Unknown event {}", (Object)event.getType());
                    break;
                }
                case OPEN: {
                    switch ((Event.Type)event.getType()) {
                        case RECEIVE_AUTH_REQUEST: {
                            try {
                                this.listener.doAuthRequestEvent((ServerAuthSession)this, (AppRequestEvent)event.getData());
                            }
                            catch (Exception e) {
                                this.setState(ServerAuthSessionState.IDLE);
                            }
                            break block5;
                        }
                        case RECEIVE_STR_REQUEST: {
                            try {
                                this.setState(ServerAuthSessionState.IDLE);
                                this.listener.doSessionTerminationRequestEvent((ServerAuthSession)this, (SessionTermRequest)event.getData());
                            }
                            catch (Exception e) {
                                logger.debug("Can not handle event", (Throwable)e);
                            }
                            break block5;
                        }
                        case SEND_ASR_REQUEST: {
                            this.setState(ServerAuthSessionState.DISCONNECTED);
                            break block5;
                        }
                        case TIMEOUT_EXPIRES: {
                            if (this.context != null) {
                                this.context.accessTimeoutElapses(this);
                            }
                            this.setState(ServerAuthSessionState.IDLE);
                            break block5;
                        }
                    }
                    logger.debug("Unknown event {}", (Object)event.getType());
                    break;
                }
                case DISCONNECTED: {
                    switch ((Event.Type)event.getType()) {
                        case SEND_ASR_FAILURE: {
                            this.setState(ServerAuthSessionState.DISCONNECTED);
                            break block5;
                        }
                        case RECEIVE_ASR_ANSWER: {
                            this.setState(ServerAuthSessionState.IDLE);
                            this.listener.doAbortSessionAnswerEvent((ServerAuthSession)this, (AbortSessionAnswer)event.getData());
                            break block5;
                        }
                    }
                    logger.debug("Unknown event {}", (Object)event.getType());
                    break;
                }
                default: {
                    logger.debug("Unknown state {}", (Object)state);
                }
            }
            if (oldState != state && ServerAuthSessionState.OPEN.equals(state) && this.context != null && this.context != null) {
                this.cancelTsTimer();
                this.startTsTimer();
            }
        }
        catch (Throwable t) {
            throw new InternalException(t);
        }
        return true;
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery rd = new AnswerDelivery();
        rd.session = this;
        rd.request = request;
        rd.answer = answer;
        this.scheduler.execute(rd);
    }

    public void timeoutExpired(Request request) {
        try {
            if (request.getCommandCode() == 274) {
                this.handleEvent(new Event(Event.Type.SEND_ASR_FAILURE, new AbortSessionRequestImpl((Message)request)));
            } else {
                logger.debug("Timeout for unknown request {}", (Object)request);
            }
        }
        catch (Exception e) {
            logger.debug("Can not handle event", (Throwable)e);
        }
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    @Override
    public boolean isReplicable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTsTimer() {
        try {
            this.sendAndStateLock.lock();
            if (this.sessionData.getTsTimeout() > 0L) {
                this.sessionData.setTsTimerId(this.timerFacility.schedule(this.sessionData.getSessionId(), TIMER_NAME_TS, this.sessionData.getTsTimeout()));
            }
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelTsTimer() {
        try {
            this.sendAndStateLock.lock();
            Serializable tsTimerId = this.sessionData.getTsTimerId();
            if (tsTimerId != null) {
                this.timerFacility.cancel(tsTimerId);
                this.sessionData.setTsTimerId(null);
            }
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTimer(String timerName) {
        if (timerName.equals(TIMER_NAME_TS)) {
            try {
                this.sendAndStateLock.lock();
                this.sessionData.setTsTimerId(null);
                this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, null));
            }
            catch (Exception e) {
                logger.debug("Can not handle event", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.sessionData == null ? 0 : this.sessionData.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerAuthSessionImpl other = (ServerAuthSessionImpl)obj;
        return !(this.sessionData == null ? other.sessionData != null : !this.sessionData.equals(other.sessionData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.isValid()) {
            try {
                this.sendAndStateLock.lock();
                super.release();
                this.context = null;
                this.listener = null;
            }
            catch (Exception e) {
                logger.debug("Failed to release session", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        } else {
            logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }

    private class AnswerDelivery
    implements Runnable {
        ServerAuthSession session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ServerAuthSessionImpl.this.sendAndStateLock.lock();
                if (this.request.getCommandCode() == ServerAuthSessionImpl.this.factory.getAuthMessageCommandCode()) {
                    ServerAuthSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_AUTH_REQUEST, (AppEvent)ServerAuthSessionImpl.this.factory.createAuthRequest(this.request)));
                } else if (this.request.getCommandCode() == 274) {
                    ServerAuthSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_ASR_ANSWER, new AbortSessionAnswerImpl(this.answer)));
                } else {
                    ServerAuthSessionImpl.this.listener.doOtherEvent((AppSession)this.session, ServerAuthSessionImpl.this.factory.createAuthRequest(this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
                }
            }
            catch (Exception e) {
                logger.debug("Can not handle event", (Throwable)e);
            }
            finally {
                ServerAuthSessionImpl.this.sendAndStateLock.unlock();
            }
        }
    }

    private class RequestDelivery
    implements Runnable {
        ServerAuthSession session;
        Request request;

        private RequestDelivery() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.request != null) {
                if (this.request.getCommandCode() == ServerAuthSessionImpl.this.factory.getAuthMessageCommandCode()) {
                    try {
                        ServerAuthSessionImpl.this.sendAndStateLock.lock();
                        ServerAuthSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_AUTH_REQUEST, (AppEvent)ServerAuthSessionImpl.this.factory.createAuthRequest(this.request)));
                    }
                    catch (Exception e) {
                        logger.debug("Can not handle event", (Throwable)e);
                    }
                    finally {
                        ServerAuthSessionImpl.this.sendAndStateLock.unlock();
                    }
                } else {
                    try {
                        ServerAuthSessionImpl.this.listener.doOtherEvent((AppSession)this.session, ServerAuthSessionImpl.this.factory.createAuthRequest(this.request), null);
                    }
                    catch (Exception e) {
                        logger.debug("Can not handle event", (Throwable)e);
                    }
                }
            }
        }
    }
}

