/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.app.acc;

import java.io.Serializable;
import org.jdiameter.api.Answer;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.acc.ServerAccSession;
import org.jdiameter.api.acc.ServerAccSessionListener;
import org.jdiameter.api.acc.events.AccountAnswer;
import org.jdiameter.api.acc.events.AccountRequest;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.IAppSessionState;
import org.jdiameter.common.api.app.acc.IServerAccActionContext;
import org.jdiameter.common.api.app.acc.ServerAccSessionState;
import org.jdiameter.common.impl.app.acc.AppAccSessionImpl;
import org.jdiameter.server.impl.app.acc.Event;
import org.jdiameter.server.impl.app.acc.IServerAccSessionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerAccSessionImpl
extends AppAccSessionImpl
implements EventListener<Request, Answer>,
ServerAccSession,
NetworkReqListener {
    private static final Logger logger = LoggerFactory.getLogger(ServerAccSessionImpl.class);
    protected transient IServerAccActionContext context;
    protected transient ServerAccSessionListener listener;
    protected static final String TIMER_NAME_TS = "TS";
    protected IServerAccSessionData sessionData;

    public ServerAccSessionImpl(IServerAccSessionData sessionData, ISessionFactory sessionFactory, ServerAccSessionListener serverSessionListener, IServerAccActionContext serverContextListener, StateChangeListener<AppSession> stLst, boolean stateless) {
        this(sessionData, sessionFactory, serverSessionListener, serverContextListener, stLst);
        this.sessionData.setTsTimeout(0L);
        this.sessionData.setStateless(stateless);
    }

    public ServerAccSessionImpl(IServerAccSessionData sessionData, ISessionFactory sessionFactory, ServerAccSessionListener serverSessionListener, IServerAccActionContext serverContextListener, StateChangeListener<AppSession> stLst) {
        super(sessionFactory, sessionData);
        this.sessionData = sessionData;
        this.listener = serverSessionListener;
        this.context = serverContextListener;
        super.addStateChangeNotification(stLst);
    }

    public void sendAccountAnswer(AccountAnswer accountAnswer) throws InternalException, IllegalStateException, RouteException, OverloadException {
        try {
            AvpSet avpSet = accountAnswer.getMessage().getAvps();
            Avp acctInterimIntervalAvp = avpSet.getAvp(85);
            if (acctInterimIntervalAvp != null) {
                try {
                    this.sessionData.setTsTimeout(acctInterimIntervalAvp.getUnsigned32());
                }
                catch (AvpDataException e) {
                    throw new InternalException((Throwable)e);
                }
            }
            this.cancelTsTimer();
            this.startTsTimer();
            this.session.send(accountAnswer.getMessage());
            if (this.isStateless() && this.isValid()) {
                this.session.release();
            }
        }
        catch (IllegalDiameterStateException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isStateless() {
        return this.sessionData.isStateless();
    }

    protected void setState(IAppSessionState newState) {
        ServerAccSessionState oldState = this.sessionData.getServerAccSessionState();
        this.sessionData.setServerAccSessionState((ServerAccSessionState)newState);
        for (StateChangeListener i : this.stateListeners) {
            i.stateChanged((Object)this, (Enum)oldState, (Enum)((Object)newState));
        }
    }

    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        return this.sessionData.isStateless() ? this.handleEventForStatelessMode(event) : this.handleEventForStatefulMode(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEventForStatelessMode(StateEvent event) throws InternalException, OverloadException {
        try {
            ServerAccSessionState state = this.sessionData.getServerAccSessionState();
            block6 : switch (state) {
                case IDLE: {
                    switch ((Event.Type)event.getType()) {
                        case RECEIVED_START_RECORD: {
                            if (this.listener == null) break block6;
                            try {
                                this.listener.doAccRequestEvent((ServerAccSession)this, (AccountRequest)event.getData());
                            }
                            catch (Exception e) {
                                logger.debug("Can not handle event", (Throwable)e);
                            }
                            break block6;
                        }
                        case RECEIVED_EVENT_RECORD: {
                            if (this.listener != null) {
                                try {
                                    this.listener.doAccRequestEvent((ServerAccSession)this, (AccountRequest)event.getData());
                                }
                                catch (Exception e) {
                                    logger.debug("Can not handle event", (Throwable)e);
                                }
                            }
                            this.setState(ServerAccSessionState.IDLE);
                            break block6;
                        }
                        case RECEIVED_INTERIM_RECORD: {
                            if (this.listener == null) break block6;
                            try {
                                this.listener.doAccRequestEvent((ServerAccSession)this, (AccountRequest)event.getData());
                            }
                            catch (Exception e) {
                                logger.debug("Can not handle event", (Throwable)e);
                            }
                            break block6;
                        }
                        case RECEIVED_STOP_RECORD: {
                            if (this.listener == null) break block6;
                            try {
                                this.listener.doAccRequestEvent((ServerAccSession)this, (AccountRequest)event.getData());
                            }
                            catch (Exception e) {
                                logger.debug("Can not handle event", (Throwable)e);
                            }
                            break block6;
                        }
                    }
                    throw new IllegalStateException("Current state " + state + " action " + event.getType());
                }
            }
        }
        catch (Exception e) {
            logger.debug("Can not process event", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public boolean handleEventForStatefulMode(StateEvent event) throws InternalException, OverloadException {
        block32: {
            try {
                if (((AccountRequest)event.getData()).getMessage().isReTransmitted()) {
                    try {
                        this.cancelTsTimer();
                        this.startTsTimer();
                        this.setState(ServerAccSessionState.OPEN);
                        this.listener.doAccRequestEvent((ServerAccSession)this, (AccountRequest)event.getData());
                        if (this.context != null) {
                            this.context.sessionTimerStarted(this, null);
                        }
                    }
                    catch (Exception e) {
                        logger.debug("Can not handle event", (Throwable)e);
                        this.setState(ServerAccSessionState.IDLE);
                    }
                    return true;
                }
                ServerAccSessionState state = this.sessionData.getServerAccSessionState();
                AccountRequest request = (AccountRequest)event.getData();
                AvpSet avpSet = request.getMessage().getAvps();
                Avp acctInterimIntervalAvp = avpSet.getAvp(85);
                if (acctInterimIntervalAvp != null) {
                    this.sessionData.setTsTimeout(acctInterimIntervalAvp.getUnsigned32());
                }
                block6 : switch (state) {
                    case IDLE: {
                        switch ((Event.Type)event.getType()) {
                            case RECEIVED_START_RECORD: {
                                this.setState(ServerAccSessionState.OPEN);
                                if (this.listener != null) {
                                    try {
                                        this.listener.doAccRequestEvent((ServerAccSession)this, (AccountRequest)event.getData());
                                        this.cancelTsTimer();
                                        this.startTsTimer();
                                        if (this.context != null) {
                                            this.context.sessionTimerStarted(this, null);
                                        }
                                        break block32;
                                    }
                                    catch (Exception e) {
                                        logger.debug("Can not handle event", (Throwable)e);
                                        this.setState(ServerAccSessionState.IDLE);
                                    }
                                    break;
                                }
                                break block32;
                            }
                            case RECEIVED_EVENT_RECORD: {
                                if (this.listener != null) {
                                    try {
                                        this.listener.doAccRequestEvent((ServerAccSession)this, (AccountRequest)event.getData());
                                        break;
                                    }
                                    catch (Exception e) {
                                        logger.debug("Can not handle event", (Throwable)e);
                                    }
                                } else {
                                    break;
                                }
                            }
                        }
                        break;
                    }
                    case OPEN: {
                        switch ((Event.Type)event.getType()) {
                            case RECEIVED_INTERIM_RECORD: {
                                try {
                                    this.listener.doAccRequestEvent((ServerAccSession)this, (AccountRequest)event.getData());
                                    this.cancelTsTimer();
                                    this.startTsTimer();
                                    if (this.context != null) {
                                        this.context.sessionTimerStarted(this, null);
                                    }
                                    break block32;
                                }
                                catch (Exception e) {
                                    logger.debug("Can not handle event", (Throwable)e);
                                    this.setState(ServerAccSessionState.IDLE);
                                }
                                break block32;
                            }
                            case RECEIVED_STOP_RECORD: {
                                try {
                                    this.setState(ServerAccSessionState.IDLE);
                                    this.cancelTsTimer();
                                    this.listener.doAccRequestEvent((ServerAccSession)this, (AccountRequest)event.getData());
                                    if (this.context != null) {
                                        this.context.sessionTimerCanceled(this, null);
                                        break block6;
                                    }
                                }
                                catch (Exception e) {
                                    logger.debug("Can not handle event", (Throwable)e);
                                    this.setState(ServerAccSessionState.IDLE);
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Can not process event", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTsTimer() {
        try {
            this.sendAndStateLock.lock();
            if (this.sessionData.getTsTimeout() > 0L) {
                Serializable tsTid = this.timerFacility.schedule(this.sessionData.getSessionId(), TIMER_NAME_TS, this.sessionData.getTsTimeout());
                this.sessionData.setTsTimerId(tsTid);
            }
            return;
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTsTimer() {
        try {
            this.sendAndStateLock.lock();
            Serializable tsTid = this.sessionData.getTsTimerId();
            if (tsTid != null) {
                this.timerFacility.cancel(tsTid);
                this.sessionData.setTsTimerId(null);
            }
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    @Override
    public void onTimer(String timerName) {
        if (timerName.equals(TIMER_NAME_TS)) {
            if (this.context != null) {
                try {
                    this.context.sessionTimeoutElapses(this);
                }
                catch (InternalException e) {
                    logger.debug("Failure on processing expired Ts", (Throwable)e);
                }
            }
            this.setState(ServerAccSessionState.IDLE);
        }
    }

    protected Answer createStopAnswer(Request request) {
        Answer answer = request.createAnswer(2001L);
        answer.getAvps().addAvp(480, 4);
        answer.getAvps().addAvp(new Avp[]{request.getAvps().getAvp(485)});
        return answer;
    }

    protected Answer createInterimAnswer(Request request) {
        Answer answer = request.createAnswer(2001L);
        answer.getAvps().addAvp(480, 3);
        answer.getAvps().addAvp(new Avp[]{request.getAvps().getAvp(485)});
        return answer;
    }

    protected Answer createEventAnswer(Request request) {
        Answer answer = request.createAnswer(2001L);
        answer.getAvps().addAvp(480, 2);
        answer.getAvps().addAvp(new Avp[]{request.getAvps().getAvp(485)});
        return answer;
    }

    protected Answer createStartAnswer(Request request) {
        Answer answer = request.createAnswer(2001L);
        answer.getAvps().addAvp(480, 1);
        answer.getAvps().addAvp(new Avp[]{request.getAvps().getAvp(485)});
        return answer;
    }

    public <E> E getState(Class<E> eClass) {
        return (E)(eClass == ServerAccSessionState.class ? this.sessionData.getServerAccSessionState() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Answer processRequest(Request request) {
        if (request.getCommandCode() == 271) {
            try {
                this.sendAndStateLock.lock();
                this.handleEvent(new Event(this.createAccountRequest(request)));
            }
            catch (Exception e) {
                logger.debug("Can not handle event", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        } else {
            try {
                this.listener.doOtherEvent((AppSession)this, (AppRequestEvent)this.createAccountRequest(request), null);
            }
            catch (Exception e) {
                logger.debug("Can not handle event", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedSuccessMessage(Request request, Answer answer) {
        if (request.getCommandCode() == 271) {
            try {
                this.sendAndStateLock.lock();
                this.handleEvent(new Event(this.createAccountRequest(request)));
            }
            catch (Exception e) {
                logger.debug("Can not handle event", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
            try {
                this.listener.doAccRequestEvent((ServerAccSession)this, this.createAccountRequest(request));
            }
            catch (Exception e) {
                logger.debug("Can not handle event", (Throwable)e);
            }
        } else {
            try {
                this.listener.doOtherEvent((AppSession)this, (AppRequestEvent)this.createAccountRequest(request), (AppAnswerEvent)this.createAccountAnswer(answer));
            }
            catch (Exception e) {
                logger.debug("Can not handle event", (Throwable)e);
            }
        }
    }

    public void timeoutExpired(Request request) {
    }

    @Override
    public boolean isReplicable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.isValid()) {
            try {
                this.sendAndStateLock.lock();
                super.release();
            }
            catch (Exception e) {
                logger.debug("Failed to release session", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        } else {
            logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }
}

