/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import java.util.Set;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.LocalAction;
import org.jdiameter.api.Message;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.PeerState;
import org.jdiameter.api.Request;
import org.jdiameter.api.StatisticRecord;
import org.jdiameter.api.URI;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.IMetaData;
import org.jdiameter.client.api.IRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.api.controller.IRealm;
import org.jdiameter.client.api.controller.IRealmTable;
import org.jdiameter.client.api.fsm.IContext;
import org.jdiameter.client.api.io.IConnection;
import org.jdiameter.client.api.io.ITransportLayerFactory;
import org.jdiameter.client.api.io.TransportException;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.api.router.IRouter;
import org.jdiameter.client.impl.controller.PeerImpl;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.api.statistic.IStatistic;
import org.jdiameter.common.api.statistic.IStatisticManager;
import org.jdiameter.common.api.statistic.IStatisticRecord;
import org.jdiameter.server.api.IFsmFactory;
import org.jdiameter.server.api.INetwork;
import org.jdiameter.server.api.IOverloadManager;
import org.jdiameter.server.api.IPeer;
import org.jdiameter.server.api.IStateMachine;
import org.jdiameter.server.impl.MutablePeerTableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerImpl
extends org.jdiameter.client.impl.controller.PeerImpl
implements IPeer {
    private static final Logger logger = LoggerFactory.getLogger(PeerImpl.class);
    private MutablePeerTableImpl peerTable;
    protected Set<String> predefinedPeerTable;
    protected INetwork network;
    protected IOverloadManager ovrManager;
    protected ISessionFactory sessionFactory;
    protected boolean isDuplicateProtection;
    protected boolean isAttemptConnection;
    protected boolean isElection = true;
    protected Map<String, IConnection> incConnections;

    public PeerImpl(int rating, URI remotePeer, String ip, String portRange, boolean attCnn, IConnection connection, MutablePeerTableImpl peerTable, IMetaData metaData, Configuration config, Configuration peerConfig, ISessionFactory sessionFactory, IFsmFactory fsmFactory, ITransportLayerFactory trFactory, IStatisticManager statisticFactory, IConcurrentFactory concurrentFactory, IMessageParser parser, INetwork nWork, IOverloadManager oManager, ISessionDatasource sessionDataSource) throws InternalException, TransportException {
        super(peerTable, rating, remotePeer, ip, portRange, metaData, config, peerConfig, fsmFactory, trFactory, parser, statisticFactory, concurrentFactory, connection, sessionDataSource);
        this.peerTable = peerTable;
        this.isDuplicateProtection = this.peerTable.isDuplicateProtection();
        this.sessionFactory = sessionFactory;
        this.isAttemptConnection = attCnn;
        this.incConnections = this.peerTable.getIncConnections();
        this.predefinedPeerTable = this.peerTable.getPredefinedPeerTable();
        this.network = nWork;
        this.ovrManager = oManager;
    }

    @Override
    protected void createPeerStatistics() {
        super.createPeerStatistics();
        if (this.fsm instanceof IStateMachine) {
            StatisticRecord[] records = ((IStateMachine)this.fsm).getStatistic().getRecords();
            IStatisticRecord[] recordsArray = new IStatisticRecord[records.length];
            int count = 0;
            for (StatisticRecord st : records) {
                recordsArray[count++] = (IStatisticRecord)st;
            }
            this.statistic.appendCounter(recordsArray);
        }
    }

    protected void preProcessRequest(IMessage message) {
    }

    @Override
    public boolean isAttemptConnection() {
        return this.isAttemptConnection;
    }

    @Override
    public IContext getContext() {
        return new LocalActionConext();
    }

    @Override
    public IConnection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIncomingConnection(IConnection conn) {
        PeerState state = (PeerState)this.fsm.getState(PeerState.class);
        if (PeerState.DOWN == state || PeerState.INITIAL == state) {
            conn.addConnectionListener(this.connListener);
            this.connection = conn;
            logger.debug("Append external connection [{}]", (Object)conn.getKey());
        } else {
            logger.debug("Releasing connection [{}]", (Object)conn.getKey());
            this.incConnections.remove(conn.getKey());
            try {
                conn.release();
            }
            catch (IOException e) {
                logger.debug("Can not close external connection", (Throwable)e);
            }
            finally {
                logger.debug("Close external connection");
            }
        }
    }

    @Override
    public void setElection(boolean isElection) {
        this.isElection = isElection;
    }

    @Override
    public void notifyOvrManager(IOverloadManager ovrManager) {
        ovrManager.changeNotification(0, this.getUri(), this.fsm.getQueueInfo());
    }

    @Override
    public String toString() {
        if (this.fsm != null) {
            return "SPeer{Uri=" + this.uri + "; State=" + this.fsm.getState(PeerState.class) + "; con=" + this.connection + "; incCon" + this.incConnections + " }";
        }
        return "SPeer{Uri=" + this.uri + "; State=" + this.fsm + "; con=" + this.connection + "; incCon" + this.incConnections + " }";
    }

    static /* synthetic */ IStatistic access$4400(PeerImpl x0) {
        return x0.statistic;
    }

    static /* synthetic */ IStatistic access$4500(PeerImpl x0) {
        return x0.statistic;
    }

    static /* synthetic */ IStatistic access$4600(PeerImpl x0) {
        return x0.statistic;
    }

    static /* synthetic */ IStatistic access$4700(PeerImpl x0) {
        return x0.statistic;
    }

    static /* synthetic */ void access$4800(PeerImpl x0, IRequest x1, String x2, int x3, Avp[] x4) {
        x0.sendErrorAnswer(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$4900(PeerImpl x0, IRequest x1, String x2, int x3, Avp[] x4) {
        x0.sendErrorAnswer(x1, x2, x3, x4);
    }

    static /* synthetic */ IRouter access$5000(PeerImpl x0) {
        return x0.router;
    }

    static /* synthetic */ IStatistic access$5100(PeerImpl x0) {
        return x0.statistic;
    }

    static /* synthetic */ IStatistic access$5200(PeerImpl x0) {
        return x0.statistic;
    }

    static /* synthetic */ void access$5300(PeerImpl x0, IRequest x1, String x2, int x3, Avp[] x4) {
        x0.sendErrorAnswer(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$5400(PeerImpl x0, IRequest x1, String x2, int x3, Avp[] x4) {
        x0.sendErrorAnswer(x1, x2, x3, x4);
    }

    static /* synthetic */ IStatistic access$5500(PeerImpl x0) {
        return x0.statistic;
    }

    static /* synthetic */ IStatistic access$5600(PeerImpl x0) {
        return x0.statistic;
    }

    protected class LocalActionConext
    extends PeerImpl.ActionContext {
        protected LocalActionConext() {
            super(PeerImpl.this);
        }

        @Override
        public void sendCeaMessage(int resultCode, Message cer, String errMessage) throws TransportException, OverloadException {
            logger.debug("Send CEA message");
            IMessage message = PeerImpl.this.parser.createEmptyMessage(257, 0L);
            message.setRequest(false);
            message.setHopByHopIdentifier(cer.getHopByHopIdentifier());
            message.setEndToEndIdentifier(cer.getEndToEndIdentifier());
            message.getAvps().addAvp(264, PeerImpl.this.metaData.getLocalPeer().getUri().getFQDN(), true, false, true);
            message.getAvps().addAvp(296, PeerImpl.this.metaData.getLocalPeer().getRealmName(), true, false, true);
            for (InetAddress ia : PeerImpl.this.metaData.getLocalPeer().getIPAddresses()) {
                message.getAvps().addAvp(257, ia, true, false);
            }
            message.getAvps().addAvp(266, PeerImpl.this.metaData.getLocalPeer().getVendorId(), true, false, true);
            for (ApplicationId appId : PeerImpl.this.metaData.getLocalPeer().getCommonApplications()) {
                this.addAppId(appId, message);
            }
            message.getAvps().addAvp(269, PeerImpl.this.metaData.getLocalPeer().getProductName(), false);
            message.getAvps().addAvp(268, (long)resultCode, true, false, true);
            message.getAvps().addAvp(267, PeerImpl.this.metaData.getLocalPeer().getFirmware(), true);
            if (errMessage != null) {
                message.getAvps().addAvp(281, errMessage, false);
            }
            this.sendMessage(message);
        }

        @Override
        public int processCerMessage(String key, IMessage message) {
            logger.debug("Processing CER");
            int resultCode = 2001;
            try {
                Set newAppId;
                if (PeerImpl.this.connection == null || !PeerImpl.this.connection.isConnected()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Connection is null or not connected. Looking for one in incConnections with key [{}]. Here are the incConnections :", (Object)key);
                        for (String c : PeerImpl.this.incConnections.keySet()) {
                            logger.debug(c);
                        }
                    }
                    PeerImpl.this.connection = PeerImpl.this.incConnections.get(key);
                }
                if ((newAppId = PeerImpl.this.getCommonApplicationIds(message)).isEmpty()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Processing CER failed, no common application. Message AppIds [{}]", (Object)message.getApplicationIdAvps());
                    }
                    return 5010;
                }
                if (!PeerImpl.this.connection.getKey().equals(key)) {
                    logger.debug("CER received by other connection [{}]", (Object)key);
                    switch ((PeerState)PeerImpl.this.fsm.getState(PeerState.class)) {
                        case DOWN: {
                            resultCode = 2001;
                            break;
                        }
                        case INITIAL: {
                            boolean isLocalWin = false;
                            if (PeerImpl.this.isElection) {
                                try {
                                    isLocalWin = PeerImpl.this.metaData.getLocalPeer().getUri().getFQDN().equals(message.getAvps().getAvp(264).getOctetString());
                                }
                                catch (Exception exc) {
                                    isLocalWin = true;
                                }
                            }
                            logger.debug("local peer is win - [{}]", (Object)isLocalWin);
                            resultCode = 0;
                            if (isLocalWin) {
                                IConnection c = PeerImpl.this.incConnections.get(key);
                                c.remConnectionListener(PeerImpl.this.connListener);
                                c.disconnect();
                                PeerImpl.this.incConnections.remove(key);
                                break;
                            }
                            PeerImpl.this.connection.disconnect();
                            PeerImpl.this.connection.remConnectionListener(PeerImpl.this.connListener);
                            PeerImpl.this.connection = PeerImpl.this.incConnections.remove(key);
                            resultCode = 2001;
                        }
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("CER received by current connection, key: [{}] PeerState: [{}] ", (Object)key, PeerImpl.this.fsm.getState(PeerState.class));
                    }
                    if (((PeerState)PeerImpl.this.fsm.getState(PeerState.class)).equals((Object)PeerState.INITIAL)) {
                        resultCode = 0;
                    }
                    PeerImpl.this.incConnections.remove(key);
                }
                if (resultCode == 2001) {
                    PeerImpl.this.commonApplications.clear();
                    PeerImpl.this.commonApplications.addAll(newAppId);
                    PeerImpl.this.fillIPAddressTable(message);
                }
            }
            catch (Exception exc) {
                logger.debug("Can not process CER", (Throwable)exc);
            }
            logger.debug("CER result [{}]", (Object)resultCode);
            return resultCode;
        }

        @Override
        public boolean isRestoreConnection() {
            return PeerImpl.this.isAttemptConnection;
        }

        @Override
        public String getPeerDescription() {
            return PeerImpl.this.toString();
        }

        @Override
        public boolean receiveMessage(IMessage message) {
            logger.debug("Receiving message in server.");
            boolean isProcessed = false;
            if (message.isRequest()) {
                IMessage req = message;
                Avp destRealmAvp = req.getAvps().getAvp(283);
                String destRealm = null;
                if (destRealmAvp == null) {
                    PeerImpl.this.sendErrorAnswer(message, "Missing Destination-Realm AVP", 5005, new Avp[0]);
                    return true;
                }
                try {
                    destRealm = destRealmAvp.getDiameterIdentity();
                }
                catch (AvpDataException ade) {
                    PeerImpl.this.sendErrorAnswer(message, "Failed to parse Destination-Realm AVP", 5004, new Avp[]{destRealmAvp});
                    return true;
                }
                IRealmTable realmTable = PeerImpl.this.router.getRealmTable();
                if (!realmTable.realmExists(destRealm)) {
                    logger.warn("Received a request for an unrecognized realm: [{}]. Answering with 3003 (DIAMETER_REALM_NOT_SERVED) Result-Code.", (Object)destRealm);
                    PeerImpl.this.sendErrorAnswer(message, null, 3003, new Avp[0]);
                    return true;
                }
                ApplicationId appId = message.getSingleApplicationId();
                if (appId == null) {
                    logger.warn("Receive a message with no Application Id. Answering with 5005 (MISSING_AVP) Result-Code.");
                    PeerImpl.this.sendErrorAnswer(message, "Missing Application-Id", 5005, new Avp[0]);
                    return true;
                }
                Avp destHostAvp = req.getAvps().getAvp(293);
                if (destHostAvp != null) {
                    try {
                        String destHost = destHostAvp.getDiameterIdentity();
                        if (destHost.equals(PeerImpl.this.metaData.getLocalPeer().getUri().getFQDN())) {
                            LocalAction action = null;
                            IRealm matched = null;
                            matched = (IRealm)realmTable.matchRealm(req);
                            if (matched == null) {
                                PeerImpl.this.sendErrorAnswer(message, null, 3007, new Avp[0]);
                                return true;
                            }
                            action = matched.getLocalAction();
                            switch (action) {
                                case LOCAL: {
                                    isProcessed = this.consumeMessage(message);
                                    break;
                                }
                                case PROXY: {
                                    if (!this.handleByAgent(message, isProcessed, req, matched)) break;
                                    isProcessed = true;
                                    break;
                                }
                                case RELAY: {
                                    isProcessed = this.consumeMessage(message);
                                    break;
                                }
                                case REDIRECT: {
                                    if (!this.handleByAgent(message, isProcessed, req, matched)) break;
                                    isProcessed = true;
                                }
                            }
                        }
                        IPeer p = (IPeer)PeerImpl.this.peerTable.getPeer(destHost);
                        if (p != null && p.hasValidConnection()) {
                            isProcessed = this.consumeMessage(message);
                        }
                        logger.warn("Received message for unknown peer [{}]. Answering with 3002 (UNABLE_TO_DELIVER) Result-Code.", (Object)destHost);
                        PeerImpl.this.sendErrorAnswer(req, "No connection to peer", 3002, new Avp[0]);
                        isProcessed = true;
                    }
                    catch (AvpDataException ade) {
                        logger.warn("Received message with present but unparsable Destination-Host. Answering with 5004 (INVALID_AVP_VALUE) Result-Code.");
                        PeerImpl.this.sendErrorAnswer(message, "Failed to parse Destination-Host AVP", 5004, new Avp[]{destHostAvp});
                        return true;
                    }
                } else {
                    LocalAction action = null;
                    IRealm matched = null;
                    matched = (IRealm)realmTable.matchRealm(req);
                    if (matched == null) {
                        PeerImpl.this.sendErrorAnswer(message, null, 3007, new Avp[0]);
                        return true;
                    }
                    action = matched.getLocalAction();
                    switch (action) {
                        case LOCAL: {
                            isProcessed = this.consumeMessage(message);
                            break;
                        }
                        case PROXY: {
                            if (!this.handleByAgent(message, isProcessed, req, matched)) break;
                            isProcessed = true;
                            break;
                        }
                        case RELAY: {
                            isProcessed = this.consumeMessage(message);
                            break;
                        }
                        case REDIRECT: {
                            if (!this.handleByAgent(message, isProcessed, req, matched)) break;
                            isProcessed = true;
                        }
                    }
                }
            } else {
                isProcessed = super.receiveMessage(message);
            }
            return isProcessed;
        }

        private boolean handleByAgent(IMessage message, boolean isProcessed, IRequest req, IRealm matched) {
            if (PeerImpl.this.ovrManager != null && PeerImpl.this.ovrManager.isParenAppOverload(message.getSingleApplicationId())) {
                logger.debug("Request [{}] skipped, because server application is overloaded", (Object)message);
                PeerImpl.this.sendErrorAnswer(message, "Overloaded", 3004, new Avp[0]);
                return true;
            }
            try {
                PeerImpl.this.router.registerRequestRouteInfo(message);
                IMessage answer = (IMessage)matched.getAgent().processRequest(req, matched);
                if (PeerImpl.this.isDuplicateProtection && answer != null) {
                    PeerImpl.this.peerTable.saveToDuplicate(message.getDuplicationKey(), answer);
                }
                isProcessed = true;
                if (answer != null) {
                    this.sendMessage(answer);
                }
                if (PeerImpl.this.statistic.isEnabled()) {
                    PeerImpl.this.statistic.getRecordByName(IStatisticRecord.Counters.SysGenResponse.name()).inc();
                }
            }
            catch (Exception exc) {
                logger.warn("Error during processing message by " + matched.getAgent().getClass(), (Throwable)exc);
                PeerImpl.this.sendErrorAnswer(message, "Unable to process", 5012, new Avp[0]);
                return true;
            }
            if (isProcessed && PeerImpl.this.statistic.isEnabled()) {
                PeerImpl.this.statistic.getRecordByName(IStatisticRecord.Counters.NetGenRequest.name()).inc();
            }
            return isProcessed;
        }

        /*
         * Unable to fully structure code
         */
        private boolean consumeMessage(IMessage message) {
            PeerImpl.access$000().debug("In Server consumeMessage. Going to call parents class receiveMessage");
            isProcessed = super.receiveMessage(message);
            PeerImpl.access$000().debug("Did client PeerImpl process the message? [{}]", (Object)isProcessed);
            answer = null;
            if (!isProcessed) {
                if (PeerImpl.access$4400(PeerImpl.this).isEnabled()) {
                    PeerImpl.access$4500(PeerImpl.this).getRecordByName(IStatisticRecord.Counters.NetGenRejectedRequest.name()).dec();
                }
                if ((listener = PeerImpl.this.network.getListener(message)) != null) {
                    if (PeerImpl.access$000().isDebugEnabled()) {
                        PeerImpl.access$000().debug("We have found an application that is a listener for this message. It is [{}]", (Object)listener.getClass().getName());
                    }
                    if (PeerImpl.this.isDuplicateProtection) {
                        PeerImpl.access$000().debug("Checking if it's a duplicate, since duplicate protection is ENABLED.");
                        answer = PeerImpl.access$3300(PeerImpl.this).isDuplicate(message);
                    }
                    if (answer != null) {
                        PeerImpl.access$000().debug("This message was detected as being a duplicate");
                        answer.setProxiable(message.isProxiable());
                        answer.getAvps().removeAvp(284);
                        for (Avp avp : message.getAvps().getAvps(284)) {
                            answer.getAvps().addAvp(new Avp[]{avp});
                        }
                        answer.setHopByHopIdentifier(message.getHopByHopIdentifier());
                        isProcessed = true;
                        try {
                            this.sendMessage(answer);
                            if (!PeerImpl.access$4600(PeerImpl.this).isEnabled()) ** GOTO lbl56
                            PeerImpl.access$4700(PeerImpl.this).getRecordByName(IStatisticRecord.Counters.SysGenResponse.name()).inc();
                        }
                        catch (Exception e) {
                            PeerImpl.access$000().warn("Error during processing message by duplicate protection", (Throwable)e);
                            PeerImpl.access$4800(PeerImpl.this, message, "Unable to process", 5012, new Avp[0]);
                            return true;
                        }
                    } else {
                        if (PeerImpl.this.ovrManager != null && PeerImpl.this.ovrManager.isParenAppOverload(message.getSingleApplicationId())) {
                            PeerImpl.access$000().debug("Request [{}] skipped, because server application is overloaded", (Object)message);
                            PeerImpl.access$4900(PeerImpl.this, message, "Overloaded", 3004, new Avp[0]);
                            return true;
                        }
                        try {
                            PeerImpl.access$5000(PeerImpl.this).registerRequestRouteInfo(message);
                            answer = (IMessage)listener.processRequest((Request)message);
                            if (PeerImpl.this.isDuplicateProtection && answer != null) {
                                PeerImpl.access$3300(PeerImpl.this).saveToDuplicate(message.getDuplicationKey(), answer);
                            }
                            if ((isProcessed = true) && answer != null) {
                                this.sendMessage(answer);
                            }
                            if (!PeerImpl.access$5100(PeerImpl.this).isEnabled()) ** GOTO lbl56
                            PeerImpl.access$5200(PeerImpl.this).getRecordByName(IStatisticRecord.Counters.AppGenResponse.name()).inc();
                        }
                        catch (Exception exc) {
                            PeerImpl.access$000().warn("Error during processing message by listener", (Throwable)exc);
                            PeerImpl.access$5300(PeerImpl.this, message, "Unable to process", 5012, new Avp[0]);
                            return true;
                        }
                    }
                } else {
                    PeerImpl.access$000().warn("Received message for unsupported Application-Id [{}]", (Object)message.getSingleApplicationId());
                    PeerImpl.access$5400(PeerImpl.this, message, "Unsupported Application-Id", 3007, new Avp[0]);
                    return true;
                }
            }
lbl56:
            // 6 sources

            if (isProcessed && PeerImpl.access$5500(PeerImpl.this).isEnabled()) {
                PeerImpl.access$5600(PeerImpl.this).getRecordByName(IStatisticRecord.Counters.NetGenRequest.name()).inc();
            }
            return isProcessed;
        }

        @Override
        public String toString() {
            return new StringBuffer("LocalActionConext [isRestoreConnection()=").append(this.isRestoreConnection()).append(", getPeerDescription()=").append(this.getPeerDescription()).append(", isConnected()=").append(this.isConnected()).append(", LocalPeer=").append(PeerImpl.this.metaData.getLocalPeer().getUri()).append(" ]").toString();
        }
    }
}

