/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.OverloadListener;
import org.jdiameter.api.URI;
import org.jdiameter.server.api.IOverloadManager;
import org.jdiameter.server.impl.helpers.Parameters;

public class OverloadManagerImpl
implements IOverloadManager {
    private ConcurrentLinkedQueue<OverloadInfo> listeners = new ConcurrentLinkedQueue();
    private ConcurrentHashMap<Object, AppOverloadInfo> appInfo = new ConcurrentHashMap();

    public OverloadManagerImpl(Configuration config) {
        Configuration[] entries = config.getChildren(Parameters.OverloadMonitor.ordinal());
        if (entries == null) {
            return;
        }
        for (Configuration e : entries) {
            ApplicationId appId = null;
            int i$ = 0;
            Configuration[] cAppId = e.getChildren(org.jdiameter.client.impl.helpers.Parameters.ApplicationId.ordinal());
            Configuration[] arr$ = cAppId;
            int len$ = arr$.length;
            if (i$ < len$) {
                Configuration i = arr$[i$];
                appId = i.getLongValue(org.jdiameter.client.impl.helpers.Parameters.AuthApplId.ordinal(), 0L) != 0L ? ApplicationId.createByAuthAppId((long)i.getLongValue(org.jdiameter.client.impl.helpers.Parameters.VendorId.ordinal(), 0L), (long)i.getLongValue(org.jdiameter.client.impl.helpers.Parameters.AuthApplId.ordinal(), 0L)) : ApplicationId.createByAccAppId((long)i.getLongValue(org.jdiameter.client.impl.helpers.Parameters.VendorId.ordinal(), 0L), (long)i.getLongValue(org.jdiameter.client.impl.helpers.Parameters.AcctApplId.ordinal(), 0L));
            }
            if (appId == null) continue;
            AppOverloadInfo info = new AppOverloadInfo(appId);
            info.appendEntry(e.getIntValue(Parameters.OverloadEntryIndex.ordinal(), 0), e.getDoubleValue(Parameters.OverloadEntrylowThreshold.ordinal(), 0.0), e.getDoubleValue(Parameters.OverloadEntryhighThreshold.ordinal(), 0.0));
            this.appInfo.put(appId, info);
        }
    }

    public void parentAppOverloadDetected(ApplicationId applicationId, int type, double value) {
        AppOverloadInfo app = this.appInfo.get(this.createKey(applicationId));
        if (app != null) {
            app.updateInformation(type, value);
        }
    }

    public void parentAppOverloadCeased(ApplicationId applicationId, int type) {
        AppOverloadInfo app = this.appInfo.get(this.createKey(applicationId));
        if (app != null) {
            app.updateInformation(type, 0.0);
        }
    }

    private Object createKey(final ApplicationId appId) {
        return new Object(){

            public int hashCode() {
                return appId.hashCode();
            }

            public boolean equals(Object obj) {
                return appId.equals(obj);
            }
        };
    }

    @Override
    public boolean isParenAppOverload(ApplicationId appId) {
        if (appId == null) {
            return false;
        }
        AppOverloadInfo app = this.appInfo.get(this.createKey(appId));
        return app != null && app.isOverload();
    }

    @Override
    public boolean isParenAppOverload(ApplicationId appId, int type) {
        AppOverloadInfo app = this.appInfo.get(this.createKey(appId));
        return app != null && app.isOverload(type);
    }

    public void addOverloadListener(OverloadListener overloadListener, double lowThreshold, double highThreshold, int qIndex) {
        this.listeners.add(new OverloadInfo(overloadListener, lowThreshold, highThreshold, qIndex));
    }

    public void removeOverloadListener(OverloadListener overloadListener, int qIndex) {
        this.listeners.remove(new OverloadInfo(overloadListener, qIndex));
    }

    @Override
    public void changeNotification(int index, URI uri, double value) {
        for (OverloadInfo e : this.listeners) {
            if (e.getCode() != index) continue;
            e.changeNotification(uri, value);
        }
    }

    public static class OverloadInfo {
        private OverloadListener overloadListener;
        private double lowThreshold;
        private double highThreshold;
        private int qIndex;
        private boolean isOverload;
        private Lock lock = new ReentrantLock();

        public OverloadInfo(OverloadListener overloadListener, int qIndex) {
            this.overloadListener = overloadListener;
            this.qIndex = qIndex;
        }

        public OverloadInfo(OverloadListener overloadListener, double lowThreshold, double highThreshold, int qIndex) {
            this.overloadListener = overloadListener;
            this.lowThreshold = lowThreshold;
            this.highThreshold = highThreshold;
            this.qIndex = qIndex;
        }

        public void changeNotification(URI uri, double value) {
            if (value >= this.lowThreshold && value <= this.highThreshold) {
                this.overloadListener.overloadDetected(uri, value);
                this.lock.lock();
                this.isOverload = true;
                this.lock.unlock();
            } else {
                this.lock.lock();
                if (this.isOverload) {
                    this.overloadListener.overloadCeased(uri);
                    this.isOverload = false;
                }
                this.lock.unlock();
            }
        }

        public int getCode() {
            return this.qIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OverloadInfo that = (OverloadInfo)o;
            if (this.qIndex != that.qIndex) {
                return false;
            }
            return !(this.overloadListener != null ? !this.overloadListener.equals(that.overloadListener) : that.overloadListener != null);
        }

        public int hashCode() {
            int result = this.overloadListener != null ? this.overloadListener.hashCode() : 0;
            result = 31 * result + this.qIndex;
            return result;
        }
    }

    public static class AppOverloadInfoEntry {
        private int type;
        private double lowThreshold;
        private double highThreshold;
        private double currentValue;
        private final Object lock = new Object();

        public AppOverloadInfoEntry(int type, double lowThreshold, double highThreshold) {
            this.type = type;
            this.lowThreshold = lowThreshold;
            this.highThreshold = highThreshold;
        }

        public int getType() {
            return this.type;
        }

        public double getLowThreshold() {
            return this.lowThreshold;
        }

        public double getHighThreshold() {
            return this.highThreshold;
        }

        public double getCurrentValue() {
            return this.currentValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateInformation(double threshold) {
            Object object = this.lock;
            synchronized (object) {
                this.currentValue = threshold;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isOverload() {
            Object object = this.lock;
            synchronized (object) {
                return this.currentValue >= this.lowThreshold && this.currentValue <= this.highThreshold;
            }
        }
    }

    public static class AppOverloadInfo {
        private ApplicationId appId;
        private ArrayList<AppOverloadInfoEntry> entries = new ArrayList();
        private final Object lock = new Object();

        public ApplicationId getAppId() {
            return this.appId;
        }

        public AppOverloadInfo(ApplicationId appId) {
            this.appId = appId;
        }

        public void appendEntry(int type, double lowThreshold, double highThreshold) {
            this.entries.add(new AppOverloadInfoEntry(type, lowThreshold, highThreshold));
        }

        public boolean isOverload() {
            for (AppOverloadInfoEntry e : this.entries) {
                if (!e.isOverload()) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isOverload(int type) {
            for (AppOverloadInfoEntry e : this.entries) {
                if (e.getType() != type) continue;
                Object object = this.lock;
                synchronized (object) {
                    if (e.isOverload()) {
                        return true;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateInformation(int type, double threshold) {
            for (AppOverloadInfoEntry e : this.entries) {
                if (e.getType() != type) continue;
                Object object = this.lock;
                synchronized (object) {
                    e.updateInformation(threshold);
                }
            }
        }
    }
}

