/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Session;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.client.api.IAssembler;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.IAppSessionData;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.jdiameter.common.api.timer.ITimerFacility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AppSessionImpl
implements AppSession {
    private static final Logger logger = LoggerFactory.getLogger(AppSessionImpl.class);
    protected IAppSessionData appSessionData;
    protected List<Session> sessions;
    protected Session session;
    protected ISessionFactory sf = null;
    protected ScheduledExecutorService scheduler = null;
    protected ITimerFacility timerFacility;

    public AppSessionImpl(ISessionFactory sf, IAppSessionData appSessionData) {
        if (sf == null) {
            throw new IllegalArgumentException("SessionFactory must not be null");
        }
        if (appSessionData == null) {
            throw new IllegalArgumentException("IAppSessionData must not be null");
        }
        try {
            this.sf = sf;
            this.appSessionData = appSessionData;
            IAssembler assembler = this.sf.getContainer().getAssemblerFacility();
            this.scheduler = assembler.getComponentInstance(IConcurrentFactory.class).getScheduledExecutorService(IConcurrentFactory.ScheduledExecServices.ApplicationSession.name());
            this.timerFacility = assembler.getComponentInstance(ITimerFacility.class);
            this.session = this.sf.getNewSession(this.appSessionData.getSessionId());
            ArrayList<Session> list = new ArrayList<Session>();
            list.add(this.session);
            this.sessions = Collections.unmodifiableList(list);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public long getCreationTime() {
        return this.session.getCreationTime();
    }

    public long getLastAccessedTime() {
        return this.session.getLastAccessedTime();
    }

    public boolean isValid() {
        return this.session == null ? false : this.session.isValid();
    }

    public ApplicationId getSessionAppId() {
        return this.appSessionData.getApplicationId();
    }

    public List<Session> getSessions() {
        return this.sessions;
    }

    public void release() {
        logger.debug("Releasing application session for Session ID '{}' ({}).", (Object)this.getSessionId(), (Object)this.getSessionAppId());
        this.session.setRequestListener(null);
        this.session.release();
        this.appSessionData.remove();
    }

    public String getSessionId() {
        return this.session.getSessionId();
    }

    public boolean isAppSession() {
        return true;
    }

    public boolean isReplicable() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appSessionData == null ? 0 : this.appSessionData.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppSessionImpl other = (AppSessionImpl)obj;
        return !(this.appSessionData == null ? other.appSessionData != null : !this.appSessionData.equals(other.appSessionData));
    }

    public abstract void onTimer(String var1);
}

