/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app;

import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.app.AppEvent;

public class AppEventImpl
implements AppEvent {
    private static final long serialVersionUID = 1L;
    protected Message message;

    public AppEventImpl(Message message) {
        this.message = message;
    }

    public int getCommandCode() {
        return this.message.getCommandCode();
    }

    public Message getMessage() throws InternalException {
        return this.message;
    }

    public String getOriginHost() throws AvpDataException {
        Avp originHostAvp = this.message.getAvps().getAvp(264);
        if (originHostAvp != null) {
            return originHostAvp.getDiameterIdentity();
        }
        throw new AvpDataException("Avp ORIGIN_HOST not found");
    }

    public String getOriginRealm() throws AvpDataException {
        Avp originRealmAvp = this.message.getAvps().getAvp(296);
        if (originRealmAvp != null) {
            return originRealmAvp.getDiameterIdentity();
        }
        throw new AvpDataException("Avp ORIGIN_REALM not found");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppEventImpl that = (AppEventImpl)o;
        return this.message.equals(that.message);
    }

    public int hashCode() {
        return this.message.hashCode();
    }

    public String toString() {
        return this.message != null ? this.message.toString() : "empty";
    }
}

