/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.transport.tls.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.impl.transport.tls.netty.TLSClientConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiameterMessageHandler
extends ChannelInboundHandlerAdapter {
    protected static final Logger logger = LoggerFactory.getLogger(DiameterMessageHandler.class);
    protected final TLSClientConnection parentConnection;
    protected boolean autoRelease;

    public DiameterMessageHandler(TLSClientConnection parentConnection, boolean autoRelease) {
        this.parentConnection = parentConnection;
        this.autoRelease = autoRelease;
    }

    public void setAutoRelease(boolean autoRelease) {
        this.autoRelease = autoRelease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof IMessage) {
            IMessage m = (IMessage)msg;
            logger.debug("Received message {} TLS Transport {}", (Object)m.getCommandCode(), (Object)this.parentConnection.getKey());
            try {
                logger.debug("Passing message on to parent {}", (Object)this.parentConnection.getKey());
                this.parentConnection.onMessageReceived(m);
                logger.debug("Finished passing message on to parent {}", (Object)this.parentConnection.getKey());
            }
            catch (AvpDataException e) {
                logger.debug("Garbage was received. Discarding. {}", (Object)this.parentConnection.getKey());
                this.parentConnection.onAvpDataException(e);
            }
            finally {
                if (this.autoRelease) {
                    ReferenceCountUtil.release((Object)msg);
                } else {
                    ctx.fireChannelRead((Object)m);
                }
            }
        }
    }
}

