/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.transport.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.client.api.io.NotInitializedException;
import org.jdiameter.client.impl.transport.tcp.TCPClientConnection;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPTransportClient
implements Runnable {
    private TCPClientConnection parentConnection;
    private IConcurrentFactory concurrentFactory;
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final int DEFAULT_STORAGE_SIZE = 2048;
    protected boolean stop = false;
    protected Thread selfThread;
    protected int bufferSize = 1024;
    protected ByteBuffer buffer = ByteBuffer.allocate(this.bufferSize);
    protected InetSocketAddress destAddress;
    protected InetSocketAddress origAddress;
    protected SocketChannel socketChannel;
    protected Lock lock = new ReentrantLock();
    protected int storageSize = 2048;
    protected ByteBuffer storage = ByteBuffer.allocate(this.storageSize);
    private String socketDescription = null;
    private static final Logger logger = LoggerFactory.getLogger(TCPTransportClient.class);
    private static final boolean BLOCKING_IO = false;
    private static final long SELECT_TIMEOUT = 500L;

    public TCPTransportClient() {
    }

    TCPTransportClient(IConcurrentFactory concurrentFactory, TCPClientConnection parenConnection) {
        this.parentConnection = parenConnection;
        this.concurrentFactory = concurrentFactory;
    }

    public void initialize() throws IOException, NotInitializedException {
        logger.debug("Initialising TCPTransportClient. Origin address is [{}] and destination address is [{}]", (Object)this.origAddress, (Object)this.destAddress);
        if (this.destAddress == null) {
            throw new NotInitializedException("Destination address is not set");
        }
        this.socketChannel = SelectorProvider.provider().openSocketChannel();
        if (this.origAddress != null) {
            this.socketChannel.socket().bind(this.origAddress);
        }
        this.socketChannel.connect(this.destAddress);
        this.socketChannel.configureBlocking(false);
        this.getParent().onConnected();
    }

    public TCPClientConnection getParent() {
        return this.parentConnection;
    }

    public void initialize(Socket socket) throws IOException, NotInitializedException {
        logger.debug("Initialising TCPTransportClient for a socket on [{}]", (Object)socket);
        this.socketDescription = socket.toString();
        this.socketChannel = socket.getChannel();
        this.socketChannel.configureBlocking(false);
        this.destAddress = new InetSocketAddress(socket.getInetAddress(), socket.getPort());
    }

    public void start() throws NotInitializedException {
        if (this.socketDescription == null && this.socketChannel != null) {
            this.socketDescription = this.socketChannel.socket().toString();
        }
        logger.debug("Starting transport. Socket is {}", (Object)this.socketDescription);
        if (this.socketChannel == null) {
            throw new NotInitializedException("Transport is not initialized");
        }
        if (!this.socketChannel.isConnected()) {
            throw new NotInitializedException("Socket channel is not connected");
        }
        if (this.getParent() == null) {
            throw new NotInitializedException("No parent connection is set is set");
        }
        if (this.selfThread == null || !this.selfThread.isAlive()) {
            this.selfThread = this.concurrentFactory.getThread("TCPReader", this);
        }
        if (!this.selfThread.isAlive()) {
            this.selfThread.setDaemon(true);
            this.selfThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int sleepTime = 250;
        logger.debug("Sleeping for {}ms before starting transport so that listeners can all be added and ready for messages", (Object)sleepTime);
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        logger.debug("Finished sleeping for {}ms. By now, MutablePeerTableImpl should have added its listener", (Object)sleepTime);
        logger.debug("Transport is started. Socket is [{}]", (Object)this.socketDescription);
        Selector selector = null;
        try {
            selector = Selector.open();
            this.socketChannel.register(selector, 1);
            block21: while (!this.stop) {
                selector.select(500L);
                Iterator<SelectionKey> it = selector.selectedKeys().iterator();
                while (it.hasNext()) {
                    SelectionKey selKey = it.next();
                    it.remove();
                    if (!selKey.isValid() || !selKey.isReadable()) continue;
                    SocketChannel sChannel = (SocketChannel)selKey.channel();
                    int dataLength = sChannel.read(this.buffer);
                    logger.debug("Just read [{}] bytes on [{}]", (Object)dataLength, (Object)this.socketDescription);
                    if (dataLength == -1) {
                        this.stop = true;
                        continue block21;
                    }
                    this.buffer.flip();
                    byte[] data = new byte[this.buffer.limit()];
                    this.buffer.get(data);
                    this.append(data);
                    this.buffer.clear();
                }
            }
        }
        catch (ClosedByInterruptException e) {
            logger.error("Transport exception ", (Throwable)e);
        }
        catch (AsynchronousCloseException e) {
            logger.error("Transport is closed");
        }
        catch (Throwable e) {
            logger.error("Transport exception ", e);
        }
        finally {
            try {
                this.clearBuffer();
                if (selector != null) {
                    selector.close();
                }
                if (this.socketChannel != null && this.socketChannel.isOpen()) {
                    this.socketChannel.close();
                }
                this.getParent().onDisconnect();
            }
            catch (Exception e) {
                logger.error("Error", (Throwable)e);
            }
            this.stop = false;
            logger.info("Read thread is stopped for socket [{}]", (Object)this.socketDescription);
        }
    }

    public void stop() throws Exception {
        logger.debug("Stopping transport. Socket is [{}]", (Object)this.socketDescription);
        this.stop = true;
        if (this.socketChannel != null && this.socketChannel.isOpen()) {
            this.socketChannel.close();
        }
        if (this.selfThread != null) {
            this.selfThread.join(100L);
        }
        this.clearBuffer();
        logger.debug("Transport is stopped. Socket is [{}]", (Object)this.socketDescription);
    }

    public void release() throws Exception {
        this.stop();
        this.destAddress = null;
    }

    private void clearBuffer() throws IOException {
        this.bufferSize = 1024;
        this.buffer = ByteBuffer.allocate(this.bufferSize);
    }

    public InetSocketAddress getDestAddress() {
        return this.destAddress;
    }

    public void setDestAddress(InetSocketAddress address) {
        this.destAddress = address;
        if (logger.isDebugEnabled()) {
            logger.debug("Destination address is set to [{}] : [{}]", (Object)this.destAddress.getHostName(), (Object)this.destAddress.getPort());
        }
    }

    public void setOrigAddress(InetSocketAddress address) {
        this.origAddress = address;
        if (logger.isDebugEnabled()) {
            logger.debug("Origin address is set to [{}] : [{}]", (Object)this.origAddress.getHostName(), (Object)this.origAddress.getPort());
        }
    }

    public InetSocketAddress getOrigAddress() {
        return this.origAddress;
    }

    public void sendMessage(ByteBuffer bytes) throws IOException {
        int rc;
        if (logger.isDebugEnabled()) {
            logger.debug("About to send a byte buffer of size [{}] over the TCP nio socket [{}]", (Object)bytes.array().length, (Object)this.socketDescription);
        }
        this.lock.lock();
        try {
            for (rc = 0; rc < bytes.array().length; rc += this.socketChannel.write(bytes)) {
            }
        }
        catch (Exception e) {
            logger.error("Unable to send message", (Throwable)e);
            throw new IOException("Error while sending message: " + e);
        }
        finally {
            this.lock.unlock();
        }
        if (rc == -1) {
            throw new IOException("Connection closed");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Sent a byte buffer of size [{}] over the TCP nio socket [{}]", (Object)bytes.array().length, (Object)this.socketDescription);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Transport to ");
        if (this.destAddress != null) {
            buffer.append(this.destAddress.getHostName());
            buffer.append(":");
            buffer.append(this.destAddress.getPort());
        } else {
            buffer.append("null");
        }
        buffer.append("@");
        buffer.append(super.toString());
        return buffer.toString();
    }

    boolean isConnected() {
        return this.socketChannel != null && this.socketChannel.isOpen() && this.socketChannel.isConnected();
    }

    private void append(byte[] data) {
        boolean messageReceived;
        if (this.storage.position() + data.length >= this.storage.capacity()) {
            ByteBuffer tmp = ByteBuffer.allocate(this.storage.limit() + data.length * 2);
            byte[] tmpData = new byte[this.storage.position()];
            this.storage.flip();
            this.storage.get(tmpData);
            tmp.put(tmpData);
            this.storage = tmp;
            logger.warn("Increase storage size. Current size is {}", (Object)this.storage.array().length);
        }
        try {
            this.storage.put(data);
        }
        catch (BufferOverflowException boe) {
            logger.error("Buffer overflow occured", (Throwable)boe);
        }
        while (messageReceived = this.seekMessage()) {
        }
    }

    private boolean seekMessage() {
        if (this.storage.position() == 0) {
            return false;
        }
        this.storage.flip();
        try {
            int tmp = this.storage.getInt();
            this.storage.position(0);
            byte vers = (byte)(tmp >> 24);
            if (vers != 1) {
                this.storage.clear();
                return false;
            }
            int messageLength = tmp & 0xFFFFFF;
            if (this.storage.limit() < messageLength) {
                this.storage.position(this.storage.limit());
                this.storage.limit(this.storage.capacity());
                logger.debug("Received partial message, waiting for remaining (expected: {} bytes, got {} bytes).", (Object)messageLength, (Object)this.storage.position());
                return false;
            }
            byte[] data = new byte[messageLength];
            this.storage.get(data);
            this.storage.compact();
            try {
                logger.debug("Passing message on to parent");
                this.getParent().onMessageReceived(ByteBuffer.wrap(data));
                logger.debug("Finished passing message on to parent");
            }
            catch (AvpDataException e) {
                logger.debug("Garbage was received. Discarding.");
                this.storage.clear();
                this.getParent().onAvpDataException(e);
            }
        }
        catch (BufferUnderflowException bue) {
            this.storage.position(this.storage.limit());
            this.storage.limit(this.storage.capacity());
            logger.debug("Buffer underflow occured, waiting for more data.", (Throwable)bue);
            return false;
        }
        return true;
    }
}

