/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl;

import java.util.concurrent.TimeUnit;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.RawSession;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.IRequest;
import org.jdiameter.client.api.ISession;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.impl.BaseSessionImpl;
import org.jdiameter.client.impl.MessageUtility;
import org.jdiameter.client.impl.RawSessionImpl;
import org.jdiameter.common.api.data.ISessionDatasource;

public class SessionImpl
extends BaseSessionImpl
implements ISession {
    SessionImpl(IContainer container) {
        this.setContainer(container);
        try {
            this.sessionId = container.getSessionFactory().getSessionId();
        }
        catch (IllegalDiameterStateException idse) {
            throw new IllegalStateException("Unable to generate Session-Id", idse);
        }
    }

    void setContainer(IContainer container) {
        this.container = container;
        this.parser = container.getAssemblerFacility().getComponentInstance(IMessageParser.class);
    }

    public void send(Message message, EventListener<Request, Answer> listener) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.genericSend(message, listener);
    }

    public void send(Message message, EventListener<Request, Answer> listener, long timeout, TimeUnit timeUnit) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.genericSend(message, listener, timeout, timeUnit);
    }

    public void setRequestListener(NetworkReqListener listener) {
        if (listener != null) {
            this.reqListener = listener;
            this.container.addSessionListener(this.sessionId, listener);
        }
    }

    @Override
    public NetworkReqListener getReqListener() {
        return this.reqListener;
    }

    public Request createRequest(int commandCode, ApplicationId appId, String destRealm) {
        if (this.isValid) {
            this.lastAccessedTime = System.currentTimeMillis();
            IRequest m = (IRequest)this.parser.createEmptyMessage(IRequest.class, commandCode, this.getAppId(appId));
            m.setNetworkRequest(false);
            m.setRequest(true);
            m.getAvps().addAvp(263, this.sessionId, true, false, false);
            this.appendAppId(appId, (Message)m);
            if (destRealm != null) {
                m.getAvps().addAvp(283, destRealm, true, false, true);
            }
            MessageUtility.addOriginAvps((Message)m, this.container.getMetaData());
            return m;
        }
        throw new IllegalStateException("Session already released");
    }

    public Request createRequest(int commandCode, ApplicationId appId, String destRealm, String destHost) {
        if (this.isValid) {
            this.lastAccessedTime = System.currentTimeMillis();
            IRequest m = (IRequest)this.parser.createEmptyMessage(IRequest.class, commandCode, this.getAppId(appId));
            m.setNetworkRequest(false);
            m.setRequest(true);
            m.getAvps().addAvp(263, this.sessionId, true, false, false);
            this.appendAppId(appId, (Message)m);
            if (destRealm != null) {
                m.getAvps().addAvp(283, destRealm, true, false, true);
            }
            if (destHost != null) {
                m.getAvps().addAvp(293, destHost, true, false, true);
            }
            MessageUtility.addOriginAvps((Message)m, this.container.getMetaData());
            return m;
        }
        throw new IllegalStateException("Session already released");
    }

    public Request createRequest(Request prevRequest) {
        if (this.isValid) {
            this.lastAccessedTime = System.currentTimeMillis();
            IRequest request = (IRequest)this.parser.createEmptyMessage(Request.class, (IMessage)prevRequest);
            request.setRequest(true);
            request.setNetworkRequest(false);
            MessageUtility.addOriginAvps((Message)request, this.container.getMetaData());
            return request;
        }
        throw new IllegalStateException("Session already released");
    }

    public void release() {
        this.isValid = false;
        if (this.container != null) {
            this.container.removeSessionListener(this.sessionId);
            this.container.getAssemblerFacility().getComponentInstance(ISessionDatasource.class).removeSession(this.sessionId);
        }
        this.container = null;
        this.parser = null;
        this.reqListener = null;
    }

    public boolean isWrapperFor(Class<?> iface) throws InternalException {
        return iface == RawSession.class;
    }

    public <T> T unwrap(Class<T> iface) throws InternalException {
        return (T)(iface == RawSession.class ? new RawSessionImpl(this.container) : null);
    }
}

