/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.io.tcp.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.impl.transport.tcp.netty.TCPClientConnection;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.jdiameter.server.api.IMetaData;
import org.jdiameter.server.api.io.INetworkConnectionListener;
import org.jdiameter.server.api.io.INetworkGuard;
import org.jdiameter.server.impl.helpers.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkGuard
implements INetworkGuard {
    private static final Logger logger = LoggerFactory.getLogger(NetworkGuard.class);
    protected CopyOnWriteArrayList<INetworkConnectionListener> listeners = new CopyOnWriteArrayList();
    protected IMessageParser parser;
    protected int port;
    protected InetAddress[] localAddresses;
    protected long bindDelay;
    protected final EventLoopGroup bossGroup = new NioEventLoopGroup();
    protected final EventLoopGroup workerGroup = new NioEventLoopGroup();
    protected List<Channel> channels = new CopyOnWriteArrayList<Channel>();
    protected final ScheduledExecutorService binderExecutor = Executors.newSingleThreadScheduledExecutor();
    Runnable binderTask = new Runnable(){

        public void run() {
            NetworkGuard.this.bindAll();
        }
    };

    private void bindAll() {
        for (int i = 0; i < this.localAddresses.length; ++i) {
            this.bind(new InetSocketAddress(this.localAddresses[i], this.port));
        }
    }

    private void bind(InetSocketAddress localAddress) {
        logger.debug("Binding to socket [{}]", (Object)localAddress);
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ClientHandler()});
            }
        }).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        try {
            this.channels.add(bootstrap.bind((SocketAddress)localAddress).sync().channel());
            logger.debug("Bound to socket [{}]", (Object)localAddress);
        }
        catch (InterruptedException e) {
            logger.error("Failed to bind to socket " + localAddress, (Throwable)e);
        }
    }

    @Deprecated
    public NetworkGuard(InetAddress inetAddress, int port, IMessageParser parser) throws Exception {
        this(inetAddress, port, null, parser, null);
    }

    public NetworkGuard(InetAddress inetAddress, int port, IConcurrentFactory concurrentFactory, IMessageParser parser, IMetaData data) throws Exception {
        this(new InetAddress[]{inetAddress}, port, concurrentFactory, parser, data);
    }

    public NetworkGuard(InetAddress[] inetAddress, int port, IConcurrentFactory concurrentFactory, IMessageParser parser, IMetaData data) throws Exception {
        this.parser = parser;
        this.localAddresses = inetAddress;
        this.port = port;
        this.bindDelay = data.getConfiguration().getLongValue(Parameters.BindDelay.ordinal(), ((Long)Parameters.BindDelay.defValue()).longValue());
        this.binderExecutor.schedule(this.binderTask, this.bindDelay, TimeUnit.MILLISECONDS);
    }

    public void addListener(INetworkConnectionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void remListener(INetworkConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        return "NetworkGuard:" + (this.localAddresses.length != 0 ? this.localAddresses : "closed");
    }

    public void destroy() {
        logger.debug("Destroying network guard");
        this.closeChannels();
        this.closeWorkerGroup();
        this.closeBossGroup();
        this.binderExecutor.shutdown();
    }

    private void closeWorkerGroup() {
        try {
            this.workerGroup.shutdownGracefully().sync();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void closeBossGroup() {
        try {
            this.bossGroup.shutdownGracefully().sync();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void closeChannels() {
        for (Channel channel : this.channels) {
            try {
                logger.debug("Closing channel on socket [{}]", (Object)channel.localAddress());
                channel.close().sync();
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public class ClientHandler
    extends ChannelInboundHandlerAdapter {
        public void channelActive(ChannelHandlerContext ctx) {
            logger.debug("Received connection on socket [{}] from [{}]", (Object)ctx.channel().localAddress(), (Object)ctx.channel().remoteAddress());
            TCPClientConnection client = new TCPClientConnection(ctx.channel(), NetworkGuard.this.parser);
            for (INetworkConnectionListener listener : NetworkGuard.this.listeners) {
                listener.newNetworkConnection(client);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            logger.error(cause.getMessage(), cause);
        }
    }
}

