/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.app.ro;

import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.Answer;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.auth.events.ReAuthAnswer;
import org.jdiameter.api.auth.events.ReAuthRequest;
import org.jdiameter.api.ro.ServerRoSession;
import org.jdiameter.api.ro.ServerRoSessionListener;
import org.jdiameter.api.ro.events.RoCreditControlAnswer;
import org.jdiameter.api.ro.events.RoCreditControlRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.ro.IRoMessageFactory;
import org.jdiameter.common.api.app.ro.IServerRoSessionContext;
import org.jdiameter.common.api.app.ro.ServerRoSessionState;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.auth.ReAuthAnswerImpl;
import org.jdiameter.common.impl.app.auth.ReAuthRequestImpl;
import org.jdiameter.common.impl.app.ro.AppRoSessionImpl;
import org.jdiameter.server.impl.app.ro.Event;
import org.jdiameter.server.impl.app.ro.IServerRoSessionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerRoSessionImpl
extends AppRoSessionImpl
implements ServerRoSession,
NetworkReqListener,
EventListener<Request, Answer> {
    private static final Logger logger = LoggerFactory.getLogger(ServerRoSessionImpl.class);
    protected Lock sendAndStateLock = new ReentrantLock();
    protected transient IRoMessageFactory factory = null;
    protected transient IServerRoSessionContext context = null;
    protected transient ServerRoSessionListener listener = null;
    protected static final String TCC_TIMER_NAME = "TCC_RoSERVER_TIMER";
    protected long[] authAppIds = new long[]{4L};
    protected IServerRoSessionData sessionData;

    public ServerRoSessionImpl(IServerRoSessionData sessionData, IRoMessageFactory fct, ISessionFactory sf, ServerRoSessionListener lst, IServerRoSessionContext ctx, StateChangeListener<AppSession> stLst) {
        super(sf, sessionData);
        if (sessionData == null) {
            throw new IllegalArgumentException("SessionData can not be null");
        }
        if (lst == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        if (fct.getApplicationIds() == null) {
            throw new IllegalArgumentException("ApplicationId can not be less than zero");
        }
        this.sessionData = sessionData;
        this.context = ctx;
        this.authAppIds = fct.getApplicationIds();
        this.listener = lst;
        this.factory = fct;
        super.addStateChangeNotification(stLst);
    }

    public void sendCreditControlAnswer(RoCreditControlAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.handleEvent(new Event(false, null, answer));
    }

    public void sendReAuthRequest(ReAuthRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SENT_RAR, (AppRequestEvent)request, null);
    }

    public boolean isStateless() {
        return this.sessionData.isStateless();
    }

    public <E> E getState(Class<E> stateType) {
        return (E)(stateType == ServerRoSessionState.class ? this.sessionData.getServerRoSessionState() : null);
    }

    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        ServerRoSessionState newState = null;
        ServerRoSessionState state = this.sessionData.getServerRoSessionState();
        try {
            this.sendAndStateLock.lock();
            Event localEvent = (Event)event;
            Event.Type eventType = (Event.Type)localEvent.getType();
            block5 : switch (state) {
                case IDLE: {
                    RoCreditControlAnswer answer;
                    switch (eventType) {
                        case RECEIVED_INITIAL: {
                            this.listener.doCreditControlRequest((ServerRoSession)this, (RoCreditControlRequest)localEvent.getRequest());
                            break;
                        }
                        case RECEIVED_EVENT: {
                            this.listener.doCreditControlRequest((ServerRoSession)this, (RoCreditControlRequest)localEvent.getRequest());
                            break;
                        }
                        case SENT_EVENT_RESPONSE: {
                            newState = ServerRoSessionState.IDLE;
                            this.dispatchEvent(localEvent.getAnswer());
                            this.setState(newState);
                            break;
                        }
                        case SENT_INITIAL_RESPONSE: {
                            answer = (RoCreditControlAnswer)localEvent.getAnswer();
                            try {
                                long resultCode = answer.getResultCodeAvp().getUnsigned32();
                                if (this.isSuccess(resultCode)) {
                                    this.startTcc(answer.getValidityTimeAvp());
                                    newState = ServerRoSessionState.OPEN;
                                } else {
                                    newState = ServerRoSessionState.IDLE;
                                }
                                this.dispatchEvent(localEvent.getAnswer());
                                this.setState(newState);
                                break;
                            }
                            catch (AvpDataException e) {
                                throw new InternalException((Throwable)e);
                            }
                        }
                        case RECEIVED_UPDATE: 
                        case RECEIVED_TERMINATE: {
                            Answer errorAnswer = ((Request)localEvent.getRequest().getMessage()).createAnswer(5002L);
                            this.session.send((Message)errorAnswer);
                            logger.debug("Received an UPDATE or TERMINATE for a new session. Answering with 5002 (UNKNOWN_SESSION_ID) and terminating session.");
                        }
                        default: {
                            throw new InternalException("Wrong state: " + ServerRoSessionState.IDLE + " one event: " + (Object)((Object)eventType) + " " + localEvent.getRequest() + " " + localEvent.getAnswer());
                        }
                    }
                }
                case OPEN: {
                    RoCreditControlAnswer answer;
                    switch (eventType) {
                        case RECEIVED_UPDATE: {
                            this.listener.doCreditControlRequest((ServerRoSession)this, (RoCreditControlRequest)localEvent.getRequest());
                            break block5;
                        }
                        case SENT_UPDATE_RESPONSE: {
                            answer = (RoCreditControlAnswer)localEvent.getAnswer();
                            try {
                                if (this.isSuccess(answer.getResultCodeAvp().getUnsigned32())) {
                                    this.startTcc(answer.getValidityTimeAvp());
                                }
                            }
                            catch (AvpDataException e) {
                                throw new InternalException((Throwable)e);
                            }
                            this.dispatchEvent(localEvent.getAnswer());
                            break block5;
                        }
                        case RECEIVED_TERMINATE: {
                            this.listener.doCreditControlRequest((ServerRoSession)this, (RoCreditControlRequest)localEvent.getRequest());
                            break block5;
                        }
                        case SENT_TERMINATE_RESPONSE: {
                            answer = (RoCreditControlAnswer)localEvent.getAnswer();
                            try {
                                if (this.isSuccess(answer.getResultCodeAvp().getUnsigned32())) {
                                    this.stopTcc(false);
                                }
                            }
                            catch (AvpDataException e) {
                                throw new InternalException((Throwable)e);
                            }
                            newState = ServerRoSessionState.IDLE;
                            this.dispatchEvent(localEvent.getAnswer());
                            this.setState(newState);
                            break block5;
                        }
                        case RECEIVED_RAA: {
                            this.listener.doReAuthAnswer((ServerRoSession)this, (ReAuthRequest)new ReAuthRequestImpl(localEvent.getRequest().getMessage()), (ReAuthAnswer)new ReAuthAnswerImpl((Answer)localEvent.getAnswer().getMessage()));
                            break block5;
                        }
                        case SENT_RAR: {
                            this.dispatchEvent(localEvent.getRequest());
                        }
                    }
                }
            }
            boolean bl = true;
            Object var10_14 = null;
            this.sendAndStateLock.unlock();
            return bl;
        }
        catch (Exception e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                this.sendAndStateLock.unlock();
                throw throwable;
            }
        }
    }

    @Override
    public boolean isReplicable() {
        return true;
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery rd = new AnswerDelivery();
        rd.session = this;
        rd.request = request;
        rd.answer = answer;
        this.scheduler.execute(rd);
    }

    public void timeoutExpired(Request request) {
        this.context.timeoutExpired(request);
    }

    private void startTcc(Avp validityAvp) {
    }

    @Override
    public void onTimer(String timerName) {
        if (timerName.equals(TCC_TIMER_NAME)) {
            new TccScheduledTask(this).run();
        }
    }

    private void stopTcc(boolean willRestart) {
        Serializable tccTimerId = this.sessionData.getTccTimerId();
        if (tccTimerId != null) {
            this.timerFacility.cancel(tccTimerId);
            this.sessionData.setTccTimerId(null);
            if (!willRestart) {
                this.context.sessionSupervisionTimerStopped(this, null);
            }
        }
    }

    protected boolean isProvisional(long resultCode) {
        return resultCode >= 1000L && resultCode < 2000L;
    }

    protected boolean isSuccess(long resultCode) {
        return resultCode >= 2000L && resultCode < 3000L;
    }

    protected void setState(ServerRoSessionState newState) {
        this.setState(newState, true);
    }

    protected void setState(ServerRoSessionState newState, boolean release) {
        ServerRoSessionState oldState = this.sessionData.getServerRoSessionState();
        this.sessionData.setServerRoSessionState(newState);
        for (StateChangeListener i : this.stateListeners) {
            i.stateChanged((Object)this, (Enum)oldState, (Enum)newState);
        }
        if (newState == ServerRoSessionState.IDLE) {
            this.stopTcc(false);
            if (release) {
                this.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.isValid()) {
            try {
                try {
                    this.sendAndStateLock.lock();
                    this.stopTcc(false);
                    super.release();
                }
                catch (Exception e) {
                    logger.debug("Failed to release session", (Throwable)e);
                    Object var3_2 = null;
                    this.sendAndStateLock.unlock();
                }
                Object var3_1 = null;
                this.sendAndStateLock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.sendAndStateLock.unlock();
                throw throwable;
            }
        } else {
            logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }

    protected void send(Event.Type type, AppRequestEvent request, AppAnswerEvent answer) throws InternalException {
        try {
            block4: {
                try {
                    this.sendAndStateLock.lock();
                    if (type == null) break block4;
                    this.handleEvent(new Event(type, request, answer));
                }
                catch (Exception e) {
                    throw new InternalException((Throwable)e);
                }
            }
            Object var6_4 = null;
            this.sendAndStateLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.sendAndStateLock.unlock();
            throw throwable;
        }
    }

    protected void dispatchEvent(AppEvent event) throws InternalException {
        try {
            this.session.send(event.getMessage(), (EventListener)this);
        }
        catch (Exception e) {
            logger.debug("Failure trying to dispatch event", (Throwable)e);
        }
    }

    private class AnswerDelivery
    implements Runnable {
        ServerRoSession session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    case 258: {
                        ServerRoSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVED_RAA, (AppRequestEvent)ServerRoSessionImpl.this.factory.createReAuthRequest(this.request), (AppAnswerEvent)ServerRoSessionImpl.this.factory.createReAuthAnswer(this.answer)));
                        break;
                    }
                    default: {
                        ServerRoSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process success message", (Throwable)e);
            }
        }
    }

    private class RequestDelivery
    implements Runnable {
        ServerRoSession session;
        Request request;

        private RequestDelivery() {
        }

        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    case 272: {
                        ServerRoSessionImpl.this.handleEvent(new Event(true, ServerRoSessionImpl.this.factory.createCreditControlRequest(this.request), null));
                        break;
                    }
                    default: {
                        ServerRoSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), null);
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process request message", (Throwable)e);
            }
        }
    }

    private class TccScheduledTask
    implements Runnable {
        ServerRoSession session = null;

        private TccScheduledTask(ServerRoSession session) {
            this.session = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block6: {
                try {
                    ServerRoSessionImpl.this.sendAndStateLock.lock();
                    if (ServerRoSessionImpl.this.context != null) {
                        ServerRoSessionImpl.this.context.sessionSupervisionTimerExpired(this.session);
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    try {
                        ServerRoSessionImpl.this.sessionData.setTccTimerId(null);
                        ServerRoSessionImpl.this.setState(ServerRoSessionState.IDLE);
                    }
                    catch (Exception e) {
                        logger.error("", (Throwable)e);
                    }
                    ServerRoSessionImpl.this.sendAndStateLock.unlock();
                    throw throwable;
                }
                try {
                    ServerRoSessionImpl.this.sessionData.setTccTimerId(null);
                    ServerRoSessionImpl.this.setState(ServerRoSessionState.IDLE);
                    break block6;
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
                {
                }
            }
            ServerRoSessionImpl.this.sendAndStateLock.unlock();
        }
    }
}

