/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.app.gx;

import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.Answer;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.gx.ServerGxSession;
import org.jdiameter.api.gx.ServerGxSessionListener;
import org.jdiameter.api.gx.events.GxCreditControlAnswer;
import org.jdiameter.api.gx.events.GxCreditControlRequest;
import org.jdiameter.api.gx.events.GxReAuthAnswer;
import org.jdiameter.api.gx.events.GxReAuthRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.gx.IGxMessageFactory;
import org.jdiameter.common.api.app.gx.IServerGxSessionContext;
import org.jdiameter.common.api.app.gx.ServerGxSessionState;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.gx.AppGxSessionImpl;
import org.jdiameter.server.impl.app.gx.Event;
import org.jdiameter.server.impl.app.gx.IServerGxSessionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerGxSessionImpl
extends AppGxSessionImpl
implements ServerGxSession,
NetworkReqListener,
EventListener<Request, Answer> {
    private static final Logger logger = LoggerFactory.getLogger(ServerGxSessionImpl.class);
    protected Lock sendAndStateLock = new ReentrantLock();
    protected transient IGxMessageFactory factory = null;
    protected transient IServerGxSessionContext context = null;
    protected transient ServerGxSessionListener listener = null;
    protected static final String TCC_TIMER_NAME = "TCC_GxSERVER_TIMER";
    protected long[] authAppIds = new long[]{4L};
    protected IServerGxSessionData sessionData;

    public ServerGxSessionImpl(IServerGxSessionData sessionData, IGxMessageFactory fct, ISessionFactory sf, ServerGxSessionListener lst, IServerGxSessionContext ctx, StateChangeListener<AppSession> stLst) {
        super(sf, sessionData);
        if (lst == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        if (fct.getApplicationIds() == null) {
            throw new IllegalArgumentException("ApplicationId can not be less than zero");
        }
        this.context = ctx;
        this.authAppIds = fct.getApplicationIds();
        this.listener = lst;
        this.factory = fct;
        this.sessionData = sessionData;
        super.addStateChangeNotification(stLst);
    }

    public void sendCreditControlAnswer(GxCreditControlAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.handleEvent(new Event(false, null, answer));
    }

    public void sendGxReAuthRequest(GxReAuthRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SENT_RAR, (AppRequestEvent)request, null);
    }

    public boolean isStateless() {
        return this.sessionData.isStateless();
    }

    public <E> E getState(Class<E> stateType) {
        return (E)(stateType == ServerGxSessionState.class ? this.sessionData.getServerGxSessionState() : null);
    }

    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        ServerGxSessionState newState = null;
        try {
            this.sendAndStateLock.lock();
            Event localEvent = (Event)event;
            ServerGxSessionState state = this.sessionData.getServerGxSessionState();
            Event.Type eventType = (Event.Type)localEvent.getType();
            block5 : switch (state) {
                case IDLE: {
                    GxCreditControlAnswer answer;
                    switch (eventType) {
                        case RECEIVED_INITIAL: {
                            this.listener.doCreditControlRequest((ServerGxSession)this, (GxCreditControlRequest)localEvent.getRequest());
                            break;
                        }
                        case RECEIVED_EVENT: {
                            this.listener.doCreditControlRequest((ServerGxSession)this, (GxCreditControlRequest)localEvent.getRequest());
                            break;
                        }
                        case SENT_EVENT_RESPONSE: {
                            newState = ServerGxSessionState.IDLE;
                            this.dispatchEvent(localEvent.getAnswer());
                            this.setState(newState);
                            break;
                        }
                        case SENT_INITIAL_RESPONSE: {
                            answer = (GxCreditControlAnswer)localEvent.getAnswer();
                            try {
                                long resultCode = answer.getResultCodeAvp().getUnsigned32();
                                if (this.isSuccess(resultCode)) {
                                    this.startTcc(answer.getValidityTimeAvp());
                                    newState = ServerGxSessionState.OPEN;
                                } else {
                                    newState = ServerGxSessionState.IDLE;
                                }
                                this.dispatchEvent(localEvent.getAnswer());
                                this.setState(newState);
                                break;
                            }
                            catch (AvpDataException e) {
                                throw new InternalException((Throwable)e);
                            }
                        }
                        default: {
                            throw new InternalException("Wrong state: " + ServerGxSessionState.IDLE + " one event: " + (Object)((Object)eventType) + " " + localEvent.getRequest() + " " + localEvent.getAnswer());
                        }
                    }
                }
                case OPEN: {
                    GxCreditControlAnswer answer;
                    switch (eventType) {
                        case RECEIVED_UPDATE: {
                            this.listener.doCreditControlRequest((ServerGxSession)this, (GxCreditControlRequest)localEvent.getRequest());
                            break block5;
                        }
                        case SENT_UPDATE_RESPONSE: {
                            answer = (GxCreditControlAnswer)localEvent.getAnswer();
                            try {
                                if (this.isSuccess(answer.getResultCodeAvp().getUnsigned32())) {
                                    this.startTcc(answer.getValidityTimeAvp());
                                }
                            }
                            catch (AvpDataException e) {
                                throw new InternalException((Throwable)e);
                            }
                            this.dispatchEvent(localEvent.getAnswer());
                            break block5;
                        }
                        case RECEIVED_TERMINATE: {
                            this.listener.doCreditControlRequest((ServerGxSession)this, (GxCreditControlRequest)localEvent.getRequest());
                            break block5;
                        }
                        case SENT_TERMINATE_RESPONSE: {
                            answer = (GxCreditControlAnswer)localEvent.getAnswer();
                            try {
                                if (this.isSuccess(answer.getResultCodeAvp().getUnsigned32())) {
                                    this.stopTcc(false);
                                }
                            }
                            catch (AvpDataException e) {
                                throw new InternalException((Throwable)e);
                            }
                            newState = ServerGxSessionState.IDLE;
                            this.dispatchEvent(localEvent.getAnswer());
                            this.setState(newState);
                            break block5;
                        }
                        case RECEIVED_RAA: {
                            this.listener.doGxReAuthAnswer((ServerGxSession)this, (GxReAuthRequest)localEvent.getRequest(), (GxReAuthAnswer)localEvent.getAnswer());
                            break block5;
                        }
                        case SENT_RAR: {
                            this.dispatchEvent(localEvent.getRequest());
                        }
                    }
                }
            }
            boolean bl = true;
            Object var10_13 = null;
            this.sendAndStateLock.unlock();
            return bl;
        }
        catch (Exception e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                this.sendAndStateLock.unlock();
                throw throwable;
            }
        }
    }

    @Override
    public boolean isReplicable() {
        return true;
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery rd = new AnswerDelivery();
        rd.session = this;
        rd.request = request;
        rd.answer = answer;
        this.scheduler.execute(rd);
    }

    public void timeoutExpired(Request request) {
        this.context.timeoutExpired(request);
    }

    private void startTcc(Avp validityAvp) {
    }

    @Override
    public void onTimer(String timerName) {
        if (timerName.equals(TCC_TIMER_NAME)) {
            new TccScheduledTask(this).run();
        }
    }

    private void stopTcc(boolean willRestart) {
        Serializable tccTimerId = this.sessionData.getTccTimerId();
        if (tccTimerId != null) {
            this.timerFacility.cancel(tccTimerId);
            this.sessionData.setTccTimerId(null);
            if (!willRestart && this.context != null) {
                this.context.sessionSupervisionTimerStopped(this, null);
            }
        }
    }

    protected boolean isProvisional(long resultCode) {
        return resultCode >= 1000L && resultCode < 2000L;
    }

    protected boolean isSuccess(long resultCode) {
        return resultCode >= 2000L && resultCode < 3000L;
    }

    protected void setState(ServerGxSessionState newState) {
        this.setState(newState, true);
    }

    protected void setState(ServerGxSessionState newState, boolean release) {
        ServerGxSessionState oldState = this.sessionData.getServerGxSessionState();
        this.sessionData.setServerGxSessionState(newState);
        for (StateChangeListener i : this.stateListeners) {
            i.stateChanged((Object)this, (Enum)oldState, (Enum)newState);
        }
        if (newState == ServerGxSessionState.IDLE) {
            this.stopTcc(false);
            if (release) {
                this.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.isValid()) {
            try {
                try {
                    this.sendAndStateLock.lock();
                    this.stopTcc(false);
                    super.release();
                }
                catch (Exception e) {
                    logger.debug("Failed to release session", (Throwable)e);
                    Object var3_2 = null;
                    this.sendAndStateLock.unlock();
                }
                Object var3_1 = null;
                this.sendAndStateLock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.sendAndStateLock.unlock();
                throw throwable;
            }
        } else {
            logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }

    protected void send(Event.Type type, AppRequestEvent request, AppAnswerEvent answer) throws InternalException {
        try {
            block4: {
                try {
                    this.sendAndStateLock.lock();
                    if (type == null) break block4;
                    this.handleEvent(new Event(type, request, answer));
                }
                catch (Exception e) {
                    throw new InternalException((Throwable)e);
                }
            }
            Object var6_4 = null;
            this.sendAndStateLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.sendAndStateLock.unlock();
            throw throwable;
        }
    }

    protected void dispatchEvent(AppEvent event) throws InternalException {
        try {
            this.session.send(event.getMessage(), (EventListener)this);
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.sessionData == null ? 0 : this.sessionData.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerGxSessionImpl other = (ServerGxSessionImpl)obj;
        return !(this.sessionData == null ? other.sessionData != null : !this.sessionData.equals(other.sessionData));
    }

    private class AnswerDelivery
    implements Runnable {
        ServerGxSession session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    case 258: {
                        ServerGxSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVED_RAA, (AppRequestEvent)ServerGxSessionImpl.this.factory.createGxReAuthRequest(this.request), (AppAnswerEvent)ServerGxSessionImpl.this.factory.createGxReAuthAnswer(this.answer)));
                        break;
                    }
                    default: {
                        ServerGxSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process success message", (Throwable)e);
            }
        }
    }

    private class RequestDelivery
    implements Runnable {
        ServerGxSession session;
        Request request;

        private RequestDelivery() {
        }

        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    case 272: {
                        ServerGxSessionImpl.this.handleEvent(new Event(true, ServerGxSessionImpl.this.factory.createCreditControlRequest(this.request), null));
                        break;
                    }
                    default: {
                        ServerGxSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), null);
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process request message", (Throwable)e);
            }
        }
    }

    private class TccScheduledTask
    implements Runnable {
        ServerGxSession session = null;

        private TccScheduledTask(ServerGxSession session) {
            this.session = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ServerGxSessionImpl.this.context.sessionSupervisionTimerExpired(this.session);
            try {
                ServerGxSessionImpl.this.sendAndStateLock.lock();
                ServerGxSessionImpl.this.sessionData.setTccTimerId(null);
                ServerGxSessionImpl.this.setState(ServerGxSessionState.IDLE);
                Object var2_1 = null;
                ServerGxSessionImpl.this.sendAndStateLock.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                ServerGxSessionImpl.this.sendAndStateLock.unlock();
                throw throwable;
            }
        }
    }
}

