/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.statistic;

import java.util.HashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.StatisticRecord;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.jdiameter.common.api.statistic.IStatistic;
import org.jdiameter.common.api.statistic.IStatisticManager;
import org.jdiameter.common.api.statistic.IStatisticProcessor;
import org.jdiameter.common.api.statistic.IStatisticRecord;
import org.jdiameter.common.impl.statistic.StatisticManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticProcessorImpl
implements IStatisticProcessor {
    private static final Logger logger = LoggerFactory.getLogger(StatisticProcessorImpl.class);
    private ScheduledExecutorService executorService;
    private IConcurrentFactory concurrentFactory;
    private IStatisticManager statisticFactory;
    private static final String STATS_ROOT_LOGGER_NAME = "jdiameter.statistic";
    private static final String STATS_LOGGER_PREFIX = "jdiameter.statistic.";
    private Future<?> processorFuture;
    private Future<?> logFuture;
    private HashMap<String, Logger> loggers = new HashMap();

    public StatisticProcessorImpl(Configuration config, IConcurrentFactory concurrentFactory, IStatisticManager statisticFactory) {
        this.statisticFactory = statisticFactory;
        this.concurrentFactory = concurrentFactory;
    }

    public void start() {
        if (!this.statisticFactory.isOn()) {
            return;
        }
        this.executorService = this.concurrentFactory.getScheduledExecutorService(IConcurrentFactory.ScheduledExecServices.StatisticTimer.name());
        this.processorFuture = this.executorService.scheduleAtFixedRate(new Runnable(){

            public void run() {
                try {
                    for (IStatisticRecord r : ((StatisticManagerImpl)StatisticProcessorImpl.this.statisticFactory).getPSStatisticRecord()) {
                        StatisticRecord[] recs = r.getChilds();
                        IStatisticRecord realRecord = (IStatisticRecord)recs[0];
                        IStatisticRecord prevRecord = (IStatisticRecord)recs[1];
                        r.setLongValue(realRecord.getValueAsLong() - prevRecord.getValueAsLong());
                        prevRecord.setLongValue(realRecord.getValueAsLong());
                    }
                }
                catch (Exception e) {
                    logger.warn("Can not start persecond statistic", (Throwable)e);
                }
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        this.logFuture = this.executorService.scheduleAtFixedRate(new Runnable(){

            public void run() {
                boolean oneLine = false;
                for (IStatistic statistic : StatisticProcessorImpl.this.statisticFactory.getStatistic()) {
                    if (!statistic.isEnabled()) continue;
                    for (StatisticRecord record : statistic.getRecords()) {
                        oneLine = true;
                        String loggerKey = statistic.getName() + "." + record.getName();
                        Logger logger = null;
                        logger = (Logger)StatisticProcessorImpl.this.loggers.get(loggerKey);
                        if (logger == null) {
                            logger = LoggerFactory.getLogger((String)(StatisticProcessorImpl.STATS_LOGGER_PREFIX + loggerKey));
                            StatisticProcessorImpl.this.loggers.put(loggerKey, logger);
                        }
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace(record.toString());
                    }
                }
                if (oneLine) {
                    Logger logger = null;
                    logger = (Logger)StatisticProcessorImpl.this.loggers.get(StatisticProcessorImpl.STATS_ROOT_LOGGER_NAME);
                    if (logger == null) {
                        logger = LoggerFactory.getLogger((String)StatisticProcessorImpl.STATS_ROOT_LOGGER_NAME);
                        StatisticProcessorImpl.this.loggers.put(StatisticProcessorImpl.STATS_ROOT_LOGGER_NAME, logger);
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("=============================================== Marker ===============================================");
                    }
                }
            }
        }, this.statisticFactory.getPause(), this.statisticFactory.getDelay(), TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (!this.statisticFactory.isOn()) {
            return;
        }
        if (this.processorFuture != null) {
            this.processorFuture.cancel(false);
            this.processorFuture = null;
        }
        if (this.logFuture != null) {
            this.logFuture.cancel(false);
            this.logFuture = null;
        }
        this.concurrentFactory.shutdownNow(this.executorService);
    }
}

