/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app.rx;

import java.util.concurrent.ScheduledFuture;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.BaseSession;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.Request;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.rx.ClientRxSession;
import org.jdiameter.api.rx.ClientRxSessionListener;
import org.jdiameter.api.rx.ServerRxSession;
import org.jdiameter.api.rx.ServerRxSessionListener;
import org.jdiameter.api.rx.events.RxAAAnswer;
import org.jdiameter.api.rx.events.RxAARequest;
import org.jdiameter.api.rx.events.RxAbortSessionAnswer;
import org.jdiameter.api.rx.events.RxAbortSessionRequest;
import org.jdiameter.api.rx.events.RxReAuthAnswer;
import org.jdiameter.api.rx.events.RxReAuthRequest;
import org.jdiameter.api.rx.events.RxSessionTermAnswer;
import org.jdiameter.api.rx.events.RxSessionTermRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.rx.ClientRxSessionImpl;
import org.jdiameter.client.impl.app.rx.IClientRxSessionData;
import org.jdiameter.common.api.app.IAppSessionDataFactory;
import org.jdiameter.common.api.app.rx.IClientRxSessionContext;
import org.jdiameter.common.api.app.rx.IRxMessageFactory;
import org.jdiameter.common.api.app.rx.IRxSessionData;
import org.jdiameter.common.api.app.rx.IRxSessionFactory;
import org.jdiameter.common.api.app.rx.IServerRxSessionContext;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.impl.app.rx.AppRxSessionImpl;
import org.jdiameter.common.impl.app.rx.RxAAAnswerImpl;
import org.jdiameter.common.impl.app.rx.RxAARequestImpl;
import org.jdiameter.common.impl.app.rx.RxAbortSessionAnswerImpl;
import org.jdiameter.common.impl.app.rx.RxAbortSessionRequestImpl;
import org.jdiameter.common.impl.app.rx.RxReAuthAnswerImpl;
import org.jdiameter.common.impl.app.rx.RxReAuthRequestImpl;
import org.jdiameter.common.impl.app.rx.RxSessionTermAnswerImpl;
import org.jdiameter.common.impl.app.rx.RxSessionTermRequestImpl;
import org.jdiameter.server.impl.app.rx.IServerRxSessionData;
import org.jdiameter.server.impl.app.rx.ServerRxSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RxSessionFactoryImpl
implements IRxSessionFactory,
ClientRxSessionListener,
ServerRxSessionListener,
StateChangeListener<AppSession>,
IRxMessageFactory,
IServerRxSessionContext,
IClientRxSessionContext {
    protected int defaultDirectDebitingFailureHandling = 0;
    protected int defaultAAFailureHandling = 0;
    protected long defaultValidityTime = 60L;
    protected long defaultTxTimerValue = 30L;
    protected ClientRxSessionListener clientSessionListener;
    protected ServerRxSessionListener serverSessionListener;
    protected StateChangeListener<AppSession> stateListener;
    protected IServerRxSessionContext serverContextListener;
    protected IClientRxSessionContext clientContextListener;
    protected IRxMessageFactory messageFactory;
    protected static final Logger logger = LoggerFactory.getLogger(RxSessionFactoryImpl.class);
    protected ISessionDatasource iss;
    protected ISessionFactory sessionFactory = null;
    protected IAppSessionDataFactory<IRxSessionData> sessionDataFactory;

    public RxSessionFactoryImpl(SessionFactory sessionFactory) {
        this.sessionFactory = (ISessionFactory)sessionFactory;
        this.iss = this.sessionFactory.getContainer().getAssemblerFacility().getComponentInstance(ISessionDatasource.class);
        this.sessionDataFactory = this.iss.getDataFactory(IRxSessionData.class);
        if (this.sessionDataFactory == null) {
            logger.debug("Initialized Rx SessionDataFactory is null");
        }
    }

    public RxSessionFactoryImpl(SessionFactory sessionFactory, int defaultDirectDebitingFailureHandling, int defaultAAFailureHandling, long defaultValidityTime, long defaultTxTimerValue) {
        this(sessionFactory);
        this.defaultDirectDebitingFailureHandling = defaultDirectDebitingFailureHandling;
        this.defaultAAFailureHandling = defaultAAFailureHandling;
        this.defaultValidityTime = defaultValidityTime;
        this.defaultTxTimerValue = defaultTxTimerValue;
    }

    @Override
    public ClientRxSessionListener getClientSessionListener() {
        return this.clientSessionListener != null ? this.clientSessionListener : this;
    }

    @Override
    public void setClientSessionListener(ClientRxSessionListener clientSessionListener) {
        this.clientSessionListener = clientSessionListener;
    }

    @Override
    public ServerRxSessionListener getServerSessionListener() {
        return this.serverSessionListener != null ? this.serverSessionListener : this;
    }

    @Override
    public void setServerSessionListener(ServerRxSessionListener serverSessionListener) {
        this.serverSessionListener = serverSessionListener;
    }

    @Override
    public IServerRxSessionContext getServerContextListener() {
        return this.serverContextListener != null ? this.serverContextListener : this;
    }

    @Override
    public void setServerContextListener(IServerRxSessionContext serverContextListener) {
        this.serverContextListener = serverContextListener;
    }

    @Override
    public IClientRxSessionContext getClientContextListener() {
        return this.clientContextListener != null ? this.clientContextListener : this;
    }

    @Override
    public IRxMessageFactory getMessageFactory() {
        return this.messageFactory != null ? this.messageFactory : this;
    }

    @Override
    public void setMessageFactory(IRxMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    @Override
    public void setClientContextListener(IClientRxSessionContext clientContextListener) {
        this.clientContextListener = clientContextListener;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = (ISessionFactory)sessionFactory;
    }

    @Override
    public StateChangeListener<AppSession> getStateListener() {
        return this.stateListener != null ? this.stateListener : this;
    }

    @Override
    public void setStateListener(StateChangeListener<AppSession> stateListener) {
        this.stateListener = stateListener;
    }

    @Override
    public AppSession getSession(String sessionId, Class<? extends AppSession> aClass) {
        AppRxSessionImpl appSession;
        block6: {
            if (sessionId == null) {
                throw new IllegalArgumentException("SessionId must not be null");
            }
            if (!this.iss.exists(sessionId)) {
                return null;
            }
            appSession = null;
            try {
                if (aClass == ClientRxSession.class) {
                    IClientRxSessionData sessionData = (IClientRxSessionData)this.sessionDataFactory.getAppSessionData(ClientRxSession.class, sessionId);
                    ClientRxSessionImpl clientSession = new ClientRxSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getClientSessionListener(), this.getClientContextListener(), this.getStateListener());
                    clientSession.getSessions().get(0).setRequestListener((NetworkReqListener)clientSession);
                    appSession = clientSession;
                    break block6;
                }
                if (aClass == ServerRxSession.class) {
                    IServerRxSessionData sessionData = (IServerRxSessionData)this.sessionDataFactory.getAppSessionData(ServerRxSession.class, sessionId);
                    ServerRxSessionImpl serverSession = new ServerRxSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getServerSessionListener(), this.getServerContextListener(), this.getStateListener());
                    serverSession.getSessions().get(0).setRequestListener((NetworkReqListener)serverSession);
                    appSession = serverSession;
                    break block6;
                }
                throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ClientRxSession.class + "," + ServerRxSession.class + "]");
            }
            catch (Exception e) {
                logger.error("Failure to obtain new Rx Session.", (Throwable)e);
            }
        }
        return appSession;
    }

    @Override
    public AppSession getNewSession(String sessionId, Class<? extends AppSession> aClass, ApplicationId applicationId, Object[] args) {
        AppRxSessionImpl appSession;
        block10: {
            appSession = null;
            try {
                if (aClass == ClientRxSession.class) {
                    if (sessionId == null) {
                        if (args != null && args.length > 0 && args[0] instanceof Request) {
                            Request request = (Request)args[0];
                            sessionId = request.getSessionId();
                        } else {
                            sessionId = this.sessionFactory.getSessionId();
                        }
                    }
                    IClientRxSessionData sessionData = (IClientRxSessionData)this.sessionDataFactory.getAppSessionData(ClientRxSession.class, sessionId);
                    ClientRxSessionImpl clientSession = new ClientRxSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getClientSessionListener(), this.getClientContextListener(), this.getStateListener());
                    this.iss.addSession((BaseSession)clientSession);
                    clientSession.getSessions().get(0).setRequestListener((NetworkReqListener)clientSession);
                    appSession = clientSession;
                    break block10;
                }
                if (aClass == ServerRxSession.class) {
                    if (sessionId == null) {
                        if (args != null && args.length > 0 && args[0] instanceof Request) {
                            Request request = (Request)args[0];
                            sessionId = request.getSessionId();
                        } else {
                            sessionId = this.sessionFactory.getSessionId();
                        }
                    }
                    IServerRxSessionData sessionData = (IServerRxSessionData)this.sessionDataFactory.getAppSessionData(ServerRxSession.class, sessionId);
                    ServerRxSessionImpl serverSession = new ServerRxSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getServerSessionListener(), this.getServerContextListener(), this.getStateListener());
                    this.iss.addSession((BaseSession)serverSession);
                    serverSession.getSessions().get(0).setRequestListener((NetworkReqListener)serverSession);
                    appSession = serverSession;
                    break block10;
                }
                throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ClientRxSession.class + "," + ServerRxSession.class + "]");
            }
            catch (Exception e) {
                logger.error("Failure to obtain new Rx Session.", (Throwable)e);
            }
        }
        return appSession;
    }

    public void doAARequest(ServerRxSession session, RxAARequest request) throws InternalException {
    }

    public void doAAAnswer(ClientRxSession session, RxAARequest request, RxAAAnswer answer) throws InternalException {
    }

    public void doReAuthRequest(ClientRxSession session, RxReAuthRequest request) throws InternalException {
    }

    public void doReAuthAnswer(ServerRxSession session, RxReAuthRequest request, RxReAuthAnswer answer) throws InternalException {
    }

    public void doAbortSessionRequest(ClientRxSession session, RxAbortSessionRequest request) throws InternalException {
    }

    public void doAbortSessionAnswer(ServerRxSession session, RxAbortSessionRequest request, RxAbortSessionAnswer answer) throws InternalException {
    }

    public void doSessionTermRequest(ServerRxSession session, RxSessionTermRequest request) throws InternalException {
    }

    public void doSessionTermAnswer(ClientRxSession session, RxSessionTermRequest request, RxSessionTermAnswer answer) throws InternalException {
    }

    public void doOtherEvent(AppSession session, AppRequestEvent request, AppAnswerEvent answer) throws InternalException {
    }

    @Override
    public RxAAAnswer createAAAnswer(Answer answer) {
        return new RxAAAnswerImpl(answer);
    }

    @Override
    public RxAARequest createAARequest(Request req) {
        return new RxAARequestImpl(req);
    }

    @Override
    public RxReAuthAnswer createReAuthAnswer(Answer answer) {
        return new RxReAuthAnswerImpl(answer);
    }

    @Override
    public RxReAuthRequest createReAuthRequest(Request req) {
        return new RxReAuthRequestImpl(req);
    }

    @Override
    public RxSessionTermAnswer createSessionTermAnswer(Answer answer) {
        return new RxSessionTermAnswerImpl(answer);
    }

    @Override
    public RxSessionTermRequest createSessionTermRequest(Request req) {
        return new RxSessionTermRequestImpl(req);
    }

    @Override
    public RxAbortSessionAnswer createAbortSessionAnswer(Answer answer) {
        return new RxAbortSessionAnswerImpl(answer);
    }

    @Override
    public RxAbortSessionRequest createAbortSessionRequest(Request req) {
        return new RxAbortSessionRequestImpl(req);
    }

    public void stateChanged(Enum oldState, Enum newState) {
        logger.info("Diameter Rx SessionFactory :: stateChanged :: oldState[{}], newState[{}]", (Object)oldState, (Object)newState);
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        logger.info("Diameter Rx SessionFactory :: stateChanged :: source[{}], oldState[{}], newState[{}]", new Object[]{source, oldState, newState});
    }

    @Override
    public void sessionSupervisionTimerExpired(ServerRxSession session) {
        session.release();
    }

    @Override
    public void sessionSupervisionTimerReStarted(ServerRxSession session, ScheduledFuture future) {
    }

    @Override
    public void sessionSupervisionTimerStarted(ServerRxSession session, ScheduledFuture future) {
    }

    @Override
    public void sessionSupervisionTimerStopped(ServerRxSession session, ScheduledFuture future) {
    }

    public void timeoutExpired(Request request) {
    }

    @Override
    public void denyAccessOnDeliverFailure(ClientRxSession clientRxSessionImpl, Message request) {
    }

    @Override
    public void denyAccessOnFailureMessage(ClientRxSession clientRxSessionImpl) {
    }

    public void denyAccessOnTxExpire(ClientRxSession clientRxSessionImpl) {
        clientRxSessionImpl.release();
    }

    @Override
    public void grantAccessOnDeliverFailure(ClientRxSession clientRxSessionImpl, Message request) {
    }

    @Override
    public void grantAccessOnFailureMessage(ClientRxSession clientRxSessionImpl) {
    }

    public void grantAccessOnTxExpire(ClientRxSession clientRxSessionImpl) {
    }

    @Override
    public void indicateServiceError(ClientRxSession clientRxSessionImpl) {
    }

    @Override
    public long[] getApplicationIds() {
        return new long[]{0x1000014L};
    }
}

