/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.transport.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.io.NotInitializedException;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.api.parser.ParseException;
import org.jdiameter.client.impl.helpers.Parameters;
import org.jdiameter.client.impl.transport.tls.TLSClientConnection;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLSTransportClient {
    private static final Logger logger = LoggerFactory.getLogger(TLSTransportClient.class);
    private TLSClientConnection parentConnection;
    private IConcurrentFactory concurrentFactory;
    private boolean stop = false;
    private boolean shaken;
    private boolean shaking;
    private Thread readThread;
    private InetSocketAddress destAddress;
    private InetSocketAddress origAddress;
    private String socketDescription = null;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Socket plainSocket;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int DEFAULT_STORAGE_SIZE = 4096;
    private int bufferSize = 4096;
    private ByteBuffer buffer = ByteBuffer.allocate(this.bufferSize);
    private int storageSize = 4096;
    private ByteBuffer storage = ByteBuffer.allocate(this.storageSize);
    private Lock lock = new ReentrantLock();
    private IMessageParser parser;
    private final DiameterSSLHandshakeListener handshakeListener = new DiameterSSLHandshakeListener();
    private final ReadTask readTash = new ReadTask();
    private boolean client;
    private boolean receivedInband;

    public TLSTransportClient(TLSClientConnection parenConnection, IConcurrentFactory concurrentFactory, IMessageParser parser) {
        this.parentConnection = parenConnection;
        this.concurrentFactory = concurrentFactory;
        this.parser = parser;
    }

    public void initialize() throws IOException, NotInitializedException {
        if (this.destAddress == null) {
            throw new NotInitializedException("Destination address is not set");
        }
        this.client = true;
        this.plainSocket = new Socket();
        if (this.origAddress != null) {
            this.plainSocket.bind(this.origAddress);
        }
        this.plainSocket.connect(this.destAddress);
        this.inputStream = this.plainSocket.getInputStream();
        this.outputStream = this.plainSocket.getOutputStream();
        this.parentConnection.onConnected();
    }

    public void initialize(Socket socket) throws IOException, NotInitializedException {
        logger.debug("Initialising TLSTransportClient for a socket on [{}]", (Object)socket);
        this.client = false;
        this.plainSocket = socket;
        this.socketDescription = socket.toString();
        this.destAddress = new InetSocketAddress(socket.getInetAddress(), socket.getPort());
        this.inputStream = this.plainSocket.getInputStream();
        this.outputStream = this.plainSocket.getOutputStream();
    }

    public void start() throws NotInitializedException {
        if (this.socketDescription == null) {
            this.socketDescription = this.plainSocket.toString();
        }
        logger.debug("Starting transport. Socket is {}", (Object)this.socketDescription);
        if (!this.plainSocket.isConnected()) {
            throw new NotInitializedException("Socket is not connected");
        }
        if (this.getParent() == null) {
            throw new NotInitializedException("No parent connection is set is set");
        }
        if (this.readThread == null || !this.readThread.isAlive()) {
            this.readThread = this.concurrentFactory.getThread("TLSReader", this.readTash);
        }
        if (!this.readThread.isAlive()) {
            this.readThread.setDaemon(true);
            this.readThread.start();
        }
    }

    public TLSClientConnection getParent() {
        return this.parentConnection;
    }

    public InetSocketAddress getDestAddress() {
        return this.destAddress;
    }

    public void setDestAddress(InetSocketAddress address) {
        this.destAddress = address;
        if (logger.isDebugEnabled()) {
            logger.debug("Destination address is set to [{}] : [{}]", (Object)this.destAddress.getHostName(), (Object)this.destAddress.getPort());
        }
    }

    public void setOrigAddress(InetSocketAddress address) {
        this.origAddress = address;
        if (logger.isDebugEnabled()) {
            logger.debug("Origin address is set to [{}] : [{}]", (Object)this.origAddress.getHostName(), (Object)this.origAddress.getPort());
        }
    }

    public InetSocketAddress getOrigAddress() {
        return this.origAddress;
    }

    void sendMessage(IMessage message) throws IOException, AvpDataException, NotInitializedException, ParseException {
        if (!this.isConnected()) {
            throw new IOException("Failed to send message over [" + this.socketDescription + "]");
        }
        if (!this.isExchangeAllowed()) {
            return;
        }
        this.doTLSPreSendProcessing(message);
        ByteBuffer messageBuffer = this.parser.encodeMessage(message);
        if (logger.isDebugEnabled()) {
            logger.debug("About to send a byte buffer of size [{}] over the TLS socket [{}]", (Object)messageBuffer.array().length, (Object)this.socketDescription);
        }
        this.lock.lock();
        try {
            try {
                this.outputStream.write(messageBuffer.array(), messageBuffer.position(), messageBuffer.limit());
                this.doTLSPostSendProcessing(message);
            }
            catch (Exception e) {
                logger.debug("Unable to send message", (Throwable)e);
                throw new IOException("Error while sending message: " + e);
            }
            Object var5_3 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.lock.unlock();
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Sent a byte buffer of size [{}] over the TLS nio socket [{}]", (Object)messageBuffer.array().length, (Object)this.socketDescription);
        }
    }

    boolean isConnected() {
        return this.plainSocket != null && this.plainSocket.isConnected();
    }

    void stop() throws Exception {
        logger.debug("Stopping transport. Socket is [{}]", (Object)this.socketDescription);
        this.stop = true;
        if (this.plainSocket != null && !this.plainSocket.isClosed()) {
            this.plainSocket.close();
        }
        if (this.readThread != null) {
            this.readThread.join(100L);
        }
        this.clearBuffer();
        logger.debug("Transport is stopped. Socket is [{}]", (Object)this.socketDescription);
    }

    public void release() throws Exception {
        this.stop();
        this.destAddress = null;
    }

    void append(byte[] data) {
        boolean messageReseived;
        if (this.storage.position() + data.length >= this.storage.capacity()) {
            ByteBuffer tmp = ByteBuffer.allocate(this.storage.limit() + data.length * 2);
            byte[] tmpData = new byte[this.storage.position()];
            this.storage.flip();
            this.storage.get(tmpData);
            tmp.put(tmpData);
            this.storage = tmp;
            logger.warn("Increase storage size. Current size is {}", (Object)this.storage.array().length);
        }
        try {
            this.storage.put(data);
        }
        catch (BufferOverflowException boe) {
            logger.error("Buffer overflow occured", (Throwable)boe);
        }
        while (messageReseived = this.seekMessage(this.storage)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExchangeAllowed() {
        this.lock.lock();
        try {
            boolean bl = !this.shaking;
            Object var3_2 = null;
            this.lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    private boolean isSuccess(IMessage message) throws AvpDataException {
        long resultCode;
        Avp resultAvp = message.getResultCode();
        if (resultAvp == null) {
            resultAvp = message.getAvps().getAvp(297);
            if (resultAvp == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Discarding message since SSL handshake has not been performed on [{}], dropped message [{}]. No result type avp.", (Object)this.socketDescription, (Object)message);
                }
                return false;
            }
            if ((resultAvp = resultAvp.getGrouped().getAvp(298)) == null && logger.isDebugEnabled()) {
                logger.debug("Discarding message since SSL handshake has not been performed on [{}], dropped message [{}]. No result avp.", (Object)this.socketDescription, (Object)message);
            }
        }
        return (resultCode = resultAvp.getUnsigned32()) >= 2000L && resultCode < 3000L;
    }

    private boolean seekMessage(ByteBuffer localStorage) {
        if (this.storage.position() == 0) {
            return false;
        }
        this.storage.flip();
        int tmp = localStorage.getInt();
        localStorage.position(0);
        byte vers = (byte)(tmp >> 24);
        if (vers != 1) {
            return false;
        }
        int dataLength = tmp & 0xFFFFFF;
        if (localStorage.limit() < dataLength) {
            localStorage.position(localStorage.limit());
            localStorage.limit(localStorage.capacity());
            return false;
        }
        byte[] data = new byte[dataLength];
        localStorage.get(data);
        localStorage.position(dataLength);
        localStorage.compact();
        ByteBuffer messageBuffer = ByteBuffer.wrap(data);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Received message of size [{}]", (Object)data.length);
            }
            IMessage message = this.parser.createMessage(messageBuffer);
            if (this.isExchangeAllowed()) {
                this.doTLSPreReceiveProcessing(message);
                this.getParent().onMessageReceived(message);
            }
        }
        catch (Exception e) {
            logger.debug("Garbage was received. Discarding.");
            this.storage.clear();
            this.getParent().onAvpDataException(new AvpDataException((Throwable)e));
        }
        return true;
    }

    private void doTLSPreReceiveProcessing(IMessage message) throws AvpDataException, NotInitializedException {
        if (this.shaken) {
            return;
        }
        if (this.client) {
            AvpSet set;
            Avp inbandAvp;
            if (message.isRequest()) {
                return;
            }
            if (message.getCommandCode() == 257 && this.isSuccess(message) && (inbandAvp = (set = message.getAvps()).getAvp(299)) != null && inbandAvp.getUnsigned32() == 1L) {
                this.startTLS();
            }
        } else {
            if (!message.isRequest()) {
                return;
            }
            AvpSet set = message.getAvps();
            Avp inbandAvp = set.getAvp(299);
            if (inbandAvp != null && inbandAvp.getUnsigned32() == 1L) {
                this.receivedInband = true;
            }
        }
    }

    private void doTLSPreSendProcessing(IMessage message) {
        if (message.getCommandCode() == 257) {
            AvpSet set = message.getAvps();
            set.removeAvp(299);
            set.addAvp(299, 1);
        }
    }

    private void doTLSPostSendProcessing(IMessage message) throws AvpDataException, NotInitializedException {
        if (this.shaken || this.client || this.plainSocket instanceof SSLSocket || message.isRequest() || message.getCommandCode() != 257) {
            return;
        }
        if (this.receivedInband && this.isSuccess(message)) {
            this.receivedInband = false;
            this.startTLS();
        }
    }

    private void startTLS() throws NotInitializedException {
        try {
            this.shaking = true;
            SSLSocketFactory cltFct = this.parentConnection.getSSLFactory();
            SSLSocket sslSocket = (SSLSocket)cltFct.createSocket(this.plainSocket, null, this.plainSocket.getPort(), false);
            sslSocket.setEnableSessionCreation(this.parentConnection.getSSLConfig().getBooleanValue(Parameters.SDEnableSessionCreation.ordinal(), true));
            if (this.parentConnection.getSSLConfig().getStringValue(Parameters.CipherSuites.ordinal(), null) != null) {
                sslSocket.setEnabledCipherSuites(this.parentConnection.getSSLConfig().getStringValue(Parameters.CipherSuites.ordinal(), null).split(","));
            }
            this.inputStream = sslSocket.getInputStream();
            this.outputStream = sslSocket.getOutputStream();
            this.plainSocket = sslSocket;
            if (this.client) {
                sslSocket.setUseClientMode(true);
                sslSocket.addHandshakeCompletedListener(this.handshakeListener);
                sslSocket.startHandshake();
            } else {
                sslSocket.addHandshakeCompletedListener(this.handshakeListener);
                sslSocket.setUseClientMode(false);
            }
        }
        catch (Exception e) {
            throw new NotInitializedException(e);
        }
    }

    private void clearBuffer() throws IOException {
        this.bufferSize = 4096;
        this.buffer = ByteBuffer.allocate(this.bufferSize);
    }

    private class ReadTask
    implements Runnable {
        private ReadTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block19: {
                logger.debug("Transport is started. Socket is [{}]", (Object)TLSTransportClient.this.socketDescription);
                while (!TLSTransportClient.this.stop) {
                    int dataLength = TLSTransportClient.this.inputStream.read(TLSTransportClient.this.buffer.array());
                    logger.debug("Just read [{}] bytes on [{}]", (Object)dataLength, (Object)TLSTransportClient.this.socketDescription);
                    if (dataLength == -1) break;
                    TLSTransportClient.this.buffer.position(dataLength);
                    TLSTransportClient.this.buffer.flip();
                    byte[] data = new byte[TLSTransportClient.this.buffer.limit()];
                    TLSTransportClient.this.buffer.get(data);
                    TLSTransportClient.this.append(data);
                    TLSTransportClient.this.buffer.clear();
                }
                Object var4_6 = null;
                try {
                    TLSTransportClient.this.clearBuffer();
                    if (TLSTransportClient.this.plainSocket != null && !TLSTransportClient.this.plainSocket.isClosed()) {
                        TLSTransportClient.this.plainSocket.close();
                    }
                    TLSTransportClient.this.getParent().onDisconnect();
                }
                catch (Exception e2) {
                    logger.debug("Error", (Throwable)e2);
                }
                TLSTransportClient.this.stop = false;
                logger.info("Read thread is stopped for socket [{}]", (Object)TLSTransportClient.this.socketDescription);
                {
                    break block19;
                    catch (ClosedByInterruptException e) {
                        logger.debug("Transport exception ", (Throwable)e);
                        Object var4_7 = null;
                        try {
                            TLSTransportClient.this.clearBuffer();
                            if (TLSTransportClient.this.plainSocket != null && !TLSTransportClient.this.plainSocket.isClosed()) {
                                TLSTransportClient.this.plainSocket.close();
                            }
                            TLSTransportClient.this.getParent().onDisconnect();
                        }
                        catch (Exception e2) {
                            logger.debug("Error", (Throwable)e2);
                        }
                        TLSTransportClient.this.stop = false;
                        logger.info("Read thread is stopped for socket [{}]", (Object)TLSTransportClient.this.socketDescription);
                        break block19;
                    }
                    catch (AsynchronousCloseException e) {
                        logger.debug("Transport exception ", (Throwable)e);
                        Object var4_8 = null;
                        try {
                            TLSTransportClient.this.clearBuffer();
                            if (TLSTransportClient.this.plainSocket != null && !TLSTransportClient.this.plainSocket.isClosed()) {
                                TLSTransportClient.this.plainSocket.close();
                            }
                            TLSTransportClient.this.getParent().onDisconnect();
                        }
                        catch (Exception e2) {
                            logger.debug("Error", (Throwable)e2);
                        }
                        TLSTransportClient.this.stop = false;
                        logger.info("Read thread is stopped for socket [{}]", (Object)TLSTransportClient.this.socketDescription);
                        break block19;
                    }
                    catch (Throwable e) {
                        logger.debug("Transport exception ", e);
                        Object var4_9 = null;
                        try {
                            TLSTransportClient.this.clearBuffer();
                            if (TLSTransportClient.this.plainSocket != null && !TLSTransportClient.this.plainSocket.isClosed()) {
                                TLSTransportClient.this.plainSocket.close();
                            }
                            TLSTransportClient.this.getParent().onDisconnect();
                        }
                        catch (Exception e2) {
                            logger.debug("Error", (Throwable)e2);
                        }
                        TLSTransportClient.this.stop = false;
                        logger.info("Read thread is stopped for socket [{}]", (Object)TLSTransportClient.this.socketDescription);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_10 = null;
                    try {
                        TLSTransportClient.this.clearBuffer();
                        if (TLSTransportClient.this.plainSocket != null && !TLSTransportClient.this.plainSocket.isClosed()) {
                            TLSTransportClient.this.plainSocket.close();
                        }
                        TLSTransportClient.this.getParent().onDisconnect();
                    }
                    catch (Exception e2) {
                        logger.debug("Error", (Throwable)e2);
                    }
                    TLSTransportClient.this.stop = false;
                    logger.info("Read thread is stopped for socket [{}]", (Object)TLSTransportClient.this.socketDescription);
                    throw throwable;
                }
            }
        }
    }

    private class DiameterSSLHandshakeListener
    implements HandshakeCompletedListener {
        private DiameterSSLHandshakeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handshakeCompleted(HandshakeCompletedEvent event) {
            try {
                TLSTransportClient.this.lock.lock();
                TLSTransportClient.this.shaking = false;
                TLSTransportClient.this.shaken = true;
                ((SSLSocket)TLSTransportClient.this.plainSocket).removeHandshakeCompletedListener(this);
                TLSTransportClient.this.getParent().onConnected();
                Object var3_2 = null;
                TLSTransportClient.this.lock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                TLSTransportClient.this.lock.unlock();
                throw throwable;
            }
        }
    }
}

