/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.transport.tls;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.OverloadException;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.io.IConnection;
import org.jdiameter.client.api.io.IConnectionListener;
import org.jdiameter.client.api.io.TransportError;
import org.jdiameter.client.api.io.TransportException;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.impl.transport.tls.TLSTransportClient;
import org.jdiameter.client.impl.transport.tls.TLSUtils;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLSClientConnection
implements IConnection {
    private static Logger logger = LoggerFactory.getLogger(TLSClientConnection.class);
    private TLSTransportClient client;
    private SSLSocketFactory factory;
    private Configuration sslConfig;
    private final long createdTime;
    private LinkedBlockingQueue<Event> buffer = new LinkedBlockingQueue(64);
    private Lock lock = new ReentrantLock();
    private ConcurrentLinkedQueue<IConnectionListener> listeners = new ConcurrentLinkedQueue();
    private String cachedKey = null;

    public TLSClientConnection(Configuration config, IConcurrentFactory concurrentFactory, InetAddress remoteAddress, int remotePort, InetAddress localAddress, int localPort, IMessageParser parser, String ref) {
        this.createdTime = System.currentTimeMillis();
        this.client = new TLSTransportClient(this, concurrentFactory, parser);
        this.client.setDestAddress(new InetSocketAddress(remoteAddress, remotePort));
        this.client.setOrigAddress(new InetSocketAddress(localAddress, localPort));
        try {
            if (ref == null) {
                throw new Exception("Can not create connection without TLS parameters");
            }
            logger.trace("Initializing TLS with reference '{}'", (Object)ref);
            this.fillSecurityData(config, ref);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public TLSClientConnection(Configuration config, IConcurrentFactory concurrentFactory, InetAddress remoteAddress, int remotePort, InetAddress localAddress, int localPort, IConnectionListener listener, IMessageParser parser, String ref) {
        this.createdTime = System.currentTimeMillis();
        this.listeners.add(listener);
        this.client = new TLSTransportClient(this, concurrentFactory, parser);
        this.client.setDestAddress(new InetSocketAddress(remoteAddress, remotePort));
        this.client.setOrigAddress(new InetSocketAddress(localAddress, localPort));
        try {
            if (ref == null) {
                throw new Exception("Can not create connection without TLS parameters");
            }
            logger.trace("Initializing TLS with reference '{}'", (Object)ref);
            this.fillSecurityData(config, ref);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public TLSClientConnection(Configuration config, Configuration localPeerSSLConfig, IConcurrentFactory concurrentFactory, Socket socket, IMessageParser parser) throws Exception {
        this.createdTime = System.currentTimeMillis();
        this.sslConfig = localPeerSSLConfig;
        this.client = new TLSTransportClient(this, concurrentFactory, parser);
        this.client.setDestAddress(new InetSocketAddress(socket.getRemoteSocketAddress().toString(), socket.getPort()));
        this.client.setOrigAddress(new InetSocketAddress(socket.getInetAddress().getHostAddress(), socket.getLocalPort()));
        this.client.initialize(socket);
        this.client.start();
        try {
            if (localPeerSSLConfig == null) {
                throw new Exception("Can not create connection without TLS parameters");
            }
            this.fillSecurityData(localPeerSSLConfig);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void fillSecurityData(Configuration config, String ref) throws Exception {
        this.sslConfig = TLSUtils.getSSLConfiguration(config, ref);
        if (this.sslConfig == null) {
            throw new Exception("Incorrect reference to secutity data");
        }
        this.factory = this.getSSLContext(this.sslConfig);
    }

    private void fillSecurityData(Configuration config) throws Exception {
        this.factory = this.getSSLContext(config);
    }

    protected TLSTransportClient getClient() {
        return this.client;
    }

    public Configuration getSSLConfig() {
        return this.sslConfig;
    }

    public SSLSocketFactory getSSLFactory() {
        return this.factory;
    }

    private SSLSocketFactory getSSLContext(Configuration sslConfig) throws Exception {
        SSLContext ctx = TLSUtils.getSecureContext(sslConfig);
        return ctx.getSocketFactory();
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.getClient().getDestAddress().getAddress();
    }

    @Override
    public int getRemotePort() {
        return this.getClient().getDestAddress().getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionListener(IConnectionListener listener) {
        this.lock.lock();
        try {
            this.listeners.add(listener);
            if (this.buffer.size() != 0) {
                for (Event e : this.buffer) {
                    try {
                        this.onEvent(e);
                    }
                    catch (AvpDataException e1) {}
                }
                this.buffer.clear();
            }
            Object var6_5 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remAllConnectionListener() {
        this.lock.lock();
        try {
            this.listeners.clear();
            Object var2_1 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remConnectionListener(IConnectionListener listener) {
        this.lock.lock();
        try {
            this.listeners.remove(listener);
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    @Override
    public void release() throws IOException {
        try {
            block4: {
                try {
                    if (this.getClient() == null) break block4;
                    this.getClient().release();
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            }
            Object var3_1 = null;
            this.buffer.clear();
            this.remAllConnectionListener();
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.buffer.clear();
            this.remAllConnectionListener();
            throw throwable;
        }
    }

    public boolean isWrapperFor(Class<?> aClass) throws InternalException {
        return false;
    }

    public <T> T unwrap(Class<T> aClass) throws InternalException {
        return null;
    }

    @Override
    public boolean isConnected() {
        return this.getClient() != null && this.getClient().isConnected();
    }

    @Override
    public boolean isNetworkInitiated() {
        return false;
    }

    @Override
    public String getKey() {
        if (this.cachedKey == null) {
            this.cachedKey = new StringBuffer("aaas://").append(this.getRemoteAddress().getHostName()).append(":").append(this.getRemotePort()).toString();
        }
        return this.cachedKey;
    }

    @Override
    public void connect() throws TransportException {
        try {
            this.getClient().initialize();
            this.getClient().start();
        }
        catch (IOException e) {
            throw new TransportException("Cannot init transport: ", TransportError.NetWorkError, e);
        }
        catch (Exception e) {
            throw new TransportException("Cannot init transport: ", TransportError.Internal, e);
        }
    }

    @Override
    public void disconnect() throws InternalError {
        try {
            if (this.getClient() != null) {
                this.getClient().stop();
            }
        }
        catch (Exception e) {
            throw new InternalError("Error while stopping transport: " + e.getMessage());
        }
    }

    @Override
    public void sendMessage(IMessage message) throws TransportException, OverloadException {
        try {
            if (this.getClient() != null) {
                this.getClient().sendMessage(message);
            }
        }
        catch (Exception e) {
            throw new TransportException("Cannot send message: ", TransportError.FailedSendMessage, e);
        }
    }

    protected void onDisconnect() throws AvpDataException {
        this.onEvent(new Event(EventType.DISCONNECTED));
    }

    protected void onMessageReceived(IMessage message) throws AvpDataException {
        this.onEvent(new Event(EventType.MESSAGE_RECEIVED, message));
    }

    protected void onAvpDataException(AvpDataException e) {
        try {
            this.onEvent(new Event(EventType.DATA_EXCEPTION, (Exception)((Object)e)));
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    protected void onConnected() {
        try {
            this.onEvent(new Event(EventType.CONNECTED));
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEvent(Event event) throws AvpDataException {
        this.lock.lock();
        try {
            if (this.processBufferedMessages(event)) {
                for (IConnectionListener listener : this.listeners) {
                    switch (event.type) {
                        case CONNECTED: {
                            listener.connectionOpened(this.getKey());
                            break;
                        }
                        case DISCONNECTED: {
                            listener.connectionClosed(this.getKey(), null);
                            break;
                        }
                        case MESSAGE_RECEIVED: {
                            listener.messageReceived(this.getKey(), event.message);
                            break;
                        }
                        case DATA_EXCEPTION: {
                            listener.internalError(this.getKey(), null, new TransportException("Avp Data Exception:", TransportError.ReceivedBrokenMessage, event.exception));
                        }
                    }
                }
            }
            Object var5_4 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    protected boolean processBufferedMessages(Event event) throws AvpDataException {
        if (this.listeners.size() == 0) {
            try {
                this.buffer.add(event);
            }
            catch (IllegalStateException e) {
                Event[] tempBuffer = this.buffer.toArray(new Event[this.buffer.size()]);
                this.buffer.remove(tempBuffer[tempBuffer.length - 1]);
                this.buffer.add(event);
            }
            return false;
        }
        return true;
    }

    private static class Event {
        EventType type;
        IMessage message;
        Exception exception;

        Event(EventType type) {
            this.type = type;
        }

        Event(EventType type, Exception exception) {
            this(type);
            this.exception = exception;
        }

        Event(EventType type, IMessage message) {
            this(type);
            this.message = message;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EventType {
        CONNECTED,
        DISCONNECTED,
        MESSAGE_RECEIVED,
        DATA_EXCEPTION;

    }
}

